/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml;

import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.xml.CoreParser;
import org.apache.lucene.queryparser.xml.CorePlusExtensionsParser;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.queryparser.xml.QueryTemplateManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.LuceneTestCase;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TestQueryTemplateManager
extends LuceneTestCase {
    private CoreParser builder;
    private Analyzer analyzer;
    private IndexSearcher searcher;
    private IndexReader reader;
    private Directory dir;
    String[] docFieldValues = new String[]{"artist=Jeff Buckley \talbum=Grace \treleaseDate=1999 \tgenre=rock", "artist=Fugazi \talbum=Repeater \treleaseDate=1990 \tgenre=alternative", "artist=Fugazi \talbum=Red Medicine \treleaseDate=1995 \tgenre=alternative", "artist=Peeping Tom \talbum=Peeping Tom \treleaseDate=2006 \tgenre=rock", "artist=Red Snapper \talbum=Prince Blimey \treleaseDate=1996 \tgenre=electronic"};
    String[] queryForms = new String[]{"artist=Fugazi \texpectedMatches=2 \ttemplate=albumBooleanQuery", "artist=Fugazi \treleaseDate=1990 \texpectedMatches=1 \ttemplate=albumBooleanQuery", "artist=Buckley \tgenre=rock \texpectedMatches=1 \ttemplate=albumFilteredQuery", "artist=Buckley \tgenre=electronic \texpectedMatches=0 \ttemplate=albumFilteredQuery", "queryString=artist:buckly~ NOT genre:electronic \texpectedMatches=1 \ttemplate=albumLuceneClassicQuery"};

    public void testFormTransforms() throws SAXException, IOException, ParserConfigurationException, TransformerException, ParserException {
        TestQueryTemplateManager.assumeFalse((String)"test temporarily disabled on J9, see https://issues.apache.org/jira/browse/LUCENE-6556", (boolean)Constants.JAVA_VENDOR.startsWith("IBM"));
        QueryTemplateManager qtm = new QueryTemplateManager();
        qtm.addQueryTemplate("albumBooleanQuery", ((Object)((Object)this)).getClass().getResourceAsStream("albumBooleanQuery.xsl"));
        qtm.addQueryTemplate("albumFilteredQuery", ((Object)((Object)this)).getClass().getResourceAsStream("albumFilteredQuery.xsl"));
        qtm.addQueryTemplate("albumLuceneClassicQuery", ((Object)((Object)this)).getClass().getResourceAsStream("albumLuceneClassicQuery.xsl"));
        for (String queryForm : this.queryForms) {
            Properties queryFormProperties = this.getPropsFromString(queryForm);
            Document doc = qtm.getQueryAsDOM(queryFormProperties, queryFormProperties.getProperty("template"));
            Query q = this.builder.getQuery(doc.getDocumentElement());
            int h = this.searcher.search((Query)q, (int)1000).totalHits;
            int expectedHits = Integer.parseInt(queryFormProperties.getProperty("expectedMatches"));
            TestQueryTemplateManager.assertEquals((String)("Number of results should match for query " + queryForm), (long)expectedHits, (long)h);
        }
    }

    Properties getPropsFromString(String nameValuePairs) {
        Properties result = new Properties();
        StringTokenizer st = new StringTokenizer(nameValuePairs, "\t=");
        while (st.hasMoreTokens()) {
            String name = st.nextToken().trim();
            if (!st.hasMoreTokens()) continue;
            String value = st.nextToken().trim();
            result.setProperty(name, value);
        }
        return result;
    }

    org.apache.lucene.document.Document getDocumentFromString(String nameValuePairs) {
        org.apache.lucene.document.Document result = new org.apache.lucene.document.Document();
        StringTokenizer st = new StringTokenizer(nameValuePairs, "\t=");
        while (st.hasMoreTokens()) {
            String name = st.nextToken().trim();
            if (!st.hasMoreTokens()) continue;
            String value = st.nextToken().trim();
            result.add((IndexableField)TestQueryTemplateManager.newTextField((String)name, (String)value, (Field.Store)Field.Store.YES));
        }
        return result;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new MockAnalyzer(TestQueryTemplateManager.random());
        this.dir = TestQueryTemplateManager.newDirectory();
        IndexWriter w = new IndexWriter(this.dir, TestQueryTemplateManager.newIndexWriterConfig((Analyzer)this.analyzer));
        for (String docFieldValue : this.docFieldValues) {
            w.addDocument((Iterable)this.getDocumentFromString(docFieldValue));
        }
        w.forceMerge(1);
        w.close();
        this.reader = DirectoryReader.open((Directory)this.dir);
        this.searcher = TestQueryTemplateManager.newSearcher((IndexReader)this.reader);
        this.builder = new CorePlusExtensionsParser("artist", this.analyzer);
    }

    public void tearDown() throws Exception {
        this.reader.close();
        this.dir.close();
        super.tearDown();
    }
}

