/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml.builders;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.queryparser.xml.builders.LegacyNumericRangeQueryBuilder;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.LuceneTestCase;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TestNumericRangeQueryBuilder
extends LuceneTestCase {
    public void testGetFilterHandleNumericParseErrorStrict() throws Exception {
        LegacyNumericRangeQueryBuilder filterBuilder = new LegacyNumericRangeQueryBuilder();
        String xml = "<LegacyNumericRangeQuery fieldName='AGE' type='int' lowerTerm='-1' upperTerm='NaN'/>";
        Document doc = TestNumericRangeQueryBuilder.getDocumentFromString(xml);
        try {
            filterBuilder.getQuery(doc.getDocumentElement());
        }
        catch (ParserException e) {
            return;
        }
        TestNumericRangeQueryBuilder.fail((String)("Expected to throw " + ParserException.class));
    }

    public void testGetFilterInt() throws Exception {
        LegacyNumericRangeQueryBuilder filterBuilder = new LegacyNumericRangeQueryBuilder();
        String xml = "<LegacyNumericRangeQuery fieldName='AGE' type='int' lowerTerm='-1' upperTerm='10'/>";
        Document doc = TestNumericRangeQueryBuilder.getDocumentFromString(xml);
        Query filter = filterBuilder.getQuery(doc.getDocumentElement());
        TestNumericRangeQueryBuilder.assertTrue((boolean)(filter instanceof LegacyNumericRangeQuery));
        LegacyNumericRangeQuery numRangeFilter = (LegacyNumericRangeQuery)filter;
        TestNumericRangeQueryBuilder.assertEquals((Object)-1, (Object)numRangeFilter.getMin());
        TestNumericRangeQueryBuilder.assertEquals((Object)10, (Object)numRangeFilter.getMax());
        TestNumericRangeQueryBuilder.assertEquals((Object)"AGE", (Object)numRangeFilter.getField());
        TestNumericRangeQueryBuilder.assertTrue((boolean)numRangeFilter.includesMin());
        TestNumericRangeQueryBuilder.assertTrue((boolean)numRangeFilter.includesMax());
        String xml2 = "<LegacyNumericRangeQuery fieldName='AGE' type='int' lowerTerm='-1' upperTerm='10' includeUpper='false'/>";
        Document doc2 = TestNumericRangeQueryBuilder.getDocumentFromString(xml2);
        Query filter2 = filterBuilder.getQuery(doc2.getDocumentElement());
        TestNumericRangeQueryBuilder.assertTrue((boolean)(filter2 instanceof LegacyNumericRangeQuery));
        LegacyNumericRangeQuery numRangeFilter2 = (LegacyNumericRangeQuery)filter2;
        TestNumericRangeQueryBuilder.assertEquals((Object)-1, (Object)numRangeFilter2.getMin());
        TestNumericRangeQueryBuilder.assertEquals((Object)10, (Object)numRangeFilter2.getMax());
        TestNumericRangeQueryBuilder.assertEquals((Object)"AGE", (Object)numRangeFilter2.getField());
        TestNumericRangeQueryBuilder.assertTrue((boolean)numRangeFilter2.includesMin());
        TestNumericRangeQueryBuilder.assertFalse((boolean)numRangeFilter2.includesMax());
    }

    public void testGetFilterLong() throws Exception {
        LegacyNumericRangeQueryBuilder filterBuilder = new LegacyNumericRangeQueryBuilder();
        String xml = "<LegacyNumericRangeQuery fieldName='AGE' type='LoNg' lowerTerm='-2321' upperTerm='60000000'/>";
        Document doc = TestNumericRangeQueryBuilder.getDocumentFromString(xml);
        Query filter = filterBuilder.getQuery(doc.getDocumentElement());
        TestNumericRangeQueryBuilder.assertTrue((boolean)(filter instanceof LegacyNumericRangeQuery));
        LegacyNumericRangeQuery numRangeFilter = (LegacyNumericRangeQuery)filter;
        TestNumericRangeQueryBuilder.assertEquals((Object)-2321L, (Object)numRangeFilter.getMin());
        TestNumericRangeQueryBuilder.assertEquals((Object)60000000L, (Object)numRangeFilter.getMax());
        TestNumericRangeQueryBuilder.assertEquals((Object)"AGE", (Object)numRangeFilter.getField());
        TestNumericRangeQueryBuilder.assertTrue((boolean)numRangeFilter.includesMin());
        TestNumericRangeQueryBuilder.assertTrue((boolean)numRangeFilter.includesMax());
        String xml2 = "<LegacyNumericRangeQuery fieldName='AGE' type='LoNg' lowerTerm='-2321' upperTerm='60000000' includeUpper='false'/>";
        Document doc2 = TestNumericRangeQueryBuilder.getDocumentFromString(xml2);
        Query filter2 = filterBuilder.getQuery(doc2.getDocumentElement());
        TestNumericRangeQueryBuilder.assertTrue((boolean)(filter2 instanceof LegacyNumericRangeQuery));
        LegacyNumericRangeQuery numRangeFilter2 = (LegacyNumericRangeQuery)filter2;
        TestNumericRangeQueryBuilder.assertEquals((Object)-2321L, (Object)numRangeFilter2.getMin());
        TestNumericRangeQueryBuilder.assertEquals((Object)60000000L, (Object)numRangeFilter2.getMax());
        TestNumericRangeQueryBuilder.assertEquals((Object)"AGE", (Object)numRangeFilter2.getField());
        TestNumericRangeQueryBuilder.assertTrue((boolean)numRangeFilter2.includesMin());
        TestNumericRangeQueryBuilder.assertFalse((boolean)numRangeFilter2.includesMax());
    }

    public void testGetFilterDouble() throws Exception {
        LegacyNumericRangeQueryBuilder filterBuilder = new LegacyNumericRangeQueryBuilder();
        String xml = "<LegacyNumericRangeQuery fieldName='AGE' type='doubLe' lowerTerm='-23.21' upperTerm='60000.00023'/>";
        Document doc = TestNumericRangeQueryBuilder.getDocumentFromString(xml);
        Query filter = filterBuilder.getQuery(doc.getDocumentElement());
        TestNumericRangeQueryBuilder.assertTrue((boolean)(filter instanceof LegacyNumericRangeQuery));
        LegacyNumericRangeQuery numRangeFilter = (LegacyNumericRangeQuery)filter;
        TestNumericRangeQueryBuilder.assertEquals((Object)-23.21, (Object)numRangeFilter.getMin());
        TestNumericRangeQueryBuilder.assertEquals((Object)60000.00023, (Object)numRangeFilter.getMax());
        TestNumericRangeQueryBuilder.assertEquals((Object)"AGE", (Object)numRangeFilter.getField());
        TestNumericRangeQueryBuilder.assertTrue((boolean)numRangeFilter.includesMin());
        TestNumericRangeQueryBuilder.assertTrue((boolean)numRangeFilter.includesMax());
        String xml2 = "<LegacyNumericRangeQuery fieldName='AGE' type='doubLe' lowerTerm='-23.21' upperTerm='60000.00023' includeUpper='false'/>";
        Document doc2 = TestNumericRangeQueryBuilder.getDocumentFromString(xml2);
        Query filter2 = filterBuilder.getQuery(doc2.getDocumentElement());
        TestNumericRangeQueryBuilder.assertTrue((boolean)(filter2 instanceof LegacyNumericRangeQuery));
        LegacyNumericRangeQuery numRangeFilter2 = (LegacyNumericRangeQuery)filter2;
        TestNumericRangeQueryBuilder.assertEquals((Object)-23.21, (Object)numRangeFilter2.getMin());
        TestNumericRangeQueryBuilder.assertEquals((Object)60000.00023, (Object)numRangeFilter2.getMax());
        TestNumericRangeQueryBuilder.assertEquals((Object)"AGE", (Object)numRangeFilter2.getField());
        TestNumericRangeQueryBuilder.assertTrue((boolean)numRangeFilter2.includesMin());
        TestNumericRangeQueryBuilder.assertFalse((boolean)numRangeFilter2.includesMax());
    }

    public void testGetFilterFloat() throws Exception {
        LegacyNumericRangeQueryBuilder filterBuilder = new LegacyNumericRangeQueryBuilder();
        String xml = "<LegacyNumericRangeQuery fieldName='AGE' type='FLOAT' lowerTerm='-2.321432' upperTerm='32432.23'/>";
        Document doc = TestNumericRangeQueryBuilder.getDocumentFromString(xml);
        Query filter = filterBuilder.getQuery(doc.getDocumentElement());
        TestNumericRangeQueryBuilder.assertTrue((boolean)(filter instanceof LegacyNumericRangeQuery));
        LegacyNumericRangeQuery numRangeFilter = (LegacyNumericRangeQuery)filter;
        TestNumericRangeQueryBuilder.assertEquals((Object)Float.valueOf(-2.321432f), (Object)numRangeFilter.getMin());
        TestNumericRangeQueryBuilder.assertEquals((Object)Float.valueOf(32432.23f), (Object)numRangeFilter.getMax());
        TestNumericRangeQueryBuilder.assertEquals((Object)"AGE", (Object)numRangeFilter.getField());
        TestNumericRangeQueryBuilder.assertTrue((boolean)numRangeFilter.includesMin());
        TestNumericRangeQueryBuilder.assertTrue((boolean)numRangeFilter.includesMax());
        String xml2 = "<LegacyNumericRangeQuery fieldName='AGE' type='FLOAT' lowerTerm='-2.321432' upperTerm='32432.23' includeUpper='false' precisionStep='2' />";
        Document doc2 = TestNumericRangeQueryBuilder.getDocumentFromString(xml2);
        Query filter2 = filterBuilder.getQuery(doc2.getDocumentElement());
        TestNumericRangeQueryBuilder.assertTrue((boolean)(filter2 instanceof LegacyNumericRangeQuery));
        LegacyNumericRangeQuery numRangeFilter2 = (LegacyNumericRangeQuery)filter2;
        TestNumericRangeQueryBuilder.assertEquals((Object)Float.valueOf(-2.321432f), (Object)numRangeFilter2.getMin());
        TestNumericRangeQueryBuilder.assertEquals((Object)Float.valueOf(32432.23f), (Object)numRangeFilter2.getMax());
        TestNumericRangeQueryBuilder.assertEquals((Object)"AGE", (Object)numRangeFilter2.getField());
        TestNumericRangeQueryBuilder.assertTrue((boolean)numRangeFilter2.includesMin());
        TestNumericRangeQueryBuilder.assertFalse((boolean)numRangeFilter2.includesMax());
    }

    private static Document getDocumentFromString(String str) throws SAXException, IOException, ParserConfigurationException {
        ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(is);
        ((InputStream)is).close();
        return doc;
    }
}

