/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import java.util.ArrayList;
import java.util.Random;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.util.SloppyMath;

final class GeoPointTestUtil {
    GeoPointTestUtil() {
    }

    public static double nextLatitude() {
        return -90.0 + 180.0 * GeoPointTestUtil.random().nextDouble();
    }

    public static double nextLongitude() {
        return -180.0 + 360.0 * GeoPointTestUtil.random().nextDouble();
    }

    public static double nextLatitudeNear(double otherLatitude) {
        GeoUtils.checkLatitude((double)otherLatitude);
        return GeoPointTestUtil.normalizeLatitude(otherLatitude + GeoPointTestUtil.random().nextDouble() - 0.5);
    }

    public static double nextLongitudeNear(double otherLongitude) {
        GeoUtils.checkLongitude((double)otherLongitude);
        return GeoPointTestUtil.normalizeLongitude(otherLongitude + GeoPointTestUtil.random().nextDouble() - 0.5);
    }

    public static double nextLatitudeAround(double minLatitude, double maxLatitude) {
        GeoUtils.checkLatitude((double)minLatitude);
        GeoUtils.checkLatitude((double)maxLatitude);
        return GeoPointTestUtil.normalizeLatitude(GeoPointTestUtil.randomRangeMaybeSlightlyOutside(minLatitude, maxLatitude));
    }

    public static double nextLongitudeAround(double minLongitude, double maxLongitude) {
        GeoUtils.checkLongitude((double)minLongitude);
        GeoUtils.checkLongitude((double)maxLongitude);
        return GeoPointTestUtil.normalizeLongitude(GeoPointTestUtil.randomRangeMaybeSlightlyOutside(minLongitude, maxLongitude));
    }

    public static Rectangle nextBox() {
        return GeoPointTestUtil.nextBoxInternal(GeoPointTestUtil.nextLatitude(), GeoPointTestUtil.nextLatitude(), GeoPointTestUtil.nextLongitude(), GeoPointTestUtil.nextLongitude(), true);
    }

    public static Rectangle nextSimpleBox() {
        return GeoPointTestUtil.nextBoxInternal(GeoPointTestUtil.nextLatitude(), GeoPointTestUtil.nextLatitude(), GeoPointTestUtil.nextLongitude(), GeoPointTestUtil.nextLongitude(), false);
    }

    public static Rectangle nextBoxNear(double otherLatitude, double otherLongitude) {
        GeoUtils.checkLongitude((double)otherLongitude);
        GeoUtils.checkLongitude((double)otherLongitude);
        return GeoPointTestUtil.nextBoxInternal(GeoPointTestUtil.nextLatitudeNear(otherLatitude), GeoPointTestUtil.nextLatitudeNear(otherLatitude), GeoPointTestUtil.nextLongitudeNear(otherLongitude), GeoPointTestUtil.nextLongitudeNear(otherLongitude), true);
    }

    public static Rectangle nextSimpleBoxNear(double otherLatitude, double otherLongitude) {
        GeoUtils.checkLongitude((double)otherLongitude);
        GeoUtils.checkLongitude((double)otherLongitude);
        return GeoPointTestUtil.nextBoxInternal(GeoPointTestUtil.nextLatitudeNear(otherLatitude), GeoPointTestUtil.nextLatitudeNear(otherLatitude), GeoPointTestUtil.nextLongitudeNear(otherLongitude), GeoPointTestUtil.nextLongitudeNear(otherLongitude), false);
    }

    public static Polygon nextPolygon() {
        if (GeoPointTestUtil.random().nextBoolean()) {
            return GeoPointTestUtil.surpriseMePolygon(null, null);
        }
        Rectangle box = GeoPointTestUtil.nextBoxInternal(GeoPointTestUtil.nextLatitude(), GeoPointTestUtil.nextLatitude(), GeoPointTestUtil.nextLongitude(), GeoPointTestUtil.nextLongitude(), false);
        if (GeoPointTestUtil.random().nextBoolean()) {
            return GeoPointTestUtil.boxPolygon(box);
        }
        return GeoPointTestUtil.trianglePolygon(box);
    }

    public static Polygon nextPolygonNear(double otherLatitude, double otherLongitude) {
        if (GeoPointTestUtil.random().nextBoolean()) {
            return GeoPointTestUtil.surpriseMePolygon(otherLatitude, otherLongitude);
        }
        Rectangle box = GeoPointTestUtil.nextBoxInternal(GeoPointTestUtil.nextLatitudeNear(otherLatitude), GeoPointTestUtil.nextLatitudeNear(otherLatitude), GeoPointTestUtil.nextLongitudeNear(otherLongitude), GeoPointTestUtil.nextLongitudeNear(otherLongitude), false);
        if (GeoPointTestUtil.random().nextBoolean()) {
            return GeoPointTestUtil.boxPolygon(box);
        }
        return GeoPointTestUtil.trianglePolygon(box);
    }

    private static Rectangle nextBoxInternal(double lat0, double lat1, double lon0, double lon1, boolean canCrossDateLine) {
        double x;
        if (lat1 < lat0) {
            x = lat0;
            lat0 = lat1;
            lat1 = x;
        }
        if (!canCrossDateLine && lon1 < lon0) {
            x = lon0;
            lon0 = lon1;
            lon1 = x;
        }
        return new Rectangle(lat0, lat1, lon0, lon1);
    }

    private static Polygon boxPolygon(Rectangle box) {
        assert (!box.crossesDateline());
        double[] polyLats = new double[5];
        double[] polyLons = new double[5];
        polyLats[0] = box.minLat;
        polyLons[0] = box.minLon;
        polyLats[1] = box.maxLat;
        polyLons[1] = box.minLon;
        polyLats[2] = box.maxLat;
        polyLons[2] = box.maxLon;
        polyLats[3] = box.minLat;
        polyLons[3] = box.maxLon;
        polyLats[4] = box.minLat;
        polyLons[4] = box.minLon;
        return new Polygon(polyLats, polyLons, new Polygon[0]);
    }

    private static Polygon trianglePolygon(Rectangle box) {
        assert (!box.crossesDateline());
        double[] polyLats = new double[4];
        double[] polyLons = new double[4];
        polyLats[0] = box.minLat;
        polyLons[0] = box.minLon;
        polyLats[1] = box.maxLat;
        polyLons[1] = box.minLon;
        polyLats[2] = box.maxLat;
        polyLons[2] = box.maxLon;
        polyLats[3] = box.minLat;
        polyLons[3] = box.minLon;
        return new Polygon(polyLats, polyLons, new Polygon[0]);
    }

    /*
     * Unable to fully structure code
     */
    private static Polygon surpriseMePolygon(Double otherLatitude, Double otherLongitude) {
        block0: while (true) {
            if (otherLatitude == null) {
                centerLat = GeoPointTestUtil.nextLatitude();
                centerLon = GeoPointTestUtil.nextLongitude();
            } else {
                GeoUtils.checkLatitude((double)otherLatitude);
                GeoUtils.checkLongitude((double)otherLongitude);
                centerLat = GeoPointTestUtil.nextLatitudeNear(otherLatitude);
                centerLon = GeoPointTestUtil.nextLongitudeNear(otherLongitude);
            }
            radius = 0.1 + 20.0 * GeoPointTestUtil.random().nextDouble();
            radiusDelta = GeoPointTestUtil.random().nextDouble();
            lats = new ArrayList<Double>();
            lons = new ArrayList<Double>();
            angle = 0.0;
            while (!((angle += GeoPointTestUtil.random().nextDouble() * 40.0) > 360.0)) {
                len = radius * (1.0 - radiusDelta + radiusDelta * GeoPointTestUtil.random().nextDouble());
                lat = centerLat + len * Math.cos(SloppyMath.toRadians((double)angle));
                lon = centerLon + len * Math.sin(SloppyMath.toRadians((double)angle));
                if (lon <= -180.0 || lon >= 180.0) continue block0;
                if (lat > 90.0) {
                    lat = 180.0 - lat;
                    lon = 180.0 - lon;
                } else if (lat < -90.0) {
                    lat = -180.0 - lat;
                    lon = 180.0 - lon;
                }
                if (!(lon <= -180.0) && !(lon >= 180.0)) ** break;
                continue block0;
                lats.add(lat);
                lons.add(lon);
            }
            break;
        }
        lats.add((Double)lats.get(0));
        lons.add((Double)lons.get(0));
        latsArray = new double[lats.size()];
        lonsArray = new double[lons.size()];
        for (i = 0; i < lats.size(); ++i) {
            latsArray[i] = (Double)lats.get(i);
            lonsArray[i] = (Double)lons.get(i);
        }
        return new Polygon(latsArray, lonsArray, new Polygon[0]);
    }

    private static double randomRangeMaybeSlightlyOutside(double min, double max) {
        return min + (GeoPointTestUtil.random().nextDouble() + (0.5 - GeoPointTestUtil.random().nextDouble()) * 0.02) * (max - min);
    }

    private static double normalizeLatitude(double latitude) {
        if (latitude >= -90.0 && latitude <= 90.0) {
            return latitude;
        }
        double off = Math.abs((latitude + 90.0) % 360.0);
        return (off <= 180.0 ? off : 360.0 - off) - 90.0;
    }

    private static double normalizeLongitude(double longitude) {
        if (longitude >= -180.0 && longitude <= 180.0) {
            return longitude;
        }
        double off = (longitude + 180.0) % 360.0;
        if (off < 0.0) {
            return 180.0 + off;
        }
        if (off == 0.0 && longitude > 0.0) {
            return 180.0;
        }
        return -180.0 + off;
    }

    private static Random random() {
        return RandomizedContext.current().getRandom();
    }
}

