/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import org.apache.lucene.document.Document;
import org.apache.lucene.geo.BaseGeoPointTestCase;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointDistanceQuery;
import org.apache.lucene.spatial.geopoint.search.GeoPointInBBoxQuery;
import org.apache.lucene.spatial.geopoint.search.GeoPointInPolygonQuery;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;

public class TestGeoPointQuery
extends BaseGeoPointTestCase {
    protected double quantizeLat(double lat) {
        return GeoPointField.decodeLatitude((long)GeoPointField.encodeLatLon((double)lat, (double)0.0));
    }

    protected double quantizeLon(double lon) {
        return GeoPointField.decodeLongitude((long)GeoPointField.encodeLatLon((double)0.0, (double)lon));
    }

    protected void addPointToDoc(String field, Document doc, double lat, double lon) {
        doc.add((IndexableField)new GeoPointField(field, lat, lon, GeoPointField.PREFIX_TYPE_NOT_STORED));
    }

    protected Query newRectQuery(String field, double minLat, double maxLat, double minLon, double maxLon) {
        return new GeoPointInBBoxQuery(field, GeoPointField.TermEncoding.PREFIX, minLat, maxLat, minLon, maxLon);
    }

    protected Query newDistanceQuery(String field, double centerLat, double centerLon, double radiusMeters) {
        return new GeoPointDistanceQuery(field, GeoPointField.TermEncoding.PREFIX, centerLat, centerLon, radiusMeters);
    }

    protected Query newPolygonQuery(String field, Polygon ... polygons) {
        return new GeoPointInPolygonQuery(field, GeoPointField.TermEncoding.PREFIX, polygons);
    }

    public void testInvalidShift() throws Exception {
        BaseDirectoryWrapper dir = TestGeoPointQuery.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(TestGeoPointQuery.random(), (Directory)dir);
        Document document = new Document();
        this.addPointToDoc("field", document, 80.0, -65.0);
        writer.addDocument((Iterable)document);
        DirectoryReader reader = writer.getReader();
        IndexSearcher searcher = TestGeoPointQuery.newSearcher((IndexReader)reader);
        TestGeoPointQuery.assertEquals((long)0L, (long)searcher.count(this.newRectQuery("field", 90.0, 90.0, -180.0, 0.0)));
        reader.close();
        writer.close();
        dir.close();
    }
}

