/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import org.apache.lucene.document.Document;
import org.apache.lucene.geo.BaseGeoPointTestCase;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointDistanceQuery;
import org.apache.lucene.spatial.geopoint.search.GeoPointInBBoxQuery;
import org.apache.lucene.spatial.geopoint.search.GeoPointInPolygonQuery;
import org.apache.lucene.spatial.geopoint.search.GeoPointTestUtil;
import org.apache.lucene.util.LuceneTestCase;

@Deprecated
@LuceneTestCase.SuppressCodecs(value={"Direct"})
public class TestLegacyGeoPointQuery
extends BaseGeoPointTestCase {
    protected double quantizeLat(double lat) {
        return GeoPointField.decodeLatitude((long)GeoPointField.encodeLatLon((double)lat, (double)0.0));
    }

    protected double quantizeLon(double lon) {
        return GeoPointField.decodeLongitude((long)GeoPointField.encodeLatLon((double)0.0, (double)lon));
    }

    protected void addPointToDoc(String field, Document doc, double lat, double lon) {
        doc.add((IndexableField)new GeoPointField(field, lat, lon, GeoPointField.NUMERIC_TYPE_NOT_STORED));
    }

    protected Query newRectQuery(String field, double minLat, double maxLat, double minLon, double maxLon) {
        return new GeoPointInBBoxQuery(field, GeoPointField.TermEncoding.NUMERIC, minLat, maxLat, minLon, maxLon);
    }

    protected Query newDistanceQuery(String field, double centerLat, double centerLon, double radiusMeters) {
        return new GeoPointDistanceQuery(field, GeoPointField.TermEncoding.NUMERIC, centerLat, centerLon, radiusMeters);
    }

    protected Query newPolygonQuery(String field, Polygon ... polygons) {
        return new GeoPointInPolygonQuery(field, GeoPointField.TermEncoding.NUMERIC, polygons);
    }

    public void testRandomDistance() throws Exception {
        TestLegacyGeoPointQuery.assumeTrue((String)"legacy encoding is too slow/hangs on this test", (boolean)false);
    }

    public void testRandomDistanceHuge() throws Exception {
        TestLegacyGeoPointQuery.assumeTrue((String)"legacy encoding is too slow/hangs on this test", (boolean)false);
    }

    public void testSamePointManyTimes() throws Exception {
        TestLegacyGeoPointQuery.assumeTrue((String)"legacy encoding goes OOM on this test", (boolean)false);
    }

    protected double nextLongitude() {
        return GeoPointTestUtil.nextLongitude();
    }

    protected double nextLatitude() {
        return GeoPointTestUtil.nextLatitude();
    }

    protected Rectangle nextBox() {
        return GeoPointTestUtil.nextBox();
    }

    protected Polygon nextPolygon() {
        return GeoPointTestUtil.nextPolygon();
    }
}

