/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import org.apache.lucene.geo.GeoTestUtil;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.LuceneTestCase;

public class TestGeoPointField
extends LuceneTestCase {
    public void testGeoPrefixCoding() throws Exception {
        int numIters = TestGeoPointField.atLeast((int)1000);
        BytesRefBuilder brb = new BytesRefBuilder();
        while (numIters-- >= 0) {
            long hash = GeoPointField.encodeLatLon((double)GeoTestUtil.nextLatitude(), (double)GeoTestUtil.nextLongitude());
            for (int i = 32; i < 64; ++i) {
                GeoPointField.geoCodedToPrefixCoded((long)hash, (int)i, (BytesRefBuilder)brb);
                long decodedHash = GeoPointField.prefixCodedToGeoCoded((BytesRef)brb.get());
                TestGeoPointField.assertEquals((long)(hash >>> i << i), (long)decodedHash);
            }
        }
    }
}

