/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import java.util.Random;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.spatial.util.MortonEncoder;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.TestUtil;

public class TestMortonEncoder
extends LuceneTestCase {
    public void testMortonEncoding() throws Exception {
        long TRANSLATE = 0x80000000L;
        double LATITUDE_DECODE = 4.190951585769653E-8;
        double LONGITUDE_DECODE = 8.381903171539307E-8;
        Random random = TestMortonEncoder.random();
        for (int i = 0; i < 10000; ++i) {
            long encoded = TestMortonEncoder.random().nextLong();
            long encodedLat = BitUtil.deinterleave((long)(encoded >>> 1));
            long encodedLon = BitUtil.deinterleave((long)encoded);
            double expectedLat = GeoEncodingUtils.decodeLatitude((int)((int)(encodedLat - 0x80000000L)));
            double decodedLat = MortonEncoder.decodeLatitude((long)encoded);
            double expectedLon = GeoEncodingUtils.decodeLongitude((int)((int)(encodedLon - 0x80000000L)));
            double decodedLon = MortonEncoder.decodeLongitude((long)encoded);
            TestMortonEncoder.assertEquals((double)expectedLat, (double)decodedLat, (double)0.0);
            TestMortonEncoder.assertEquals((double)expectedLon, (double)decodedLon, (double)0.0);
            TestMortonEncoder.assertEquals((long)encoded, (long)MortonEncoder.encode((double)decodedLat, (double)decodedLon));
            if (encoded == -1L) continue;
            double maxLat = expectedLat + 4.190951585769653E-8;
            TestMortonEncoder.assertEquals((double)maxLat, (double)GeoEncodingUtils.decodeLatitude((int)((int)(++encodedLat - 0x80000000L))), (double)0.0);
            double maxLon = expectedLon + 8.381903171539307E-8;
            TestMortonEncoder.assertEquals((double)maxLon, (double)GeoEncodingUtils.decodeLongitude((int)((int)(++encodedLon - 0x80000000L))), (double)0.0);
            long encodedNext = MortonEncoder.encode((double)maxLat, (double)maxLon);
            TestMortonEncoder.assertEquals((long)BitUtil.interleave((int)((int)encodedLon), (int)((int)encodedLat)), (long)encodedNext);
            double minEdgeLat = Math.nextUp(expectedLat);
            double minEdgeLon = Math.nextUp(expectedLon);
            long encodedMinEdge = MortonEncoder.encode((double)minEdgeLat, (double)minEdgeLon);
            long encodedMinEdgeCeil = MortonEncoder.encodeCeil((double)minEdgeLat, (double)minEdgeLon);
            double maxEdgeLat = Math.nextDown(maxLat);
            double maxEdgeLon = Math.nextDown(maxLon);
            long encodedMaxEdge = MortonEncoder.encode((double)maxEdgeLat, (double)maxEdgeLon);
            long encodedMaxEdgeCeil = MortonEncoder.encodeCeil((double)maxEdgeLat, (double)maxEdgeLon);
            TestMortonEncoder.assertEquals((long)(encodedLat - 1L), (long)BitUtil.deinterleave((long)(encodedMinEdge >>> 1)));
            TestMortonEncoder.assertEquals((long)encodedLat, (long)BitUtil.deinterleave((long)(encodedMinEdgeCeil >>> 1)));
            TestMortonEncoder.assertEquals((long)(encodedLon - 1L), (long)BitUtil.deinterleave((long)encodedMinEdge));
            TestMortonEncoder.assertEquals((long)encodedLon, (long)BitUtil.deinterleave((long)encodedMinEdgeCeil));
            TestMortonEncoder.assertEquals((long)(encodedLat - 1L), (long)BitUtil.deinterleave((long)(encodedMaxEdge >>> 1)));
            TestMortonEncoder.assertEquals((long)encodedLat, (long)BitUtil.deinterleave((long)(encodedMaxEdgeCeil >>> 1)));
            TestMortonEncoder.assertEquals((long)(encodedLon - 1L), (long)BitUtil.deinterleave((long)encodedMaxEdge));
            TestMortonEncoder.assertEquals((long)encodedLon, (long)BitUtil.deinterleave((long)encodedMaxEdgeCeil));
            long minBitsLat = NumericUtils.doubleToSortableLong((double)minEdgeLat);
            long maxBitsLat = NumericUtils.doubleToSortableLong((double)maxEdgeLat);
            long minBitsLon = NumericUtils.doubleToSortableLong((double)minEdgeLon);
            long maxBitsLon = NumericUtils.doubleToSortableLong((double)maxEdgeLon);
            for (int j = 0; j < 100; ++j) {
                double valueLat = NumericUtils.sortableLongToDouble((long)TestUtil.nextLong((Random)random, (long)minBitsLat, (long)maxBitsLat));
                double valueLon = NumericUtils.sortableLongToDouble((long)TestUtil.nextLong((Random)random, (long)minBitsLon, (long)maxBitsLon));
                TestMortonEncoder.assertEquals((long)encoded, (long)MortonEncoder.encode((double)valueLat, (double)valueLon));
                TestMortonEncoder.assertEquals((long)BitUtil.interleave((int)((int)encodedLon), (int)((int)encodedLat)), (long)MortonEncoder.encodeCeil((double)valueLat, (double)valueLon));
            }
        }
    }
}

