/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.rowset.serial.SerialClob;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.ContextImpl;
import org.apache.solr.handler.dataimport.DIHCache;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class AbstractDIHCacheTestCase {
    protected static final Date Feb21_2011 = new Date(1298268000000L);
    protected final String[] fieldTypes = new String[]{"INTEGER", "BIGDECIMAL", "STRING", "STRING", "FLOAT", "DATE", "CLOB"};
    protected final String[] fieldNames = new String[]{"a_id", "PI", "letter", "examples", "a_float", "a_date", "DESCRIPTION"};
    protected List<ControlData> data = new ArrayList<ControlData>();
    protected Clob APPLE = null;

    @Before
    public void setup() {
        try {
            this.APPLE = new SerialClob("Apples grow on trees and they are good to eat.".toCharArray());
        }
        catch (SQLException sqe) {
            Assert.fail((String)"Could not Set up Test");
        }
        this.data = new ArrayList<ControlData>();
        this.data.add(new ControlData(new Object[]{new Integer(1), new BigDecimal(Math.PI), "A", "Apple", new Float(1.11), Feb21_2011, this.APPLE}));
        this.data.add(new ControlData(new Object[]{new Integer(2), new BigDecimal(Math.PI), "B", "Ball", new Float(2.22), Feb21_2011, null}));
        this.data.add(new ControlData(new Object[]{new Integer(4), new BigDecimal(Math.PI), "D", "Dog", new Float(4.44), Feb21_2011, null}));
        this.data.add(new ControlData(new Object[]{new Integer(3), new BigDecimal(Math.PI), "C", "Cookie", new Float(3.33), Feb21_2011, null}));
        this.data.add(new ControlData(new Object[]{new Integer(4), new BigDecimal(Math.PI), "D", "Daisy", new Float(4.44), Feb21_2011, null}));
        this.data.add(new ControlData(new Object[]{new Integer(4), new BigDecimal(Math.PI), "D", "Drawing", new Float(4.44), Feb21_2011, null}));
        this.data.add(new ControlData(new Object[]{new Integer(5), new BigDecimal(Math.PI), "E", Arrays.asList("Eggplant", "Ear", "Elephant", "Engine"), new Float(5.55), Feb21_2011, null}));
    }

    @After
    public void teardown() {
        this.APPLE = null;
        this.data = null;
    }

    protected void loadData(DIHCache cache, List<ControlData> theData, String[] theFieldNames, boolean keepOrdered) {
        for (ControlData cd : theData) {
            cache.add(this.controlDataToMap(cd, theFieldNames, keepOrdered));
        }
    }

    protected List<ControlData> extractDataInKeyOrder(DIHCache cache, String[] theFieldNames) {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        Iterator cacheIter = cache.iterator();
        while (cacheIter.hasNext()) {
            data.add(this.mapToObjectArray((Map)cacheIter.next(), theFieldNames));
        }
        return this.listToControlData(data);
    }

    protected List<ControlData> extractDataByKeyLookup(DIHCache cache, String[] theFieldNames) {
        Iterator listORecs;
        int recId = 1;
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        while ((listORecs = cache.iterator((Object)recId)) != null) {
            while (listORecs.hasNext()) {
                data.add(this.mapToObjectArray((Map)listORecs.next(), theFieldNames));
            }
            ++recId;
        }
        return this.listToControlData(data);
    }

    protected List<ControlData> listToControlData(List<Object[]> data) {
        ArrayList<ControlData> returnData = new ArrayList<ControlData>(data.size());
        for (int i = 0; i < data.size(); ++i) {
            returnData.add(new ControlData(data.get(i)));
        }
        return returnData;
    }

    protected Object[] mapToObjectArray(Map<String, Object> rec, String[] theFieldNames) {
        Object[] oos = new Object[theFieldNames.length];
        for (int i = 0; i < theFieldNames.length; ++i) {
            oos[i] = rec.get(theFieldNames[i]);
        }
        return oos;
    }

    protected void compareData(List<ControlData> theControl, List<ControlData> test) {
        ArrayList<ControlData> control = new ArrayList<ControlData>(theControl);
        Collections.sort(control);
        StringBuilder errors = new StringBuilder();
        if (test.size() != control.size()) {
            errors.append("-Returned data has " + test.size() + " records.  expected: " + control.size() + "\n");
        }
        for (int i = 0; i < control.size() && i < test.size(); ++i) {
            Object[] testRec = test.get((int)i).data;
            Object[] controlRec = ((ControlData)control.get((int)i)).data;
            if (testRec.length != controlRec.length) {
                errors.append("-Record indexAt=" + i + " has " + testRec.length + " data elements.  extpected: " + controlRec.length + "\n");
            }
            for (int j = 0; j < controlRec.length && j < testRec.length; ++j) {
                Object controlObj = controlRec[j];
                Object testObj = testRec[j];
                if (controlObj == null && testObj != null) {
                    errors.append("-Record indexAt=" + i + ", Data Element indexAt=" + j + " is not NULL as expected.\n");
                    continue;
                }
                if (controlObj != null && testObj == null) {
                    errors.append("-Record indexAt=" + i + ", Data Element indexAt=" + j + " is NULL.  Expected: " + controlObj + " (class=" + controlObj.getClass().getName() + ")\n");
                    continue;
                }
                if (controlObj != null && testObj != null && controlObj instanceof Clob) {
                    String testString;
                    String controlString = this.clobToString((Clob)controlObj);
                    if (controlString.equals(testString = this.clobToString((Clob)testObj))) continue;
                    errors.append("-Record indexAt=" + i + ", Data Element indexAt=" + j + " has: " + testString + " (class=Clob) ... Expected: " + controlString + " (class=Clob)\n");
                    continue;
                }
                if (controlObj == null || controlObj.equals(testObj)) continue;
                errors.append("-Record indexAt=" + i + ", Data Element indexAt=" + j + " has: " + testObj + " (class=" + testObj.getClass().getName() + ") ... Expected: " + controlObj + " (class=" + controlObj.getClass().getName() + ")\n");
            }
        }
        if (errors.length() > 0) {
            Assert.fail((String)errors.toString());
        }
    }

    protected Map<String, Object> controlDataToMap(ControlData cd, String[] theFieldNames, boolean keepOrdered) {
        HashMap rec = null;
        rec = keepOrdered ? new LinkedHashMap() : new HashMap();
        for (int i = 0; i < cd.data.length; ++i) {
            String fieldName = theFieldNames[i];
            Object data = cd.data[i];
            rec.put((String)fieldName, (Object)data);
        }
        return rec;
    }

    protected String stringArrayToCommaDelimitedList(String[] strs) {
        StringBuilder sb = new StringBuilder();
        for (String a : strs) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(a);
        }
        return sb.toString();
    }

    protected String clobToString(Clob cl) {
        StringBuilder sb = new StringBuilder();
        try {
            Reader in = cl.getCharacterStream();
            char[] cbuf = new char[1024];
            int numGot = -1;
            while ((numGot = in.read(cbuf)) != -1) {
                sb.append(String.valueOf(cbuf, 0, numGot));
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
        return sb.toString();
    }

    public static Context getContext(Map<String, String> entityAttrs) {
        VariableResolver resolver = new VariableResolver();
        ContextImpl delegate = new ContextImpl(null, resolver, null, null, new HashMap(), null, null);
        return new AbstractDataImportHandlerTestCase.TestContext(entityAttrs, (Context)delegate, null, true);
    }

    static class ControlData
    implements Comparable<ControlData>,
    Iterable<Object> {
        Object[] data;

        ControlData(Object[] data) {
            this.data = data;
        }

        @Override
        public int compareTo(ControlData cd) {
            Comparable c1 = (Comparable)this.data[0];
            Comparable c2 = (Comparable)cd.data[0];
            return c1.compareTo(c2);
        }

        @Override
        public Iterator<Object> iterator() {
            return Arrays.asList(this.data).iterator();
        }
    }
}

