/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class AbstractDIHJdbcTestCase
extends AbstractDataImportHandlerTestCase {
    protected Database dbToUse;
    protected boolean skipThisTest = false;
    private static final Pattern totalRequestsPattern = Pattern.compile(".str name..Total Requests made to DataSource..(\\d+)..str.");

    @BeforeClass
    public static void beforeClassDihJdbcTest() throws Exception {
        Class.forName("org.hsqldb.jdbcDriver").newInstance();
        String oldProp = System.getProperty("derby.stream.error.field");
        System.setProperty("derby.stream.error.field", "org.apache.solr.handler.dataimport.AbstractDIHJdbcTestCase$DerbyUtil.DEV_NULL");
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        if (oldProp != null) {
            System.setProperty("derby.stream.error.field", oldProp);
        }
        AbstractDIHJdbcTestCase.initCore("dataimport-solrconfig.xml", "dataimport-schema.xml");
    }

    @AfterClass
    public static void afterClassDihJdbcTest() throws Exception {
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected Database setAllowedDatabases() {
        return Database.RANDOM;
    }

    @Before
    public void beforeDihJdbcTest() throws Exception {
        this.skipThisTest = false;
        this.dbToUse = this.setAllowedDatabases();
        if (this.dbToUse == Database.RANDOM) {
            this.dbToUse = AbstractDIHJdbcTestCase.random().nextBoolean() ? Database.DERBY : Database.HSQLDB;
        }
        this.clearIndex();
        AbstractDIHJdbcTestCase.assertU((String)AbstractDIHJdbcTestCase.commit((String[])new String[0]));
        this.buildDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterDihJdbcTest() throws Exception {
        block23: {
            Connection conn = null;
            Statement s = null;
            try {
                if (this.dbToUse == Database.DERBY) {
                    try {
                        conn = DriverManager.getConnection("jdbc:derby:memory:derbyDB;drop=true;territory=en_US");
                        break block23;
                    }
                    catch (SQLException e) {
                        if (!"08006".equals(e.getSQLState())) {
                            throw e;
                        }
                        break block23;
                    }
                }
                if (this.dbToUse == Database.HSQLDB) {
                    conn = DriverManager.getConnection("jdbc:hsqldb:mem:.");
                    s = conn.createStatement();
                    s.executeUpdate("shutdown");
                }
            }
            catch (SQLException e) {
                if (!this.skipThisTest) {
                    throw e;
                }
            }
            finally {
                try {
                    s.close();
                }
                catch (Exception exception) {}
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected Connection newConnection() throws Exception {
        if (this.dbToUse == Database.DERBY) {
            return DriverManager.getConnection("jdbc:derby:memory:derbyDB;territory=en_US");
        }
        if (this.dbToUse == Database.HSQLDB) {
            return DriverManager.getConnection("jdbc:hsqldb:mem:.");
        }
        throw new AssertionError((Object)("Invalid database to use: " + (Object)((Object)this.dbToUse)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildDatabase() throws Exception {
        Connection conn = null;
        try {
            if (this.dbToUse == Database.DERBY) {
                conn = DriverManager.getConnection("jdbc:derby:memory:derbyDB;create=true;territory=en_US");
            } else if (this.dbToUse == Database.HSQLDB) {
                conn = DriverManager.getConnection("jdbc:hsqldb:mem:.");
            } else {
                throw new AssertionError((Object)("Invalid database to use: " + (Object)((Object)this.dbToUse)));
            }
            this.populateData(conn);
        }
        catch (SQLException sqe) {
            Throwable cause = sqe;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void populateData(Connection conn) throws Exception {
    }

    public int totalDatabaseRequests(String dihHandlerName) throws Exception {
        LocalSolrQueryRequest request = lrf.makeRequest(new String[]{"indent", "true"});
        String response = h.query(dihHandlerName, (SolrQueryRequest)request);
        Matcher m = totalRequestsPattern.matcher(response);
        Assert.assertTrue((String)("The handler " + dihHandlerName + " is not reporting any database requests. "), (m.find() && m.groupCount() == 1 ? 1 : 0) != 0);
        return Integer.parseInt(m.group(1));
    }

    public int totalDatabaseRequests() throws Exception {
        return this.totalDatabaseRequests("/dataimport");
    }

    protected LocalSolrQueryRequest generateRequest() {
        return lrf.makeRequest(new String[]{"command", "full-import", "dataConfig", this.generateConfig(), "clean", "true", "commit", "true", "synchronous", "true", "indent", "true"});
    }

    protected abstract String generateConfig();

    public static class DerbyUtil {
        public static final OutputStream DEV_NULL = new OutputStream(){

            @Override
            public void write(int b) {
            }
        };
    }

    public static enum Database {
        RANDOM,
        DERBY,
        HSQLDB;

    }
}

