/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.ContextImpl;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.EntityProcessorWrapper;
import org.apache.solr.handler.dataimport.SolrWriter;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.junit.Before;

public abstract class AbstractDataImportHandlerTestCase
extends SolrTestCaseJ4 {
    public static void initCore(String config, String schema) throws Exception {
        File testHome = AbstractDataImportHandlerTestCase.createTempDir((String)"core-home").toFile();
        FileUtils.copyDirectory((File)AbstractDataImportHandlerTestCase.getFile((String)"dih/solr"), (File)testHome);
        AbstractDataImportHandlerTestCase.initCore((String)config, (String)schema, (String)testHome.getAbsolutePath());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        File home = AbstractDataImportHandlerTestCase.createTempDir((String)"dih-properties").toFile();
        System.setProperty("solr.solr.home", home.getAbsolutePath());
    }

    protected String loadDataConfig(String dataConfigFileName) {
        try {
            SolrCore core = h.getCore();
            return SolrWriter.getResourceAsString((InputStream)core.getResourceLoader().openResource(dataConfigFileName));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void runFullImport(String dataConfig) throws Exception {
        LocalSolrQueryRequest request = lrf.makeRequest(new String[]{"command", "full-import", "debug", "on", "clean", "true", "commit", "true", "dataConfig", dataConfig});
        h.query("/dataimport", (SolrQueryRequest)request);
    }

    protected void runDeltaImport(String dataConfig) throws Exception {
        LocalSolrQueryRequest request = lrf.makeRequest(new String[]{"command", "delta-import", "debug", "on", "clean", "false", "commit", "true", "dataConfig", dataConfig});
        h.query("/dataimport", (SolrQueryRequest)request);
    }

    protected File redirectTempProperties(DataImporter di) {
        try {
            File tempFile = AbstractDataImportHandlerTestCase.createTempFile().toFile();
            di.getConfig().getPropertyWriter().getParameters().put("filename", tempFile.getAbsolutePath());
            return tempFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void runFullImport(String dataConfig, Map<String, String> extraParams) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("command", "full-import");
        params.put("debug", "on");
        params.put("dataConfig", dataConfig);
        params.put("clean", "true");
        params.put("commit", "true");
        params.putAll(extraParams);
        NamedList l = new NamedList();
        for (Map.Entry e : params.entrySet()) {
            l.add((String)e.getKey(), e.getValue());
        }
        LocalSolrQueryRequest request = new LocalSolrQueryRequest(h.getCore(), l);
        h.query("/dataimport", (SolrQueryRequest)request);
    }

    public static TestContext getContext(EntityProcessorWrapper parent, VariableResolver resolver, DataSource parentDataSource, String currProcess, List<Map<String, String>> entityFields, Map<String, String> entityAttrs) {
        if (resolver == null) {
            resolver = new VariableResolver();
        }
        ContextImpl delegate = new ContextImpl(parent, resolver, parentDataSource, currProcess, new HashMap(), null, null);
        return new TestContext(entityAttrs, (Context)delegate, entityFields, parent == null);
    }

    public static Map createMap(Object ... args) {
        return Utils.makeMap((Object[])args);
    }

    @SuppressForbidden(reason="Needs currentTimeMillis to set modified time for a file")
    public static File createFile(File tmpdir, String name, byte[] content, boolean changeModifiedTime) throws IOException {
        File file = new File(tmpdir.getAbsolutePath() + File.separator + name);
        file.deleteOnExit();
        FileOutputStream f = new FileOutputStream(file);
        f.write(content);
        f.close();
        if (changeModifiedTime) {
            file.setLastModified(System.currentTimeMillis() - 3600000L);
        }
        return file;
    }

    public static Map<String, String> getField(String col, String type, String re, String srcCol, String splitBy) {
        HashMap<String, String> vals = new HashMap<String, String>();
        vals.put("column", col);
        vals.put("type", type);
        vals.put("regex", re);
        vals.put("sourceColName", srcCol);
        vals.put("splitBy", splitBy);
        return vals;
    }

    public static class TestUpdateRequestProcessor
    extends UpdateRequestProcessor {
        public static boolean finishCalled = false;
        public static boolean processAddCalled = false;
        public static boolean processCommitCalled = false;
        public static boolean processDeleteCalled = false;
        public static boolean mergeIndexesCalled = false;
        public static boolean rollbackCalled = false;

        public static void reset() {
            finishCalled = false;
            processAddCalled = false;
            processCommitCalled = false;
            processDeleteCalled = false;
            mergeIndexesCalled = false;
            rollbackCalled = false;
        }

        public TestUpdateRequestProcessor(UpdateRequestProcessor next) {
            super(next);
            TestUpdateRequestProcessor.reset();
        }

        public void finish() throws IOException {
            finishCalled = true;
            super.finish();
        }

        public void processAdd(AddUpdateCommand cmd) throws IOException {
            processAddCalled = true;
            super.processAdd(cmd);
        }

        public void processCommit(CommitUpdateCommand cmd) throws IOException {
            processCommitCalled = true;
            super.processCommit(cmd);
        }

        public void processDelete(DeleteUpdateCommand cmd) throws IOException {
            processDeleteCalled = true;
            super.processDelete(cmd);
        }

        public void processMergeIndexes(MergeIndexesCommand cmd) throws IOException {
            mergeIndexesCalled = true;
            super.processMergeIndexes(cmd);
        }

        public void processRollback(RollbackUpdateCommand cmd) throws IOException {
            rollbackCalled = true;
            super.processRollback(cmd);
        }
    }

    public static class TestUpdateRequestProcessorFactory
    extends UpdateRequestProcessorFactory {
        public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
            return new TestUpdateRequestProcessor(next);
        }
    }

    static class TestContext
    extends Context {
        private final Map<String, String> entityAttrs;
        private final Context delegate;
        private final List<Map<String, String>> entityFields;
        private final boolean root;
        String script;
        String scriptlang;

        public TestContext(Map<String, String> entityAttrs, Context delegate, List<Map<String, String>> entityFields, boolean root) {
            this.entityAttrs = entityAttrs;
            this.delegate = delegate;
            this.entityFields = entityFields;
            this.root = root;
        }

        public String getEntityAttribute(String name) {
            return this.entityAttrs == null ? this.delegate.getEntityAttribute(name) : this.entityAttrs.get(name);
        }

        public String getResolvedEntityAttribute(String name) {
            return this.entityAttrs == null ? this.delegate.getResolvedEntityAttribute(name) : this.delegate.getVariableResolver().replaceTokens(this.entityAttrs.get(name));
        }

        public List<Map<String, String>> getAllEntityFields() {
            return this.entityFields == null ? this.delegate.getAllEntityFields() : this.entityFields;
        }

        public VariableResolver getVariableResolver() {
            return this.delegate.getVariableResolver();
        }

        public DataSource getDataSource() {
            return this.delegate.getDataSource();
        }

        public boolean isRootEntity() {
            return this.root;
        }

        public String currentProcess() {
            return this.delegate.currentProcess();
        }

        public Map<String, Object> getRequestParameters() {
            return this.delegate.getRequestParameters();
        }

        public EntityProcessor getEntityProcessor() {
            return null;
        }

        public void setSessionAttribute(String name, Object val, String scope) {
            this.delegate.setSessionAttribute(name, val, scope);
        }

        public Object getSessionAttribute(String name, String scope) {
            return this.delegate.getSessionAttribute(name, scope);
        }

        public Context getParentContext() {
            return this.delegate.getParentContext();
        }

        public DataSource getDataSource(String name) {
            return this.delegate.getDataSource(name);
        }

        public SolrCore getSolrCore() {
            return this.delegate.getSolrCore();
        }

        public Map<String, Object> getStats() {
            return this.delegate.getStats();
        }

        public String getScript() {
            return this.script == null ? this.delegate.getScript() : this.script;
        }

        public String getScriptLanguage() {
            return this.scriptlang == null ? this.delegate.getScriptLanguage() : this.scriptlang;
        }

        public void deleteDoc(String id) {
        }

        public void deleteDocByQuery(String query) {
        }

        public Object resolve(String var) {
            return this.delegate.resolve(var);
        }

        public String replaceTokens(String template) {
            return this.delegate.replaceTokens(template);
        }
    }
}

