/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import junit.framework.Assert;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.handler.dataimport.AbstractDIHJdbcTestCase;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.SimplePropertiesWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSqlEntityProcessorTestCase
extends AbstractDIHJdbcTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected boolean underlyingDataModified;
    protected boolean useSimpleCaches;
    protected boolean countryEntity;
    protected boolean countryCached;
    protected boolean countryZipper;
    protected boolean sportsEntity;
    protected boolean sportsCached;
    protected boolean sportsZipper;
    protected boolean wrongPeopleOrder;
    protected boolean wrongSportsOrder;
    protected boolean wrongCountryOrder;
    protected String rootTransformerName;
    protected boolean countryTransformer;
    protected boolean sportsTransformer;
    protected String fileLocation;
    protected String fileName;
    public static final String[][] countries = new String[][]{{"NA", "Namibia"}, {"NC", "New Caledonia"}, {"NE", "Niger"}, {"NF", "Norfolk Island"}, {"NG", "Nigeria"}, {"NI", "Nicaragua"}, {"NL", "Netherlands"}, {"NO", "Norway"}, {"NP", "Nepal"}, {"NR", "Nauru"}, {"NU", "Niue"}, {"NZ", "New Zealand"}};
    public static final Object[][] people = new Object[][]{{1, "Jacob", "NZ"}, {2, "Ethan", "NU"}, {3, "Michael", "NR"}, {4, "Jayden", "NP"}, {5, "William", "NO"}, {6, "Alexander", "NL"}, {7, "Noah", "NI"}, {8, "Daniel", "NG"}, {9, "Aiden", "NF"}, {21, "Anthony", "NE"}, {11, "Emma", "NL"}, {12, "Grace", "NI"}, {13, "Hailey", "NG"}, {14, "Isabella", "NF"}, {15, "Lily", "NE"}, {16, "Madison", "NC"}, {17, "Mia", "NA"}, {18, "Natalie", "NZ"}, {19, "Olivia", "NU"}, {20, "Samantha", "NR"}};
    public static final Object[][] people_sports = new Object[][]{{100, 1, "Swimming"}, {200, 2, "Triathlon"}, {300, 3, "Water polo"}, {310, 3, "Underwater rugby"}, {320, 3, "Kayaking"}, {400, 4, "Snorkeling"}, {500, 5, "Synchronized diving"}, {600, 6, "Underwater rugby"}, {700, 7, "Boating"}, {800, 8, "Bodyboarding"}, {900, 9, "Canoeing"}, {1000, 10, "No Fishing"}, {1100, 11, "Jet Ski"}, {1110, 11, "Rowing"}, {1120, 11, "Sailing"}, {1200, 12, "Kayaking"}, {1210, 12, "Canoeing"}, {1300, 13, "Kite surfing"}, {1400, 14, "Parasailing"}, {1500, 15, "Rafting"}, {1700, 17, "Sailing"}, {1800, 18, "White Water Rafting"}, {1900, 19, "Water skiing"}, {2000, 20, "Windsurfing"}, {2100, 21, "Concrete diving"}, {2110, 21, "Bubble rugby"}};

    @Before
    public void beforeSqlEntitiyProcessorTestCase() throws Exception {
        File tmpdir = AbstractSqlEntityProcessorTestCase.createTempDir().toFile();
        this.fileLocation = tmpdir.getPath();
        this.fileName = "the.properties";
    }

    @After
    public void afterSqlEntitiyProcessorTestCase() throws Exception {
        this.useSimpleCaches = false;
        this.countryEntity = false;
        this.countryCached = false;
        this.countryZipper = false;
        this.sportsEntity = false;
        this.sportsCached = false;
        this.sportsZipper = false;
        this.wrongPeopleOrder = false;
        this.wrongSportsOrder = false;
        this.wrongCountryOrder = false;
        this.rootTransformerName = null;
        this.countryTransformer = false;
        this.sportsTransformer = false;
        this.underlyingDataModified = false;
        if (this.fileLocation != null) {
            Files.deleteIfExists(new File(this.fileLocation + File.separatorChar + this.fileName).toPath());
            Files.deleteIfExists(new File(this.fileLocation).toPath());
        }
    }

    protected void logPropertiesFile() {
        HashMap<String, String> init = new HashMap<String, String>();
        init.put("filename", this.fileName);
        init.put("directory", this.fileLocation);
        SimplePropertiesWriter spw = new SimplePropertiesWriter();
        spw.init(new DataImporter(), init);
        Map props = spw.readIndexerProperties();
        if (props != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("\ndataimporter.properties: \n");
            for (Map.Entry entry : props.entrySet()) {
                sb.append("  > key=" + (String)entry.getKey() + " / value=" + entry.getValue() + "\n");
            }
            log.debug(sb.toString());
        }
    }

    protected abstract String deltaQueriesCountryTable();

    protected abstract String deltaQueriesPersonTable();

    protected void singleEntity(int numToExpect) throws Exception {
        h.query("/dataimport", (SolrQueryRequest)this.generateRequest());
        AbstractSqlEntityProcessorTestCase.assertQ((String)("There should be 1 document per person in the database: " + this.totalPeople()), (SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"*:*"}), (String[])new String[]{"//*[@numFound='" + this.totalPeople() + "']"});
        Assert.assertTrue((String)("Expecting " + numToExpect + " database calls, but DIH reported " + this.totalDatabaseRequests()), (this.totalDatabaseRequests() == numToExpect ? 1 : 0) != 0);
    }

    protected void simpleTransform(int numToExpect) throws Exception {
        this.rootTransformerName = "AddAColumnTransformer";
        h.query("/dataimport", (SolrQueryRequest)this.generateRequest());
        AbstractSqlEntityProcessorTestCase.assertQ((String)("There should be 1 document with a transformer-added column per person is the database: " + this.totalPeople()), (SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"AddAColumn_s:Added"}), (String[])new String[]{"//*[@numFound='" + this.totalPeople() + "']"});
        Assert.assertTrue((String)("Expecting " + numToExpect + " database calls, but DIH reported " + this.totalDatabaseRequests()), (this.totalDatabaseRequests() == numToExpect ? 1 : 0) != 0);
    }

    protected void complexTransform(int numToExpect, int numDeleted) throws Exception {
        this.rootTransformerName = "TripleThreatTransformer";
        h.query("/dataimport", (SolrQueryRequest)this.generateRequest());
        int totalDocs = this.totalPeople() * 3 + numDeleted * 2;
        int totalAddedDocs = this.totalPeople() + numDeleted;
        AbstractSqlEntityProcessorTestCase.assertQ((SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"q", "*:*", "rows", "" + this.totalPeople() * 3, "sort", "id asc"}), (String[])new String[]{"//*[@numFound='" + totalDocs + "']"});
        AbstractSqlEntityProcessorTestCase.assertQ((SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"id:TripleThreat-1-*"}), (String[])new String[]{"//*[@numFound='" + totalAddedDocs + "']"});
        AbstractSqlEntityProcessorTestCase.assertQ((SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"id:TripleThreat-2-*"}), (String[])new String[]{"//*[@numFound='" + totalAddedDocs + "']"});
        if (this.personNameExists("Michael") && this.countryCodeExists("NR")) {
            AbstractSqlEntityProcessorTestCase.assertQ((String)"Michael and NR are assured to be in the database.  Therefore the transformer should have added leahciM and RN on the same document as id:TripleThreat-1-3", (SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"+id:TripleThreat-1-3 +NAME_mult_s:Michael +NAME_mult_s:leahciM  +COUNTRY_CODES_mult_s:NR +COUNTRY_CODES_mult_s:RN"}), (String[])new String[]{"//*[@numFound='1']"});
        }
        AbstractSqlEntityProcessorTestCase.assertQ((SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"AddAColumn_s:Added"}), (String[])new String[]{"//*[@numFound='" + totalAddedDocs + "']"});
        Assert.assertTrue((String)("Expecting " + numToExpect + " database calls, but DIH reported " + this.totalDatabaseRequests()), (this.totalDatabaseRequests() == numToExpect ? 1 : 0) != 0);
    }

    protected void withChildEntities(boolean cached, boolean checkDatabaseRequests) throws Exception {
        this.rootTransformerName = AbstractSqlEntityProcessorTestCase.random().nextBoolean() ? null : "AddAColumnTransformer";
        int numChildren = AbstractSqlEntityProcessorTestCase.random().nextInt(1) + 1;
        int numDatabaseRequests = 1;
        if (this.underlyingDataModified) {
            if (this.countryEntity) {
                numDatabaseRequests = cached ? ++numDatabaseRequests : (numDatabaseRequests += this.totalPeople());
            }
            if (this.sportsEntity) {
                numDatabaseRequests = cached ? ++numDatabaseRequests : (numDatabaseRequests += this.totalPeople());
            }
        } else {
            this.countryEntity = true;
            this.sportsEntity = true;
            if (this.countryZipper || this.sportsZipper) {
                this.countryEntity = this.countryZipper;
                this.sportsEntity = this.sportsZipper;
            } else if (numChildren == 1) {
                this.countryEntity = AbstractSqlEntityProcessorTestCase.random().nextBoolean();
                boolean bl = this.sportsEntity = !this.countryEntity;
            }
            if (this.countryEntity) {
                this.countryTransformer = AbstractSqlEntityProcessorTestCase.random().nextBoolean();
                if (cached) {
                    ++numDatabaseRequests;
                    this.countryCached = true;
                } else {
                    numDatabaseRequests += this.totalPeople();
                }
            }
            if (this.sportsEntity) {
                this.sportsTransformer = AbstractSqlEntityProcessorTestCase.random().nextBoolean();
                if (cached) {
                    ++numDatabaseRequests;
                    this.sportsCached = true;
                } else {
                    numDatabaseRequests += this.totalPeople();
                }
            }
        }
        h.query("/dataimport", (SolrQueryRequest)this.generateRequest());
        AbstractSqlEntityProcessorTestCase.assertQ((String)("There should be 1 document per person in the database: " + this.totalPeople()), (SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"*:*"}), (String[])new String[]{"//*[@numFound='" + this.totalPeople() + "']"});
        if (!this.underlyingDataModified && "AddAColumnTransformer".equals(this.rootTransformerName)) {
            AbstractSqlEntityProcessorTestCase.assertQ((String)("There should be 1 document with a transformer-added column per person is the database: " + this.totalPeople()), (SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"AddAColumn_s:Added"}), (String[])new String[]{"//*[@numFound='" + this.totalPeople() + "']"});
        }
        if (this.countryEntity) {
            String[] people = this.getStringsFromQuery("SELECT NAME FROM PEOPLE WHERE DELETED != 'Y'");
            String man = people[AbstractSqlEntityProcessorTestCase.random().nextInt(people.length)];
            String[] countryNames = this.getStringsFromQuery("SELECT C.COUNTRY_NAME FROM PEOPLE P INNER JOIN COUNTRIES C ON P.COUNTRY_CODE=C.CODE WHERE P.DELETED!='Y' AND C.DELETED!='Y' AND P.NAME='" + man + "'");
            AbstractSqlEntityProcessorTestCase.assertQ((SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"{!term f=NAME_mult_s}" + man}), (String[])new String[]{"//*[@numFound='1']", countryNames.length > 0 ? "//doc/str[@name='COUNTRY_NAME_s']='" + countryNames[AbstractSqlEntityProcessorTestCase.random().nextInt(countryNames.length)] + "'" : "//doc[count(*[@name='COUNTRY_NAME_s'])=0]"});
            String[] countryCodes = this.getStringsFromQuery("SELECT CODE FROM COUNTRIES WHERE DELETED != 'Y'");
            String theCode = countryCodes[AbstractSqlEntityProcessorTestCase.random().nextInt(countryCodes.length)];
            int num = this.numberPeopleByCountryCode(theCode);
            if (num > 0) {
                String nrName = this.countryNameByCode(theCode);
                AbstractSqlEntityProcessorTestCase.assertQ((SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"COUNTRY_CODES_mult_s:" + theCode}), (String[])new String[]{"//*[@numFound='" + num + "']", "//doc/str[@name='COUNTRY_NAME_s']='" + nrName + "'"});
            } else {
                AbstractSqlEntityProcessorTestCase.assertQ((SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"COUNTRY_CODES_mult_s:" + theCode}), (String[])new String[]{"//*[@numFound='" + num + "']"});
            }
            if (this.countryTransformer && !this.underlyingDataModified) {
                AbstractSqlEntityProcessorTestCase.assertQ((SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"countryAdded_s:country_added"}), (String[])new String[]{"//*[@numFound='" + this.totalPeople() + "']"});
            }
        }
        if (this.sportsEntity) {
            if (!this.underlyingDataModified) {
                AbstractSqlEntityProcessorTestCase.assertQ((SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"SPORT_NAME_mult_s:Sailing"}), (String[])new String[]{"//*[@numFound='2']"});
            }
            String[] names = this.getStringsFromQuery("SELECT NAME FROM PEOPLE WHERE DELETED != 'Y'");
            String name = names[AbstractSqlEntityProcessorTestCase.random().nextInt(names.length)];
            int personId = this.getIntFromQuery("SELECT ID FROM PEOPLE WHERE DELETED != 'Y' AND NAME='" + name + "'");
            String[] michaelsSports = this.sportNamesByPersonId(personId);
            String[] xpath = new String[michaelsSports.length + 1];
            xpath[0] = "//*[@numFound='1']";
            int i = 1;
            for (String ms : michaelsSports) {
                xpath[i] = "//doc/arr[@name='SPORT_NAME_mult_s']/str='" + ms + "'";
                ++i;
            }
            AbstractSqlEntityProcessorTestCase.assertQ((SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"NAME_mult_s:" + name.replaceAll("\\W", "\\\\$0")}), (String[])xpath);
            if (!this.underlyingDataModified && this.sportsTransformer) {
                AbstractSqlEntityProcessorTestCase.assertQ((SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"sportsAdded_s:sport_added"}), (String[])new String[]{"//*[@numFound='" + this.totalSportsmen() + "']"});
            }
            AbstractSqlEntityProcessorTestCase.assertQ((String)"checking orphan sport is absent", (SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"{!term f=SPORT_NAME_mult_s}No Fishing"}), (String[])new String[]{"//*[@numFound='0']"});
        }
        if (checkDatabaseRequests) {
            Assert.assertTrue((String)("Expecting " + numDatabaseRequests + " database calls, but DIH reported " + this.totalDatabaseRequests()), (this.totalDatabaseRequests() == numDatabaseRequests ? 1 : 0) != 0);
        }
    }

    protected void simpleCacheChildEntities(boolean checkDatabaseRequests) throws Exception {
        this.useSimpleCaches = true;
        this.countryEntity = true;
        this.sportsEntity = true;
        this.countryCached = true;
        this.sportsCached = true;
        int dbRequestsMoreThan = 3;
        int dbRequestsLessThan = this.totalPeople() * 2 + 1;
        h.query("/dataimport", (SolrQueryRequest)this.generateRequest());
        AbstractSqlEntityProcessorTestCase.assertQ((SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"*:*"}), (String[])new String[]{"//*[@numFound='" + this.totalPeople() + "']"});
        if (!this.underlyingDataModified || this.personNameExists("Samantha") && "Nauru".equals(this.countryNameByCode("NR"))) {
            AbstractSqlEntityProcessorTestCase.assertQ((SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"NAME_mult_s:Samantha"}), (String[])new String[]{"//*[@numFound='1']", "//doc/str[@name='COUNTRY_NAME_s']='Nauru'"});
        }
        if (!this.underlyingDataModified) {
            AbstractSqlEntityProcessorTestCase.assertQ((SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"COUNTRY_CODES_mult_s:NR"}), (String[])new String[]{"//*[@numFound='2']", "//doc/str[@name='COUNTRY_NAME_s']='Nauru'"});
            AbstractSqlEntityProcessorTestCase.assertQ((SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"SPORT_NAME_mult_s:Sailing"}), (String[])new String[]{"//*[@numFound='2']"});
        }
        String[] michaelsSports = this.sportNamesByPersonId(3);
        if (!this.underlyingDataModified || michaelsSports.length > 0) {
            String[] xpath = new String[michaelsSports.length + 1];
            xpath[0] = "//*[@numFound='1']";
            int i = 1;
            for (String ms : michaelsSports) {
                xpath[i] = "//doc/arr[@name='SPORT_NAME_mult_s']/str[" + i + "]='" + ms + "'";
                ++i;
            }
            AbstractSqlEntityProcessorTestCase.assertQ((SolrQueryRequest)AbstractSqlEntityProcessorTestCase.req((String[])new String[]{"NAME_mult_s:Michael"}), (String[])xpath);
        }
        if (checkDatabaseRequests) {
            Assert.assertTrue((String)("Expecting more than " + dbRequestsMoreThan + " database calls, but DIH reported " + this.totalDatabaseRequests()), (this.totalDatabaseRequests() > dbRequestsMoreThan ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting fewer than " + dbRequestsLessThan + " database calls, but DIH reported " + this.totalDatabaseRequests()), (this.totalDatabaseRequests() < dbRequestsLessThan ? 1 : 0) != 0);
        }
    }

    private int getIntFromQuery(String query) throws Exception {
        Connection conn = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            conn = this.newConnection();
            s = conn.createStatement();
            rs = s.executeQuery(query);
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                s.close();
            }
            catch (Exception exception) {}
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
    }

    private String[] getStringsFromQuery(String query) throws Exception {
        Connection conn = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            conn = this.newConnection();
            s = conn.createStatement();
            rs = s.executeQuery(query);
            ArrayList<String> results = new ArrayList<String>();
            while (rs.next()) {
                results.add(rs.getString(1));
            }
            String[] stringArray = results.toArray(new String[results.size()]);
            return stringArray;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                s.close();
            }
            catch (Exception exception) {}
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
    }

    public int totalCountries() throws Exception {
        return this.getIntFromQuery("SELECT COUNT(1) FROM COUNTRIES WHERE DELETED != 'Y' ");
    }

    public int totalPeople() throws Exception {
        return this.getIntFromQuery("SELECT COUNT(1) FROM PEOPLE WHERE DELETED != 'Y' ");
    }

    public int totalSportsmen() throws Exception {
        return this.getIntFromQuery("SELECT COUNT(*) FROM PEOPLE WHERE EXISTS(SELECT ID FROM PEOPLE_SPORTS WHERE PERSON_ID=PEOPLE.ID AND PEOPLE_SPORTS.DELETED != 'Y') AND PEOPLE.DELETED != 'Y'");
    }

    public boolean countryCodeExists(String cc) throws Exception {
        return this.getIntFromQuery("SELECT COUNT(1) country_name FROM COUNTRIES WHERE DELETED != 'Y' AND CODE='" + cc + "'") > 0;
    }

    public String countryNameByCode(String cc) throws Exception {
        String[] s = this.getStringsFromQuery("SELECT country_name FROM COUNTRIES WHERE DELETED != 'Y' AND CODE='" + cc + "'");
        return s.length == 0 ? null : s[0];
    }

    public int numberPeopleByCountryCode(String cc) throws Exception {
        return this.getIntFromQuery("Select count(1) from people p inner join countries c on p.country_code=c.code where p.deleted!='Y' and c.deleted!='Y' and c.code='" + cc + "'");
    }

    public String[] sportNamesByPersonId(int personId) throws Exception {
        return this.getStringsFromQuery("SELECT ps.SPORT_NAME FROM people_sports ps INNER JOIN PEOPLE p ON p.id = ps.person_Id WHERE ps.DELETED != 'Y' AND p.DELETED != 'Y' AND ps.person_id=" + personId + " ORDER BY ps.id");
    }

    public boolean personNameExists(String pn) throws Exception {
        return this.getIntFromQuery("SELECT COUNT(1) FROM PEOPLE WHERE DELETED != 'Y' AND NAME='" + pn + "'") > 0;
    }

    public String personNameById(int id) throws Exception {
        String[] nameArr = this.getStringsFromQuery("SELECT NAME FROM PEOPLE WHERE ID=" + id);
        if (nameArr.length == 0) {
            return null;
        }
        return nameArr[0];
    }

    @SuppressForbidden(reason="Needs currentTimeMillis to set change time for SQL query")
    public IntChanges modifySomePeople() throws Exception {
        this.underlyingDataModified = true;
        int numberToChange = AbstractSqlEntityProcessorTestCase.random().nextInt(people.length + 1);
        HashSet<Integer> changeSet = new HashSet<Integer>();
        HashSet<Integer> deleteSet = new HashSet<Integer>();
        HashSet<Integer> addSet = new HashSet<Integer>();
        Connection conn = null;
        Statement change = null;
        PreparedStatement delete = null;
        PreparedStatement add = null;
        Timestamp theTime = new Timestamp(System.currentTimeMillis() + 1000L);
        log.debug("PEOPLE UPDATE USING TIMESTAMP: " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.ROOT).format(theTime));
        try {
            conn = this.newConnection();
            change = conn.prepareStatement("update people set name=?, last_modified=? where id=?");
            delete = conn.prepareStatement("update people set deleted='Y', last_modified=? where id=?");
            add = conn.prepareStatement("insert into people (id,name,country_code,last_modified) values (?,?,'ZZ',?)");
            for (int i = 0; i < numberToChange; ++i) {
                int tryIndex = AbstractSqlEntityProcessorTestCase.random().nextInt(people.length);
                Integer id = (Integer)people[tryIndex][0];
                if (changeSet.contains(id) || deleteSet.contains(id)) continue;
                boolean changeDontDelete = AbstractSqlEntityProcessorTestCase.random().nextBoolean();
                if (changeDontDelete) {
                    changeSet.add(id);
                    change.setString(1, "MODIFIED " + people[tryIndex][1]);
                    change.setTimestamp(2, theTime);
                    change.setInt(3, id);
                    Assert.assertEquals((int)1, (int)change.executeUpdate());
                    continue;
                }
                deleteSet.add(id);
                delete.setTimestamp(1, theTime);
                delete.setInt(2, id);
                Assert.assertEquals((int)1, (int)delete.executeUpdate());
            }
            int numberToAdd = AbstractSqlEntityProcessorTestCase.random().nextInt(3);
            for (int i = 0; i < numberToAdd; ++i) {
                int tryIndex = AbstractSqlEntityProcessorTestCase.random().nextInt(people.length);
                Integer id = (Integer)people[tryIndex][0];
                Integer newId = id + 1000;
                String newDesc = "ADDED " + people[tryIndex][1];
                if (addSet.contains(newId)) continue;
                addSet.add(newId);
                add.setInt(1, newId);
                add.setString(2, newDesc);
                add.setTimestamp(3, theTime);
                Assert.assertEquals((int)1, (int)add.executeUpdate());
            }
            conn.commit();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                change.close();
            }
            catch (Exception exception) {}
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
        IntChanges c = new IntChanges();
        c.changedKeys = changeSet.toArray(new Integer[changeSet.size()]);
        c.deletedKeys = deleteSet.toArray(new Integer[deleteSet.size()]);
        c.addedKeys = addSet.toArray(new Integer[addSet.size()]);
        return c;
    }

    @SuppressForbidden(reason="Needs currentTimeMillis to set change time for SQL query")
    public String[] modifySomeCountries() throws Exception {
        this.underlyingDataModified = true;
        int numberToChange = AbstractSqlEntityProcessorTestCase.random().nextInt(countries.length + 1);
        HashSet<String> changeSet = new HashSet<String>();
        Connection conn = null;
        Statement change = null;
        Timestamp theTime = new Timestamp(System.currentTimeMillis() + 1000L);
        log.debug("COUNTRY UPDATE USING TIMESTAMP: " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.ROOT).format(theTime));
        try {
            conn = this.newConnection();
            change = conn.prepareStatement("update countries set country_name=?, last_modified=? where code=?");
            for (int i = 0; i < numberToChange; ++i) {
                int tryIndex = AbstractSqlEntityProcessorTestCase.random().nextInt(countries.length);
                String code = countries[tryIndex][0];
                if (changeSet.contains(code)) continue;
                changeSet.add(code);
                change.setString(1, "MODIFIED " + countries[tryIndex][1]);
                change.setTimestamp(2, theTime);
                change.setString(3, code);
                Assert.assertEquals((int)1, (int)change.executeUpdate());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                change.close();
            }
            catch (Exception exception) {}
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
        return changeSet.toArray(new String[changeSet.size()]);
    }

    @Override
    protected String generateConfig() {
        String ds = null;
        if (this.dbToUse == AbstractDIHJdbcTestCase.Database.DERBY) {
            ds = "derby";
        } else if (this.dbToUse == AbstractDIHJdbcTestCase.Database.HSQLDB) {
            ds = "hsqldb";
        } else {
            throw new AssertionError((Object)("Invalid database to use: " + (Object)((Object)this.dbToUse)));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n<dataConfig> \n");
        sb.append("<propertyWriter type=''SimplePropertiesWriter'' directory=''" + this.fileLocation + "'' filename=''" + this.fileName + "'' />\n");
        sb.append("<dataSource name=''hsqldb'' driver=''org.hsqldb.jdbcDriver'' url=''jdbc:hsqldb:mem:.'' /> \n");
        sb.append("<dataSource name=''derby'' driver=''org.apache.derby.jdbc.EmbeddedDriver'' url=''jdbc:derby:memory:derbyDB;territory=en_US'' /> \n");
        sb.append("<document name=''TestSqlEntityProcessor''> \n");
        sb.append("<entity name=''People'' ");
        sb.append("pk=''" + (AbstractSqlEntityProcessorTestCase.random().nextBoolean() ? "ID" : "People.ID") + "'' ");
        sb.append("processor=''SqlEntityProcessor'' ");
        sb.append("dataSource=''" + ds + "'' ");
        sb.append(this.rootTransformerName != null ? "transformer=''" + this.rootTransformerName + "'' " : "");
        sb.append("query=''SELECT ID, NAME, COUNTRY_CODE FROM PEOPLE WHERE DELETED != 'Y' " + (this.sportsZipper || this.countryZipper ? "ORDER BY ID" : "") + (this.wrongPeopleOrder ? " DESC" : "") + "'' ");
        sb.append(this.deltaQueriesPersonTable());
        sb.append("> \n");
        sb.append("<field column=''NAME'' name=''NAME_mult_s'' /> \n");
        sb.append("<field column=''COUNTRY_CODE'' name=''COUNTRY_CODES_mult_s'' /> \n");
        if (this.countryEntity) {
            sb.append("<entity name=''Countries'' ");
            sb.append("pk=''" + (AbstractSqlEntityProcessorTestCase.random().nextBoolean() ? "CODE" : "Countries.CODE") + "'' ");
            sb.append("dataSource=''" + ds + "'' ");
            sb.append(this.countryTransformer ? "transformer=''AddAColumnTransformer'' newColumnName=''countryAdded_s'' newColumnValue=''country_added'' " : "");
            if (this.countryCached) {
                sb.append("processor=''SqlEntityProcessor'' cacheImpl=''SortedMapBackedCache'' ");
                if (this.useSimpleCaches) {
                    sb.append("query=''SELECT CODE, COUNTRY_NAME FROM COUNTRIES WHERE DELETED != 'Y' AND CODE='${People.COUNTRY_CODE}' ''>\n");
                } else {
                    if (this.countryZipper) {
                        sb.append(AbstractSqlEntityProcessorTestCase.random().nextBoolean() ? "cacheKey=''ID'' cacheLookup=''People.ID'' " : "where=''ID=People.ID'' ");
                        sb.append("join=''zipper'' query=''SELECT PEOPLE.ID, CODE, COUNTRY_NAME FROM COUNTRIES JOIN PEOPLE ON COUNTRIES.CODE=PEOPLE.COUNTRY_CODE WHERE PEOPLE.DELETED != 'Y' ORDER BY PEOPLE.ID " + (this.wrongCountryOrder ? " DESC" : "") + "'' ");
                    } else {
                        sb.append(AbstractSqlEntityProcessorTestCase.random().nextBoolean() ? "cacheKey=''CODE'' cacheLookup=''People.COUNTRY_CODE'' " : "where=''CODE=People.COUNTRY_CODE'' ");
                        sb.append("query=''SELECT CODE, COUNTRY_NAME FROM COUNTRIES'' ");
                    }
                    sb.append("> \n");
                }
            } else {
                sb.append("processor=''SqlEntityProcessor'' query=''SELECT CODE, COUNTRY_NAME FROM COUNTRIES WHERE DELETED != 'Y' AND CODE='${People.COUNTRY_CODE}' '' ");
                sb.append(this.deltaQueriesCountryTable());
                sb.append("> \n");
            }
            sb.append("<field column=''CODE'' name=''COUNTRY_CODE_s'' /> \n");
            sb.append("<field column=''COUNTRY_NAME'' name=''COUNTRY_NAME_s'' /> \n");
            sb.append("</entity> \n");
        }
        if (this.sportsEntity) {
            sb.append("<entity name=''Sports'' ");
            sb.append("dataSource=''" + ds + "'' ");
            sb.append(this.sportsTransformer ? "transformer=''AddAColumnTransformer'' newColumnName=''sportsAdded_s'' newColumnValue=''sport_added'' " : "");
            if (this.sportsCached) {
                sb.append("processor=''SqlEntityProcessor'' cacheImpl=''SortedMapBackedCache'' ");
                if (this.useSimpleCaches) {
                    sb.append("query=''SELECT ID, SPORT_NAME FROM PEOPLE_SPORTS WHERE DELETED != 'Y' AND PERSON_ID=${People.ID} ORDER BY ID'' ");
                } else {
                    sb.append(AbstractSqlEntityProcessorTestCase.random().nextBoolean() ? "cacheKey=''PERSON_ID'' cacheLookup=''People.ID'' " : "where=''PERSON_ID=People.ID'' ");
                    if (this.sportsZipper) {
                        sb.append("join=''zipper'' query=''SELECT ID, PERSON_ID, SPORT_NAME FROM PEOPLE_SPORTS ORDER BY PERSON_ID" + (this.wrongSportsOrder ? " DESC" : "") + "'' ");
                    } else {
                        sb.append("query=''SELECT ID, PERSON_ID, SPORT_NAME FROM PEOPLE_SPORTS ORDER BY ID'' ");
                    }
                }
            } else {
                sb.append("processor=''SqlEntityProcessor'' query=''SELECT ID, SPORT_NAME FROM PEOPLE_SPORTS WHERE DELETED != 'Y' AND PERSON_ID=${People.ID} ORDER BY ID'' ");
            }
            sb.append("> \n");
            sb.append("<field column=''SPORT_NAME'' name=''SPORT_NAME_mult_s'' /> \n");
            sb.append("<field column=''id'' name=''SPORT_ID_mult_s'' /> \n");
            sb.append("</entity> \n");
        }
        sb.append("</entity> \n");
        sb.append("</document> \n");
        sb.append("</dataConfig> \n");
        String config = sb.toString().replaceAll("[']{2}", "\"");
        log.debug(config);
        return config;
    }

    @Override
    @SuppressForbidden(reason="Needs currentTimeMillis to set change time for SQL query")
    protected void populateData(Connection conn) throws Exception {
        Statement s = null;
        Statement ps = null;
        Timestamp theTime = new Timestamp(System.currentTimeMillis() - 10000L);
        try {
            s = conn.createStatement();
            s.executeUpdate("create table countries(code varchar(3) not null primary key, country_name varchar(50), deleted char(1) default 'N', last_modified timestamp not null)");
            s.executeUpdate("create table people(id int not null primary key, name varchar(50), country_code char(2), deleted char(1) default 'N', last_modified timestamp not null)");
            s.executeUpdate("create table people_sports(id int not null primary key, person_id int, sport_name varchar(50), deleted char(1) default 'N', last_modified timestamp not null)");
            log.debug("INSERTING DB DATA USING TIMESTAMP: " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.ROOT).format(theTime));
            ps = conn.prepareStatement("insert into countries (code, country_name, last_modified) values (?,?,?)");
            for (String[] stringArray : countries) {
                ps.setString(1, stringArray[0]);
                ps.setString(2, stringArray[1]);
                ps.setTimestamp(3, theTime);
                Assert.assertEquals((int)1, (int)ps.executeUpdate());
            }
            ps.close();
            ps = conn.prepareStatement("insert into people (id, name, country_code, last_modified) values (?,?,?,?)");
            for (Object[] objectArray : people) {
                ps.setInt(1, (Integer)objectArray[0]);
                ps.setString(2, (String)objectArray[1]);
                ps.setString(3, (String)objectArray[2]);
                ps.setTimestamp(4, theTime);
                Assert.assertEquals((int)1, (int)ps.executeUpdate());
            }
            ps.close();
            ps = conn.prepareStatement("insert into people_sports (id, person_id, sport_name, last_modified) values (?,?,?,?)");
            for (Object[] objectArray : people_sports) {
                ps.setInt(1, (Integer)objectArray[0]);
                ps.setInt(2, (Integer)objectArray[1]);
                ps.setString(3, (String)objectArray[2]);
                ps.setTimestamp(4, theTime);
                Assert.assertEquals((int)1, (int)ps.executeUpdate());
            }
            ps.close();
            conn.commit();
            conn.close();
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                ps.close();
            }
            catch (Exception exception) {}
            try {
                s.close();
            }
            catch (Exception exception) {}
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
    }

    static class IntChanges {
        public Integer[] changedKeys;
        public Integer[] deletedKeys;
        public Integer[] addedKeys;

        IntChanges() {
        }

        public String toString() {
            int i;
            int n;
            int n2;
            Integer[] integerArray;
            StringBuilder sb = new StringBuilder();
            if (this.changedKeys != null) {
                sb.append("changes: ");
                integerArray = this.changedKeys;
                n2 = integerArray.length;
                for (n = 0; n < n2; ++n) {
                    i = integerArray[n];
                    sb.append(i).append(" ");
                }
            }
            if (this.deletedKeys != null) {
                sb.append("deletes: ");
                integerArray = this.deletedKeys;
                n2 = integerArray.length;
                for (n = 0; n < n2; ++n) {
                    i = integerArray[n];
                    sb.append(i).append(" ");
                }
            }
            if (this.addedKeys != null) {
                sb.append("adds: ");
                integerArray = this.addedKeys;
                n2 = integerArray.length;
                for (n = 0; n < n2; ++n) {
                    i = integerArray[n];
                    sb.append(i).append(" ");
                }
            }
            return sb.toString();
        }
    }
}

