/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.List;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.handler.dataimport.SolrEntityProcessor;

public class MockSolrEntityProcessor
extends SolrEntityProcessor {
    private final List<SolrTestCaseJ4.Doc> docsData;
    private int queryCount = 0;
    private int rows;
    private int start = 0;

    public MockSolrEntityProcessor(List<SolrTestCaseJ4.Doc> docsData, int rows) {
        this.docsData = docsData;
        this.rows = rows;
    }

    protected void buildIterator() {
        if (this.rowIterator == null || !this.rowIterator.hasNext() && ((SolrEntityProcessor.SolrDocumentListIterator)this.rowIterator).hasMoreRows()) {
            ++this.queryCount;
            SolrDocumentList docs = this.getDocs(this.start, this.rows);
            this.rowIterator = new SolrEntityProcessor.SolrDocumentListIterator((SolrEntityProcessor)this, docs);
            this.start += docs.size();
        }
    }

    private SolrDocumentList getDocs(int start, int rows) {
        SolrDocumentList docs = new SolrDocumentList();
        docs.setNumFound((long)this.docsData.size());
        docs.setStart((long)start);
        int endIndex = start + rows;
        int end = this.docsData.size() < endIndex ? this.docsData.size() : endIndex;
        for (int i = start; i < end; ++i) {
            SolrDocument doc = new SolrDocument();
            SolrTestCaseJ4.Doc testDoc = this.docsData.get(i);
            doc.addField("id", (Object)testDoc.id);
            doc.addField("description", (Object)testDoc.getValues("description"));
            docs.add((Object)doc);
        }
        return docs;
    }

    public int getQueryCount() {
        return this.queryCount;
    }
}

