/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.ContextImpl;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DateFormatEvaluator;
import org.apache.solr.handler.dataimport.Evaluator;
import org.apache.solr.handler.dataimport.SqlEscapingEvaluator;
import org.apache.solr.handler.dataimport.UrlEvaluator;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBuiltInEvaluators
extends AbstractDataImportHandlerTestCase {
    private static final String ENCODING = StandardCharsets.UTF_8.name();
    VariableResolver resolver;
    Map<String, String> sqlTests;
    Map<String, String> urlTests;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.resolver = new VariableResolver();
        this.sqlTests = new HashMap<String, String>();
        this.sqlTests.put("foo\"", "foo\"\"");
        this.sqlTests.put("foo\\", "foo\\\\");
        this.sqlTests.put("foo'", "foo''");
        this.sqlTests.put("foo''", "foo''''");
        this.sqlTests.put("'foo\"", "''foo\"\"");
        this.sqlTests.put("\"Albert D'souza\"", "\"\"Albert D''souza\"\"");
        this.urlTests = new HashMap<String, String>();
        this.urlTests.put("*:*", URLEncoder.encode("*:*", ENCODING));
        this.urlTests.put("price:[* TO 200]", URLEncoder.encode("price:[* TO 200]", ENCODING));
        this.urlTests.put("review:\"hybrid sedan\"", URLEncoder.encode("review:\"hybrid sedan\"", ENCODING));
    }

    @Test
    public void testSqlEscapingEvaluator() {
        SqlEscapingEvaluator sqlEscaper = new SqlEscapingEvaluator();
        this.runTests(this.sqlTests, (Evaluator)sqlEscaper);
    }

    @Test
    public void testUrlEvaluator() throws Exception {
        UrlEvaluator urlEvaluator = new UrlEvaluator();
        this.runTests(this.urlTests, (Evaluator)urlEvaluator);
    }

    @Test
    public void parseParams() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("b", "B");
        VariableResolver vr = new VariableResolver();
        vr.addNamespace("a", m);
        List l = new Evaluator(){

            public String evaluate(String expression, Context context) {
                return null;
            }
        }.parseParams(" 1 , a.b, 'hello!', 'ds,o,u'za',", vr);
        TestBuiltInEvaluators.assertEquals((Object)new Double(1.0), l.get(0));
        TestBuiltInEvaluators.assertEquals((Object)"B", (Object)((Evaluator.VariableWrapper)l.get(1)).resolve());
        TestBuiltInEvaluators.assertEquals((Object)"hello!", l.get(2));
        TestBuiltInEvaluators.assertEquals((Object)"ds,o,u'za", l.get(3));
    }

    @Test
    public void testEscapeSolrQueryFunction() {
        VariableResolver resolver = new VariableResolver();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("query", "c:t");
        resolver.setEvaluators(new DataImporter().getEvaluators(Collections.emptyList()));
        resolver.addNamespace("e", m);
        String s = resolver.replaceTokens("${dataimporter.functions.escapeQueryChars(e.query)}");
        Assert.assertEquals((Object)"c\\:t", (Object)s);
    }

    private Date twoDaysAgo(Locale l, TimeZone tz) {
        Calendar calendar = Calendar.getInstance(tz, l);
        calendar.add(6, -2);
        return calendar.getTime();
    }

    @Test
    public void testDateFormatEvaluator() {
        TimeZone tz;
        DateFormatEvaluator dateFormatEval = new DateFormatEvaluator();
        ContextImpl context = new ContextImpl(null, this.resolver, null, "FULL_DUMP", Collections.emptyMap(), null, null);
        Locale rootLocale = Locale.ROOT;
        Locale defaultLocale = Locale.getDefault();
        TimeZone defaultTz = TimeZone.getDefault();
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH", rootLocale);
        String sdf = sdfDate.format(this.twoDaysAgo(rootLocale, defaultTz));
        String dfe = dateFormatEval.evaluate("'NOW-2DAYS','yyyy-MM-dd HH'", (Context)context);
        TestBuiltInEvaluators.assertEquals((Object)sdf, (Object)dfe);
        sdfDate = new SimpleDateFormat("yyyy-MM-dd HH", defaultLocale);
        sdf = sdfDate.format(this.twoDaysAgo(defaultLocale, TimeZone.getDefault()));
        dfe = dateFormatEval.evaluate("'NOW-2DAYS','yyyy-MM-dd HH','" + defaultLocale.toLanguageTag() + "'", (Context)context);
        TestBuiltInEvaluators.assertEquals((Object)sdf, (Object)dfe);
        for (String tzStr : TimeZone.getAvailableIDs()) {
            tz = TimeZone.getTimeZone(tzStr);
            sdfDate.setTimeZone(tz);
            sdf = sdfDate.format(this.twoDaysAgo(defaultLocale, tz));
            dfe = dateFormatEval.evaluate("'NOW-2DAYS','yyyy-MM-dd HH','" + defaultLocale.toLanguageTag() + "','" + tzStr + "'", (Context)context);
            TestBuiltInEvaluators.assertEquals((Object)sdf, (Object)dfe);
        }
        Date d = new Date();
        HashMap<String, Date> map = new HashMap<String, Date>();
        map.put("key", d);
        this.resolver.addNamespace("A", map);
        TestBuiltInEvaluators.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd HH:mm", rootLocale).format(d), (Object)dateFormatEval.evaluate("A.key, 'yyyy-MM-dd HH:mm'", (Context)context));
        TestBuiltInEvaluators.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd HH:mm", defaultLocale).format(d), (Object)dateFormatEval.evaluate("A.key, 'yyyy-MM-dd HH:mm','" + defaultLocale.toLanguageTag() + "'", (Context)context));
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm", defaultLocale);
        for (String tzStr : TimeZone.getAvailableIDs()) {
            tz = TimeZone.getTimeZone(tzStr);
            sdf2.setTimeZone(tz);
            TestBuiltInEvaluators.assertEquals((Object)sdf2.format(d), (Object)dateFormatEval.evaluate("A.key, 'yyyy-MM-dd HH:mm','" + defaultLocale.toLanguageTag() + "', '" + tzStr + "'", (Context)context));
        }
    }

    private void runTests(Map<String, String> tests, Evaluator evaluator) {
        ContextImpl ctx = new ContextImpl(null, this.resolver, null, "FULL_DUMP", Collections.emptyMap(), null, null);
        for (Map.Entry<String, String> entry : tests.entrySet()) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("key", entry.getKey());
            this.resolver.addNamespace("A", values);
            String expected = entry.getValue();
            String actual = evaluator.evaluate("A.key", (Context)ctx);
            TestBuiltInEvaluators.assertEquals((Object)expected, (Object)actual);
        }
    }
}

