/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.DirectXmlRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestContentStreamDataSource
extends AbstractDataImportHandlerTestCase {
    private static final String CONF_DIR = "dih/solr/collection1/conf/";
    private static final String ROOT_DIR = "dih/solr/";
    SolrInstance instance = null;
    JettySolrRunner jetty;
    static String xml = "<root>\n<b>\n  <id>1</id>\n  <c>Hello C1</c>\n</b>\n<b>\n  <id>2</id>\n  <c>Hello C2</c>\n</b>\n</root>";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.instance = new SolrInstance("inst", null);
        this.instance.setUp();
        this.jetty = this.createJetty(this.instance);
    }

    @After
    public void tearDown() throws Exception {
        this.jetty.stop();
        super.tearDown();
    }

    @Test
    public void testSimple() throws Exception {
        DirectXmlRequest req = new DirectXmlRequest("/dataimport", xml);
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("command", new String[]{"full-import"});
        params.set("clean", new String[]{"false"});
        req.setParams((SolrParams)params);
        try (HttpSolrClient solrClient = TestContentStreamDataSource.getHttpSolrClient((String)TestContentStreamDataSource.buildUrl((int)this.jetty.getLocalPort(), (String)"/solr/collection1"));){
            solrClient.request((SolrRequest)req);
            ModifiableSolrParams qparams = new ModifiableSolrParams();
            qparams.add("q", new String[]{"*:*"});
            QueryResponse qres = solrClient.query((SolrParams)qparams);
            SolrDocumentList results = qres.getResults();
            TestContentStreamDataSource.assertEquals((long)2L, (long)results.getNumFound());
            SolrDocument doc = (SolrDocument)results.get(0);
            TestContentStreamDataSource.assertEquals((Object)"1", (Object)doc.getFieldValue("id"));
            TestContentStreamDataSource.assertEquals((Object)"Hello C1", ((List)doc.getFieldValue("desc")).get(0));
        }
    }

    @Test
    public void testCommitWithin() throws Exception {
        DirectXmlRequest req = new DirectXmlRequest("/dataimport", xml);
        ModifiableSolrParams params = TestContentStreamDataSource.params((String[])new String[]{"command", "full-import", "clean", "false", "commit", "false", "commitWithin", "1000"});
        req.setParams((SolrParams)params);
        try (HttpSolrClient solrServer = TestContentStreamDataSource.getHttpSolrClient((String)TestContentStreamDataSource.buildUrl((int)this.jetty.getLocalPort(), (String)"/solr/collection1"));){
            solrServer.request((SolrRequest)req);
            Thread.sleep(100L);
            ModifiableSolrParams queryAll = TestContentStreamDataSource.params((String[])new String[]{"q", "*", "df", "desc"});
            QueryResponse qres = solrServer.query((SolrParams)queryAll);
            SolrDocumentList results = qres.getResults();
            TestContentStreamDataSource.assertEquals((long)0L, (long)results.getNumFound());
            Thread.sleep(1000L);
            for (int i = 0; i < 10; ++i) {
                qres = solrServer.query((SolrParams)queryAll);
                results = qres.getResults();
                if (2L == results.getNumFound()) {
                    return;
                }
                Thread.sleep(500L);
            }
        }
        TestContentStreamDataSource.fail((String)"Commit should have occured but it did not");
    }

    private JettySolrRunner createJetty(SolrInstance instance) throws Exception {
        Properties nodeProperties = new Properties();
        nodeProperties.setProperty("solr.data.dir", instance.getDataDir());
        JettySolrRunner jetty = new JettySolrRunner(instance.getHomeDir(), nodeProperties, TestContentStreamDataSource.buildJettyConfig((String)"/solr"));
        jetty.start();
        return jetty;
    }

    private static class SolrInstance {
        String name;
        Integer port;
        File homeDir;
        File confDir;
        File dataDir;

        public SolrInstance(String name, Integer port) {
            this.name = name;
            this.port = port;
        }

        public String getHomeDir() {
            return this.homeDir.toString();
        }

        public String getSchemaFile() {
            return "dih/solr/collection1/conf/dataimport-schema.xml";
        }

        public String getConfDir() {
            return this.confDir.toString();
        }

        public String getDataDir() {
            return this.dataDir.toString();
        }

        public String getSolrConfigFile() {
            return "dih/solr/collection1/conf/contentstream-solrconfig.xml";
        }

        public String getSolrXmlFile() {
            return "dih/solr/solr.xml";
        }

        public void setUp() throws Exception {
            this.homeDir = LuceneTestCase.createTempDir((String)"inst").toFile();
            this.dataDir = new File(this.homeDir + "/collection1", "data");
            this.confDir = new File(this.homeDir + "/collection1", "conf");
            this.homeDir.mkdirs();
            this.dataDir.mkdirs();
            this.confDir.mkdirs();
            FileUtils.copyFile((File)SolrTestCaseJ4.getFile((String)this.getSolrXmlFile()), (File)new File(this.homeDir, "solr.xml"));
            File f = new File(this.confDir, "solrconfig.xml");
            FileUtils.copyFile((File)SolrTestCaseJ4.getFile((String)this.getSolrConfigFile()), (File)f);
            f = new File(this.confDir, "schema.xml");
            FileUtils.copyFile((File)SolrTestCaseJ4.getFile((String)this.getSchemaFile()), (File)f);
            f = new File(this.confDir, "data-config.xml");
            FileUtils.copyFile((File)SolrTestCaseJ4.getFile((String)"dih/solr/collection1/conf/dataconfig-contentstream.xml"), (File)f);
            Files.createFile(this.homeDir.toPath().resolve("collection1/core.properties"), new FileAttribute[0]);
        }
    }
}

