/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.HashMap;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.ContextImpl;
import org.apache.solr.handler.dataimport.DIHProperties;
import org.apache.solr.handler.dataimport.DIHWriter;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.RequestInfo;
import org.apache.solr.handler.dataimport.SimplePropertiesWriter;
import org.apache.solr.handler.dataimport.SolrWriter;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.junit.Test;

public class TestContextImpl
extends AbstractDataImportHandlerTestCase {
    @Test
    public void testEntityScope() {
        ContextImpl ctx = new ContextImpl(null, new VariableResolver(), null, "something", new HashMap(), null, null);
        String lala = new String("lala");
        ctx.setSessionAttribute("huhu", (Object)lala, "entity");
        Object got = ctx.getSessionAttribute("huhu", "entity");
        TestContextImpl.assertEquals((Object)lala, (Object)got);
    }

    @Test
    public void testCoreScope() {
        DataImporter di = new DataImporter();
        di.loadAndInit("<dataConfig><document /></dataConfig>");
        DocBuilder db = new DocBuilder(di, (DIHWriter)new SolrWriter(null, null), (DIHProperties)new SimplePropertiesWriter(), new RequestInfo(null, new HashMap(), null));
        ContextImpl ctx = new ContextImpl(null, new VariableResolver(), null, "something", new HashMap(), null, db);
        String lala = new String("lala");
        ctx.setSessionAttribute("huhu", (Object)lala, "solrcore");
        Object got = ctx.getSessionAttribute("huhu", "solrcore");
        TestContextImpl.assertEquals((Object)lala, (Object)got);
    }

    @Test
    public void testDocumentScope() {
        ContextImpl ctx = new ContextImpl(null, new VariableResolver(), null, "something", new HashMap(), null, null);
        ctx.setDoc(new DocBuilder.DocWrapper());
        String lala = new String("lala");
        ctx.setSessionAttribute("huhu", (Object)lala, "document");
        Object got = ctx.getSessionAttribute("huhu", "document");
        TestContextImpl.assertEquals((Object)lala, (Object)got);
    }

    @Test
    public void testGlobalScope() {
        ContextImpl ctx = new ContextImpl(null, new VariableResolver(), null, "something", new HashMap(), null, null);
        String lala = new String("lala");
        ctx.setSessionAttribute("huhu", (Object)lala, "global");
        Object got = ctx.getSessionAttribute("huhu", "global");
        TestContextImpl.assertEquals((Object)lala, (Object)got);
    }
}

