/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.MockDataSource;
import org.apache.solr.handler.dataimport.config.DIHConfiguration;
import org.apache.solr.handler.dataimport.config.Entity;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class TestDataConfig
extends AbstractDataImportHandlerTestCase {
    private static final String xml = "<dataConfig>\n\t<document name=\"autos\" >\n\t\t<entity name=\"atrimlisting\" pk=\"acode\"\n\t\t\tquery=\"select acode,make,model,year,msrp,category,image,izmo_image_url,price_range_low,price_range_high,invoice_range_low,invoice_range_high from atrimlisting\"\n\t\t\tdeltaQuery=\"select acode from atrimlisting where last_modified > '${indexer.last_index_time}'\">\n\t\t</entity>\n\t</document>\n</dataConfig>";

    @BeforeClass
    public static void beforeClass() throws Exception {
        TestDataConfig.initCore("dataimport-nodatasource-solrconfig.xml", "dataimport-schema.xml");
    }

    @Test
    public void testDataConfigWithDataSource() throws Exception {
        ArrayList<Map> rows = new ArrayList<Map>();
        rows.add(TestDataConfig.createMap("id", "1", "desc", "one"));
        MockDataSource.setIterator((String)"select * from x", rows.iterator());
        this.runFullImport(this.loadDataConfig("data-config-with-datasource.xml"));
        TestDataConfig.assertQ((SolrQueryRequest)TestDataConfig.req((String[])new String[]{"id:1"}), (String[])new String[]{"//*[@numFound='1']"});
    }

    @Test
    public void testBasic() throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(xml)));
        DataImporter di = new DataImporter();
        DIHConfiguration dc = di.readFromXml(doc);
        TestDataConfig.assertEquals((Object)"atrimlisting", (Object)((Entity)dc.getEntities().get(0)).getName());
    }
}

