/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DateFormatTransformer;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.junit.Test;

public class TestDateFormatTransformer
extends AbstractDataImportHandlerTestCase {
    @Test
    public void testTransformRow_SingleRow() throws Exception {
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        fields.add(TestDateFormatTransformer.createMap("column", "lastModified"));
        fields.add(TestDateFormatTransformer.createMap("column", "dateAdded", "sourceColName", "lastModified", "dateTimeFormat", "${xyz.myDateFormat}"));
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy", Locale.ROOT);
        Date now = format.parse(format.format(new Date()));
        Map row = TestDateFormatTransformer.createMap("lastModified", format.format(now));
        VariableResolver resolver = new VariableResolver();
        resolver.addNamespace("e", row);
        resolver.addNamespace("xyz", TestDateFormatTransformer.createMap("myDateFormat", "MM/dd/yyyy"));
        AbstractDataImportHandlerTestCase.TestContext context = TestDateFormatTransformer.getContext(null, resolver, null, "FULL_DUMP", fields, null);
        new DateFormatTransformer().transformRow(row, (Context)context);
        TestDateFormatTransformer.assertEquals((Object)now, row.get("dateAdded"));
    }

    @Test
    public void testTransformRow_MultipleRows() throws Exception {
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        fields.add(TestDateFormatTransformer.createMap("column", "lastModified"));
        fields.add(TestDateFormatTransformer.createMap("column", "dateAdded", "sourceColName", "lastModified", "dateTimeFormat", "MM/dd/yyyy hh:mm:ss.SSS"));
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss.SSS", Locale.ROOT);
        Date now1 = format.parse(format.format(new Date()));
        Date now2 = format.parse(format.format(new Date()));
        HashMap row = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add(format.format(now1));
        list.add(format.format(now2));
        row.put("lastModified", list);
        VariableResolver resolver = new VariableResolver();
        resolver.addNamespace("e", row);
        AbstractDataImportHandlerTestCase.TestContext context = TestDateFormatTransformer.getContext(null, resolver, null, "FULL_DUMP", fields, null);
        new DateFormatTransformer().transformRow(row, (Context)context);
        ArrayList<Date> output = new ArrayList<Date>();
        output.add(now1);
        output.add(now2);
        TestDateFormatTransformer.assertEquals(output, row.get("dateAdded"));
    }
}

