/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.DIHWriter;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.MockDataSource;
import org.apache.solr.handler.dataimport.MockStringDataSource;
import org.apache.solr.handler.dataimport.RequestInfo;
import org.apache.solr.handler.dataimport.SolrWriter;
import org.apache.solr.handler.dataimport.config.DIHConfiguration;
import org.apache.solr.handler.dataimport.config.Entity;
import org.junit.After;
import org.junit.Test;

public class TestDocBuilder
extends AbstractDataImportHandlerTestCase {
    public static final String dc_singleEntity = "<dataConfig>\n<dataSource  type=\"MockDataSource\"/>\n    <document name=\"X\" >\n        <entity name=\"x\" query=\"select * from x\">\n          <field column=\"id\"/>\n          <field column=\"desc\"/>\n          <field column=\"desc\" name=\"desc_s\" />        </entity>\n    </document>\n</dataConfig>";
    public static final String dc_deltaConfig = "<dataConfig>\n<dataSource  type=\"MockDataSource\"/>\n    <document name=\"X\" >\n        <entity name=\"x\" query=\"select * from x\" deltaQuery=\"select id from x\">\n          <field column=\"id\"/>\n          <field column=\"desc\"/>\n          <field column=\"desc\" name=\"desc_s\" />        </entity>\n    </document>\n</dataConfig>";
    public static final String dc_variableXpath = "<dataConfig>\n<dataSource type=\"MockDataSource\"/>\n<dataSource name=\"xml\" type=\"MockStringDataSource\"/>\n    <document name=\"X\" >\n        <entity name=\"x\" query=\"select * from x\">\n          <field column=\"id\"/>\n          <field column=\"name\"/>\n          <field column=\"manufacturer\"/>          <entity name=\"c1\" url=\"companies.xml\" dataSource=\"xml\" forEach=\"/companies/company\" processor=\"XPathEntityProcessor\">            <field column=\"year\" xpath=\"/companies/company/year[@name='p_${x.manufacturer}_s']\" />          </entity>          <entity name=\"c2\" url=\"companies2.xml\" dataSource=\"xml\" forEach=\"/companies/company\" processor=\"XPathEntityProcessor\">            <field column=\"founded\" xpath=\"/companies/company/p_${x.manufacturer}_s/founded\" />          </entity>          <entity name=\"c3\" url=\"companies3.xml\" dataSource=\"xml\" forEach=\"/companies/${x.manufacturer}\" processor=\"XPathEntityProcessor\">            <field column=\"year2\" xpath=\"/companies/${x.manufacturer}/year\" />          </entity>        </entity>\n    </document>\n</dataConfig>";
    public static final String xml_variableForEach = "<companies>\n\t<Apple>\n\t\t<year>1976</year>\n\t</Apple>\n\t<Google>\n\t\t<year>1998</year>\n\t</Google>\n</companies>";
    public static final String xml_variableXpath = "<companies>\n\t<company>\n\t\t<p_Apple_s>\n\t\t\t<founded>Cupertino, California, U.S</founded>\n\t\t</p_Apple_s>\t\t\n\t</company>\n\t<company>\n\t\t<p_Google_s>\n\t\t\t<founded>Menlo Park, California, U.S</founded>\n\t\t</p_Google_s>\n\t</company>\n</companies>";
    public static final String xml_attrVariableXpath = "<companies>\n\t<company>\n\t\t<year name='p_Apple_s'>1976</year>\n\t</company>\n\t<company>\n\t\t<year name='p_Google_s'>1998</year>\t\t\n\t</company>\n</companies>";

    @After
    public void tearDown() throws Exception {
        MockDataSource.clearCache();
        MockStringDataSource.clearCache();
        super.tearDown();
    }

    @Test
    public void loadClass() throws Exception {
        Class clz = DocBuilder.loadClass((String)"RegexTransformer", null);
        TestDocBuilder.assertNotNull((Object)clz);
    }

    @Test
    public void singleEntityNoRows() {
        DataImporter di = new DataImporter();
        di.loadAndInit(dc_singleEntity);
        DIHConfiguration cfg = di.getConfig();
        Entity ent = (Entity)cfg.getEntities().get(0);
        MockDataSource.setIterator((String)"select * from x", new ArrayList().iterator());
        RequestInfo rp = new RequestInfo(null, TestDocBuilder.createMap("command", "full-import"), null);
        SolrWriterImpl swi = new SolrWriterImpl();
        di.runCmd(rp, (DIHWriter)swi);
        TestDocBuilder.assertEquals((Object)Boolean.TRUE, (Object)swi.deleteAllCalled);
        TestDocBuilder.assertEquals((Object)Boolean.TRUE, (Object)swi.commitCalled);
        TestDocBuilder.assertEquals((Object)Boolean.TRUE, (Object)swi.finishCalled);
        TestDocBuilder.assertEquals((long)0L, (long)swi.docs.size());
        TestDocBuilder.assertEquals((long)1L, (long)di.getDocBuilder().importStatistics.queryCount.get());
        TestDocBuilder.assertEquals((long)0L, (long)di.getDocBuilder().importStatistics.docCount.get());
        TestDocBuilder.assertEquals((long)0L, (long)di.getDocBuilder().importStatistics.rowsCount.get());
    }

    @Test
    public void testDeltaImportNoRows_MustNotCommit() {
        DataImporter di = new DataImporter();
        di.loadAndInit(dc_deltaConfig);
        this.redirectTempProperties(di);
        DIHConfiguration cfg = di.getConfig();
        Entity ent = (Entity)cfg.getEntities().get(0);
        MockDataSource.setIterator((String)"select * from x", new ArrayList().iterator());
        MockDataSource.setIterator((String)"select id from x", new ArrayList().iterator());
        RequestInfo rp = new RequestInfo(null, TestDocBuilder.createMap("command", "delta-import"), null);
        SolrWriterImpl swi = new SolrWriterImpl();
        di.runCmd(rp, (DIHWriter)swi);
        TestDocBuilder.assertEquals((Object)Boolean.FALSE, (Object)swi.deleteAllCalled);
        TestDocBuilder.assertEquals((Object)Boolean.FALSE, (Object)swi.commitCalled);
        TestDocBuilder.assertEquals((Object)Boolean.TRUE, (Object)swi.finishCalled);
        TestDocBuilder.assertEquals((long)0L, (long)swi.docs.size());
        TestDocBuilder.assertEquals((long)1L, (long)di.getDocBuilder().importStatistics.queryCount.get());
        TestDocBuilder.assertEquals((long)0L, (long)di.getDocBuilder().importStatistics.docCount.get());
        TestDocBuilder.assertEquals((long)0L, (long)di.getDocBuilder().importStatistics.rowsCount.get());
    }

    @Test
    public void singleEntityOneRow() {
        DataImporter di = new DataImporter();
        di.loadAndInit(dc_singleEntity);
        DIHConfiguration cfg = di.getConfig();
        Entity ent = (Entity)cfg.getEntities().get(0);
        ArrayList<Map> l = new ArrayList<Map>();
        l.add(TestDocBuilder.createMap("id", 1, "desc", "one"));
        MockDataSource.setIterator((String)"select * from x", l.iterator());
        RequestInfo rp = new RequestInfo(null, TestDocBuilder.createMap("command", "full-import"), null);
        SolrWriterImpl swi = new SolrWriterImpl();
        di.runCmd(rp, (DIHWriter)swi);
        TestDocBuilder.assertEquals((Object)Boolean.TRUE, (Object)swi.deleteAllCalled);
        TestDocBuilder.assertEquals((Object)Boolean.TRUE, (Object)swi.commitCalled);
        TestDocBuilder.assertEquals((Object)Boolean.TRUE, (Object)swi.finishCalled);
        TestDocBuilder.assertEquals((long)1L, (long)swi.docs.size());
        TestDocBuilder.assertEquals((long)1L, (long)di.getDocBuilder().importStatistics.queryCount.get());
        TestDocBuilder.assertEquals((long)1L, (long)di.getDocBuilder().importStatistics.docCount.get());
        TestDocBuilder.assertEquals((long)1L, (long)di.getDocBuilder().importStatistics.rowsCount.get());
        for (int i = 0; i < l.size(); ++i) {
            Map map = (Map)l.get(i);
            SolrInputDocument doc = swi.docs.get(i);
            for (Map.Entry entry : map.entrySet()) {
                TestDocBuilder.assertEquals(entry.getValue(), (Object)doc.getFieldValue((String)entry.getKey()));
            }
        }
    }

    @Test
    public void testImportCommand() {
        DataImporter di = new DataImporter();
        di.loadAndInit(dc_singleEntity);
        DIHConfiguration cfg = di.getConfig();
        Entity ent = (Entity)cfg.getEntities().get(0);
        ArrayList<Map> l = new ArrayList<Map>();
        l.add(TestDocBuilder.createMap("id", 1, "desc", "one"));
        MockDataSource.setIterator((String)"select * from x", l.iterator());
        RequestInfo rp = new RequestInfo(null, TestDocBuilder.createMap("command", "import"), null);
        SolrWriterImpl swi = new SolrWriterImpl();
        di.runCmd(rp, (DIHWriter)swi);
        TestDocBuilder.assertEquals((Object)Boolean.FALSE, (Object)swi.deleteAllCalled);
        TestDocBuilder.assertEquals((Object)Boolean.TRUE, (Object)swi.commitCalled);
        TestDocBuilder.assertEquals((Object)Boolean.TRUE, (Object)swi.finishCalled);
        TestDocBuilder.assertEquals((long)1L, (long)swi.docs.size());
        TestDocBuilder.assertEquals((long)1L, (long)di.getDocBuilder().importStatistics.queryCount.get());
        TestDocBuilder.assertEquals((long)1L, (long)di.getDocBuilder().importStatistics.docCount.get());
        TestDocBuilder.assertEquals((long)1L, (long)di.getDocBuilder().importStatistics.rowsCount.get());
        for (int i = 0; i < l.size(); ++i) {
            Map map = (Map)l.get(i);
            SolrInputDocument doc = swi.docs.get(i);
            for (Map.Entry entry : map.entrySet()) {
                TestDocBuilder.assertEquals(entry.getValue(), (Object)doc.getFieldValue((String)entry.getKey()));
            }
        }
    }

    @Test
    public void singleEntityMultipleRows() {
        DataImporter di = new DataImporter();
        di.loadAndInit(dc_singleEntity);
        DIHConfiguration cfg = di.getConfig();
        Entity ent = (Entity)cfg.getEntities().get(0);
        RequestInfo rp = new RequestInfo(null, TestDocBuilder.createMap("command", "full-import"), null);
        ArrayList<Map> l = new ArrayList<Map>();
        l.add(TestDocBuilder.createMap("id", 1, "desc", "one"));
        l.add(TestDocBuilder.createMap("id", 2, "desc", "two"));
        l.add(TestDocBuilder.createMap("id", 3, "desc", "three"));
        MockDataSource.setIterator((String)"select * from x", l.iterator());
        SolrWriterImpl swi = new SolrWriterImpl();
        di.runCmd(rp, (DIHWriter)swi);
        TestDocBuilder.assertEquals((Object)Boolean.TRUE, (Object)swi.deleteAllCalled);
        TestDocBuilder.assertEquals((Object)Boolean.TRUE, (Object)swi.commitCalled);
        TestDocBuilder.assertEquals((Object)Boolean.TRUE, (Object)swi.finishCalled);
        TestDocBuilder.assertEquals((long)3L, (long)swi.docs.size());
        for (int i = 0; i < l.size(); ++i) {
            Map map = (Map)l.get(i);
            SolrInputDocument doc = swi.docs.get(i);
            for (Map.Entry entry : map.entrySet()) {
                TestDocBuilder.assertEquals(entry.getValue(), (Object)doc.getFieldValue((String)entry.getKey()));
            }
            TestDocBuilder.assertEquals(map.get("desc"), (Object)doc.getFieldValue("desc_s"));
        }
        TestDocBuilder.assertEquals((long)1L, (long)di.getDocBuilder().importStatistics.queryCount.get());
        TestDocBuilder.assertEquals((long)3L, (long)di.getDocBuilder().importStatistics.docCount.get());
        TestDocBuilder.assertEquals((long)3L, (long)di.getDocBuilder().importStatistics.rowsCount.get());
    }

    @Test
    public void templateXPath() {
        DataImporter di = new DataImporter();
        di.loadAndInit(dc_variableXpath);
        DIHConfiguration cfg = di.getConfig();
        RequestInfo rp = new RequestInfo(null, TestDocBuilder.createMap("command", "full-import"), null);
        ArrayList<Map> l = new ArrayList<Map>();
        l.add(TestDocBuilder.createMap("id", 1, "name", "iphone", "manufacturer", "Apple"));
        l.add(TestDocBuilder.createMap("id", 2, "name", "ipad", "manufacturer", "Apple"));
        l.add(TestDocBuilder.createMap("id", 3, "name", "pixel", "manufacturer", "Google"));
        MockDataSource.setIterator((String)"select * from x", l.iterator());
        ArrayList<Map> nestedData = new ArrayList<Map>();
        nestedData.add(TestDocBuilder.createMap("founded", "Cupertino, California, U.S", "year", "1976", "year2", "1976"));
        nestedData.add(TestDocBuilder.createMap("founded", "Cupertino, California, U.S", "year", "1976", "year2", "1976"));
        nestedData.add(TestDocBuilder.createMap("founded", "Menlo Park, California, U.S", "year", "1998", "year2", "1998"));
        MockStringDataSource.setData("companies.xml", xml_attrVariableXpath);
        MockStringDataSource.setData("companies2.xml", xml_variableXpath);
        MockStringDataSource.setData("companies3.xml", xml_variableForEach);
        SolrWriterImpl swi = new SolrWriterImpl();
        di.runCmd(rp, (DIHWriter)swi);
        TestDocBuilder.assertEquals((Object)Boolean.TRUE, (Object)swi.deleteAllCalled);
        TestDocBuilder.assertEquals((Object)Boolean.TRUE, (Object)swi.commitCalled);
        TestDocBuilder.assertEquals((Object)Boolean.TRUE, (Object)swi.finishCalled);
        TestDocBuilder.assertEquals((long)3L, (long)swi.docs.size());
        for (int i = 0; i < l.size(); ++i) {
            SolrInputDocument doc = swi.docs.get(i);
            Map map = (Map)l.get(i);
            for (Map.Entry entry : map.entrySet()) {
                TestDocBuilder.assertEquals(entry.getValue(), (Object)doc.getFieldValue((String)entry.getKey()));
            }
            map = (Map)nestedData.get(i);
            for (Map.Entry entry : map.entrySet()) {
                TestDocBuilder.assertEquals(entry.getValue(), (Object)doc.getFieldValue((String)entry.getKey()));
            }
        }
        TestDocBuilder.assertEquals((long)1L, (long)di.getDocBuilder().importStatistics.queryCount.get());
        TestDocBuilder.assertEquals((long)3L, (long)di.getDocBuilder().importStatistics.docCount.get());
    }

    static class SolrWriterImpl
    extends SolrWriter {
        List<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
        Boolean deleteAllCalled = Boolean.FALSE;
        Boolean commitCalled = Boolean.FALSE;
        Boolean finishCalled = Boolean.FALSE;

        public SolrWriterImpl() {
            super(null, null);
        }

        public boolean upload(SolrInputDocument doc) {
            return this.docs.add(doc);
        }

        public void doDeleteAll() {
            this.deleteAllCalled = Boolean.TRUE;
        }

        public void commit(boolean b) {
            this.commitCalled = Boolean.TRUE;
        }

        public void close() {
            this.finishCalled = Boolean.TRUE;
        }
    }
}

