/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.ContextImpl;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.EventListener;
import org.apache.solr.handler.dataimport.MockDataSource;
import org.apache.solr.handler.dataimport.Transformer;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestDocBuilder2
extends AbstractDataImportHandlerTestCase {
    private final String requestParamAsVariable = "<dataConfig>\n    <dataSource type=\"MockDataSource\" />\n    <document>\n        <entity name=\"books\" query=\"select * from books where category='${dataimporter.request.category}'\">\n            <field column=\"id\" />\n            <field column=\"desc\" />\n        </entity>\n    </document>\n</dataConfig>";
    private final String dataConfigWithDynamicTransformer = "<dataConfig> <dataSource type=\"MockDataSource\"/>\n    <document>\n        <entity name=\"books\" query=\"select * from x\"                transformer=\"TestDocBuilder2$AddDynamicFieldTransformer\">\n            <field column=\"id\" />\n            <field column=\"desc\" />\n        </entity>\n    </document>\n</dataConfig>";
    private final String dataConfigForSkipTransform = "<dataConfig> <dataSource  type=\"MockDataSource\"/>\n    <document>\n        <entity name=\"books\" query=\"select * from x\"                transformer=\"TemplateTransformer\">\n            <field column=\"id\" />\n            <field column=\"desc\" />\n            <field column=\"name_s\" template=\"xyz\" />\n        </entity>\n    </document>\n</dataConfig>";
    private final String dataConfigWithTwoEntities = "<dataConfig><dataSource type=\"MockDataSource\"/>\n    <document>\n        <entity name=\"books\" query=\"select * from x\">            <field column=\"id\" />\n            <field column=\"desc\" />\n            <entity name=\"authors\" query=\"${books.id}\">               <field column=\"name_s\" />            </entity>        </entity>\n    </document>\n</dataConfig>";
    private final String dataConfigWithCaseInsensitiveFields = "<dataConfig> <dataSource  type=\"MockDataSource\"/>\n    <document onImportStart=\"TestDocBuilder2$StartEventListener\" onImportEnd=\"TestDocBuilder2$EndEventListener\">\n        <entity name=\"books\" query=\"select * from x\">\n            <field column=\"ID\" />\n            <field column=\"Desc\" />\n        </entity>\n    </document>\n</dataConfig>";
    private final String dataConfigWithErrorHandler = "<dataConfig> <dataSource  type=\"MockDataSource\"/>\n    <document onError=\"TestDocBuilder2$ErrorEventListener\">\n        <entity name=\"books\" query=\"select * from x\" transformer=\"TestDocBuilder2$ForcedExceptionTransformer\">\n            <field column=\"id\" />\n            <field column=\"FORCE_ERROR\" />\n        </entity>\n    </document>\n</dataConfig>";
    private final String dataConfigWithTemplatizedFieldNames = "<dataConfig><dataSource  type=\"MockDataSource\"/>\n    <document>\n        <entity name=\"books\" query=\"select * from x\">\n            <field column=\"mypk\" name=\"${dih.request.mypk}\" />\n            <field column=\"text\" name=\"${dih.request.text}\" />\n        </entity>\n    </document>\n</dataConfig>";
    private final String dataConfigWithDynamicFieldNames = "<dataConfig><dataSource  type=\"MockDataSource\"/>\n    <document>\n        <entity name=\"books\" query=\"select * from x\">\n            <field column=\"mypk\" name=\"id\" />\n            <field column=\"text\" name=\"${books.mypk}_s\" />\n        </entity>\n    </document>\n</dataConfig>";
    private final String dataConfigFileList = "<dataConfig>\n\t<document>\n\t\t<entity name=\"x\" processor=\"FileListEntityProcessor\" \n\t\t\t\tfileName=\".*\" newerThan=\"${dih.last_index_time}\" \n\t\t\t\tbaseDir=\"${dih.request.baseDir}\" transformer=\"TemplateTransformer\">\n\t\t\t<field column=\"id\" template=\"${x.file}\" />\n\t\t</entity>\n\t</document>\n</dataConfig>";

    @BeforeClass
    public static void beforeClass() throws Exception {
        TestDocBuilder2.initCore("dataimport-solrconfig.xml", "dataimport-schema.xml");
    }

    @Test
    public void testSingleEntity() throws Exception {
        ArrayList<Map> rows = new ArrayList<Map>();
        rows.add(TestDocBuilder2.createMap("id", "1", "desc", "one"));
        MockDataSource.setIterator((String)"select * from x", rows.iterator());
        this.runFullImport(this.loadDataConfig("single-entity-data-config.xml"));
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:1"}), (String[])new String[]{"//*[@numFound='1']"});
        TestDocBuilder2.assertTrue((String)"Update request processor processAdd was not called", (boolean)AbstractDataImportHandlerTestCase.TestUpdateRequestProcessor.processAddCalled);
        TestDocBuilder2.assertTrue((String)"Update request processor processCommit was not callled", (boolean)AbstractDataImportHandlerTestCase.TestUpdateRequestProcessor.processCommitCalled);
        TestDocBuilder2.assertTrue((String)"Update request processor finish was not called", (boolean)AbstractDataImportHandlerTestCase.TestUpdateRequestProcessor.finishCalled);
    }

    @Test
    public void testSingleEntity_CaseInsensitive() throws Exception {
        ArrayList<Map> rows = new ArrayList<Map>();
        rows.add(TestDocBuilder2.createMap("id", "1", "desC", "one"));
        MockDataSource.setIterator((String)"select * from x", rows.iterator());
        this.runFullImport("<dataConfig> <dataSource  type=\"MockDataSource\"/>\n    <document onImportStart=\"TestDocBuilder2$StartEventListener\" onImportEnd=\"TestDocBuilder2$EndEventListener\">\n        <entity name=\"books\" query=\"select * from x\">\n            <field column=\"ID\" />\n            <field column=\"Desc\" />\n        </entity>\n    </document>\n</dataConfig>");
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:1"}), (String[])new String[]{"//*[@numFound='1']"});
        TestDocBuilder2.assertTrue((String)"Start event listener was not called", (boolean)StartEventListener.executed);
        TestDocBuilder2.assertTrue((String)"End event listener was not called", (boolean)EndEventListener.executed);
        TestDocBuilder2.assertTrue((String)"Update request processor processAdd was not called", (boolean)AbstractDataImportHandlerTestCase.TestUpdateRequestProcessor.processAddCalled);
        TestDocBuilder2.assertTrue((String)"Update request processor finish was not called", (boolean)AbstractDataImportHandlerTestCase.TestUpdateRequestProcessor.finishCalled);
    }

    @Test
    public void testErrorHandler() throws Exception {
        ArrayList<Map> rows = new ArrayList<Map>();
        rows.add(TestDocBuilder2.createMap("id", "1", "FORCE_ERROR", "true"));
        MockDataSource.setIterator((String)"select * from x", rows.iterator());
        this.runFullImport("<dataConfig> <dataSource  type=\"MockDataSource\"/>\n    <document onError=\"TestDocBuilder2$ErrorEventListener\">\n        <entity name=\"books\" query=\"select * from x\" transformer=\"TestDocBuilder2$ForcedExceptionTransformer\">\n            <field column=\"id\" />\n            <field column=\"FORCE_ERROR\" />\n        </entity>\n    </document>\n</dataConfig>");
        TestDocBuilder2.assertTrue((String)"Error event listener was not called", (boolean)ErrorEventListener.executed);
        TestDocBuilder2.assertTrue((boolean)ErrorEventListener.lastException.getMessage().contains("ForcedException"));
    }

    @Test
    public void testDynamicFields() throws Exception {
        ArrayList<Map> rows = new ArrayList<Map>();
        rows.add(TestDocBuilder2.createMap("id", "1", "desc", "one"));
        MockDataSource.setIterator((String)"select * from x", rows.iterator());
        this.runFullImport("<dataConfig> <dataSource type=\"MockDataSource\"/>\n    <document>\n        <entity name=\"books\" query=\"select * from x\"                transformer=\"TestDocBuilder2$AddDynamicFieldTransformer\">\n            <field column=\"id\" />\n            <field column=\"desc\" />\n        </entity>\n    </document>\n</dataConfig>");
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:1"}), (String[])new String[]{"//*[@numFound='1']"});
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"dynamic_s:test"}), (String[])new String[]{"//*[@numFound='1']"});
    }

    @Test
    public void testRequestParamsAsVariable() throws Exception {
        ArrayList<Map> rows = new ArrayList<Map>();
        rows.add(TestDocBuilder2.createMap("id", "101", "desc", "ApacheSolr"));
        MockDataSource.setIterator((String)"select * from books where category='search'", rows.iterator());
        LocalSolrQueryRequest request = lrf.makeRequest(new String[]{"command", "full-import", "debug", "on", "clean", "true", "commit", "true", "category", "search", "dataConfig", "<dataConfig>\n    <dataSource type=\"MockDataSource\" />\n    <document>\n        <entity name=\"books\" query=\"select * from books where category='${dataimporter.request.category}'\">\n            <field column=\"id\" />\n            <field column=\"desc\" />\n        </entity>\n    </document>\n</dataConfig>"});
        h.query("/dataimport", (SolrQueryRequest)request);
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"desc:ApacheSolr"}), (String[])new String[]{"//*[@numFound='1']"});
    }

    @Test
    public void testDynamicFieldNames() throws Exception {
        ArrayList<Map> rows = new ArrayList<Map>();
        rows.add(TestDocBuilder2.createMap("mypk", "101", "text", "ApacheSolr"));
        MockDataSource.setIterator((String)"select * from x", rows.iterator());
        LocalSolrQueryRequest request = lrf.makeRequest(new String[]{"command", "full-import", "debug", "on", "clean", "true", "commit", "true", "dataConfig", "<dataConfig><dataSource  type=\"MockDataSource\"/>\n    <document>\n        <entity name=\"books\" query=\"select * from x\">\n            <field column=\"mypk\" name=\"id\" />\n            <field column=\"text\" name=\"${books.mypk}_s\" />\n        </entity>\n    </document>\n</dataConfig>"});
        h.query("/dataimport", (SolrQueryRequest)request);
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:101"}), (String[])new String[]{"//*[@numFound='1']", "//*[@name='101_s']"});
    }

    @Test
    public void testRequestParamsAsFieldName() throws Exception {
        ArrayList<Map> rows = new ArrayList<Map>();
        rows.add(TestDocBuilder2.createMap("mypk", "101", "text", "ApacheSolr"));
        MockDataSource.setIterator((String)"select * from x", rows.iterator());
        LocalSolrQueryRequest request = lrf.makeRequest(new String[]{"command", "full-import", "debug", "on", "clean", "true", "commit", "true", "mypk", "id", "text", "desc", "dataConfig", "<dataConfig><dataSource  type=\"MockDataSource\"/>\n    <document>\n        <entity name=\"books\" query=\"select * from x\">\n            <field column=\"mypk\" name=\"${dih.request.mypk}\" />\n            <field column=\"text\" name=\"${dih.request.text}\" />\n        </entity>\n    </document>\n</dataConfig>"});
        h.query("/dataimport", (SolrQueryRequest)request);
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:101"}), (String[])new String[]{"//*[@numFound='1']"});
    }

    @Test
    public void testContext() throws Exception {
        ArrayList<Map> rows = new ArrayList<Map>();
        rows.add(TestDocBuilder2.createMap("id", "1", "desc", "one"));
        MockDataSource.setIterator((String)"select * from x", rows.iterator());
        this.runFullImport(this.loadDataConfig("data-config-with-transformer.xml"));
    }

    @Test
    public void testSkipDoc() throws Exception {
        ArrayList<Map> rows = new ArrayList<Map>();
        rows.add(TestDocBuilder2.createMap("id", "1", "desc", "one"));
        rows.add(TestDocBuilder2.createMap("id", "2", "desc", "two", "$skipDoc", "true"));
        MockDataSource.setIterator((String)"select * from x", rows.iterator());
        this.runFullImport("<dataConfig> <dataSource type=\"MockDataSource\"/>\n    <document>\n        <entity name=\"books\" query=\"select * from x\"                transformer=\"TestDocBuilder2$AddDynamicFieldTransformer\">\n            <field column=\"id\" />\n            <field column=\"desc\" />\n        </entity>\n    </document>\n</dataConfig>");
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:1"}), (String[])new String[]{"//*[@numFound='1']"});
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:2"}), (String[])new String[]{"//*[@numFound='0']"});
    }

    @Test
    public void testSkipRow() throws Exception {
        ArrayList<Map> rows = new ArrayList<Map>();
        rows.add(TestDocBuilder2.createMap("id", "1", "desc", "one"));
        rows.add(TestDocBuilder2.createMap("id", "2", "desc", "two", "$skipRow", "true"));
        MockDataSource.setIterator((String)"select * from x", rows.iterator());
        this.runFullImport("<dataConfig> <dataSource type=\"MockDataSource\"/>\n    <document>\n        <entity name=\"books\" query=\"select * from x\"                transformer=\"TestDocBuilder2$AddDynamicFieldTransformer\">\n            <field column=\"id\" />\n            <field column=\"desc\" />\n        </entity>\n    </document>\n</dataConfig>");
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:1"}), (String[])new String[]{"//*[@numFound='1']"});
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:2"}), (String[])new String[]{"//*[@numFound='0']"});
        MockDataSource.clearCache();
        rows = new ArrayList();
        rows.add(TestDocBuilder2.createMap("id", "3", "desc", "one"));
        rows.add(TestDocBuilder2.createMap("id", "4", "desc", "two"));
        MockDataSource.setIterator((String)"select * from x", rows.iterator());
        rows = new ArrayList();
        rows.add(TestDocBuilder2.createMap("name_s", "abcd"));
        MockDataSource.setIterator((String)"3", rows.iterator());
        rows = new ArrayList();
        rows.add(TestDocBuilder2.createMap("name_s", "xyz", "$skipRow", "true"));
        MockDataSource.setIterator((String)"4", rows.iterator());
        this.runFullImport("<dataConfig><dataSource type=\"MockDataSource\"/>\n    <document>\n        <entity name=\"books\" query=\"select * from x\">            <field column=\"id\" />\n            <field column=\"desc\" />\n            <entity name=\"authors\" query=\"${books.id}\">               <field column=\"name_s\" />            </entity>        </entity>\n    </document>\n</dataConfig>");
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:3"}), (String[])new String[]{"//*[@numFound='1']"});
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:4"}), (String[])new String[]{"//*[@numFound='1']"});
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"name_s:abcd"}), (String[])new String[]{"//*[@numFound='1']"});
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"name_s:xyz"}), (String[])new String[]{"//*[@numFound='0']"});
    }

    @Test
    public void testStopTransform() throws Exception {
        ArrayList<Map> rows = new ArrayList<Map>();
        rows.add(TestDocBuilder2.createMap("id", "1", "desc", "one"));
        rows.add(TestDocBuilder2.createMap("id", "2", "desc", "two", "$stopTransform", "true"));
        MockDataSource.setIterator((String)"select * from x", rows.iterator());
        this.runFullImport("<dataConfig> <dataSource  type=\"MockDataSource\"/>\n    <document>\n        <entity name=\"books\" query=\"select * from x\"                transformer=\"TemplateTransformer\">\n            <field column=\"id\" />\n            <field column=\"desc\" />\n            <field column=\"name_s\" template=\"xyz\" />\n        </entity>\n    </document>\n</dataConfig>");
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:1"}), (String[])new String[]{"//*[@numFound='1']"});
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:2"}), (String[])new String[]{"//*[@numFound='1']"});
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"name_s:xyz"}), (String[])new String[]{"//*[@numFound='1']"});
    }

    @Test
    public void testDeleteDocs() throws Exception {
        ArrayList<Map> rows = new ArrayList<Map>();
        rows.add(TestDocBuilder2.createMap("id", "1", "desc", "one"));
        rows.add(TestDocBuilder2.createMap("id", "2", "desc", "two"));
        rows.add(TestDocBuilder2.createMap("id", "3", "desc", "two", "$deleteDocById", "2"));
        MockDataSource.setIterator((String)"select * from x", rows.iterator());
        this.runFullImport("<dataConfig> <dataSource  type=\"MockDataSource\"/>\n    <document>\n        <entity name=\"books\" query=\"select * from x\"                transformer=\"TemplateTransformer\">\n            <field column=\"id\" />\n            <field column=\"desc\" />\n            <field column=\"name_s\" template=\"xyz\" />\n        </entity>\n    </document>\n</dataConfig>");
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:1"}), (String[])new String[]{"//*[@numFound='1']"});
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:2"}), (String[])new String[]{"//*[@numFound='0']"});
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:3"}), (String[])new String[]{"//*[@numFound='1']"});
        TestDocBuilder2.assertTrue((String)"Update request processor processDelete was not called", (boolean)AbstractDataImportHandlerTestCase.TestUpdateRequestProcessor.processDeleteCalled);
        TestDocBuilder2.assertTrue((String)"Update request processor finish was not called", (boolean)AbstractDataImportHandlerTestCase.TestUpdateRequestProcessor.finishCalled);
        MockDataSource.clearCache();
        rows = new ArrayList();
        rows.add(TestDocBuilder2.createMap("id", "1", "desc", "one"));
        rows.add(TestDocBuilder2.createMap("id", "2", "desc", "one"));
        rows.add(TestDocBuilder2.createMap("id", "3", "desc", "two", "$deleteDocByQuery", "desc:one"));
        MockDataSource.setIterator((String)"select * from x", rows.iterator());
        this.runFullImport("<dataConfig> <dataSource  type=\"MockDataSource\"/>\n    <document>\n        <entity name=\"books\" query=\"select * from x\"                transformer=\"TemplateTransformer\">\n            <field column=\"id\" />\n            <field column=\"desc\" />\n            <field column=\"name_s\" template=\"xyz\" />\n        </entity>\n    </document>\n</dataConfig>");
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:1"}), (String[])new String[]{"//*[@numFound='0']"});
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:2"}), (String[])new String[]{"//*[@numFound='0']"});
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:3"}), (String[])new String[]{"//*[@numFound='1']"});
        TestDocBuilder2.assertTrue((String)"Update request processor processDelete was not called", (boolean)AbstractDataImportHandlerTestCase.TestUpdateRequestProcessor.processDeleteCalled);
        TestDocBuilder2.assertTrue((String)"Update request processor finish was not called", (boolean)AbstractDataImportHandlerTestCase.TestUpdateRequestProcessor.finishCalled);
        MockDataSource.clearCache();
        rows = new ArrayList();
        rows.add(TestDocBuilder2.createMap("$deleteDocById", "3"));
        MockDataSource.setIterator((String)"select * from x", rows.iterator());
        this.runFullImport("<dataConfig> <dataSource  type=\"MockDataSource\"/>\n    <document>\n        <entity name=\"books\" query=\"select * from x\"                transformer=\"TemplateTransformer\">\n            <field column=\"id\" />\n            <field column=\"desc\" />\n            <field column=\"name_s\" template=\"xyz\" />\n        </entity>\n    </document>\n</dataConfig>", TestDocBuilder2.createMap("clean", "false"));
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"id:3"}), (String[])new String[]{"//*[@numFound='0']"});
        TestDocBuilder2.assertTrue((String)"Update request processor processDelete was not called", (boolean)AbstractDataImportHandlerTestCase.TestUpdateRequestProcessor.processDeleteCalled);
        TestDocBuilder2.assertTrue((String)"Update request processor finish was not called", (boolean)AbstractDataImportHandlerTestCase.TestUpdateRequestProcessor.finishCalled);
    }

    @Test
    @Ignore(value="Fix Me. See SOLR-4103.")
    public void testFileListEntityProcessor_lastIndexTime() throws Exception {
        File tmpdir = TestDocBuilder2.createTempDir().toFile();
        Map params = TestDocBuilder2.createMap("baseDir", tmpdir.getAbsolutePath());
        TestDocBuilder2.createFile(tmpdir, "a.xml", "a.xml".getBytes(StandardCharsets.UTF_8), true);
        TestDocBuilder2.createFile(tmpdir, "b.xml", "b.xml".getBytes(StandardCharsets.UTF_8), true);
        TestDocBuilder2.createFile(tmpdir, "c.props", "c.props".getBytes(StandardCharsets.UTF_8), true);
        this.runFullImport("<dataConfig>\n\t<document>\n\t\t<entity name=\"x\" processor=\"FileListEntityProcessor\" \n\t\t\t\tfileName=\".*\" newerThan=\"${dih.last_index_time}\" \n\t\t\t\tbaseDir=\"${dih.request.baseDir}\" transformer=\"TemplateTransformer\">\n\t\t\t<field column=\"id\" template=\"${x.file}\" />\n\t\t</entity>\n\t</document>\n</dataConfig>", params);
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"*:*"}), (String[])new String[]{"//*[@numFound='3']"});
        TestDocBuilder2.createFile(tmpdir, "t.xml", "t.xml".getBytes(StandardCharsets.UTF_8), false);
        this.runFullImport("<dataConfig>\n\t<document>\n\t\t<entity name=\"x\" processor=\"FileListEntityProcessor\" \n\t\t\t\tfileName=\".*\" newerThan=\"${dih.last_index_time}\" \n\t\t\t\tbaseDir=\"${dih.request.baseDir}\" transformer=\"TemplateTransformer\">\n\t\t\t<field column=\"id\" template=\"${x.file}\" />\n\t\t</entity>\n\t</document>\n</dataConfig>", params);
        TestDocBuilder2.assertQ((SolrQueryRequest)TestDocBuilder2.req((String[])new String[]{"*:*"}), (String[])new String[]{"//*[@numFound='1']"});
    }

    public static class ErrorEventListener
    implements EventListener {
        public static boolean executed = false;
        public static Exception lastException = null;

        public void onEvent(Context ctx) {
            executed = true;
            lastException = ((ContextImpl)ctx).getLastException();
        }
    }

    public static class EndEventListener
    implements EventListener {
        public static boolean executed = false;

        public void onEvent(Context ctx) {
            executed = true;
        }
    }

    public static class StartEventListener
    implements EventListener {
        public static boolean executed = false;

        public void onEvent(Context ctx) {
            executed = true;
        }
    }

    public static class MockDataSource2
    extends MockDataSource {
    }

    public static class ForcedExceptionTransformer
    extends Transformer {
        public Object transformRow(Map<String, Object> row, Context context) {
            throw new DataImportHandlerException(500, "ForcedException");
        }
    }

    public static class AddDynamicFieldTransformer
    extends Transformer {
        public Object transformRow(Map<String, Object> row, Context context) {
            row.put("dynamic_s", "test");
            return row;
        }
    }

    public static class MockTransformer
    extends Transformer {
        public Object transformRow(Map<String, Object> row, Context context) {
            Assert.assertTrue((String)"Context gave incorrect data source", (boolean)(context.getDataSource("mockDs") instanceof MockDataSource2));
            return row;
        }
    }
}

