/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.EntityProcessorWrapper;
import org.apache.solr.handler.dataimport.MockDataSource;
import org.apache.solr.handler.dataimport.SqlEntityProcessor;
import org.apache.solr.handler.dataimport.Transformer;
import org.junit.Test;

public class TestEntityProcessorBase
extends AbstractDataImportHandlerTestCase {
    @Test
    public void multiTransformer() {
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        HashMap<String, String> entity = new HashMap<String, String>();
        entity.put("transformer", T1.class.getName() + "," + T2.class.getName() + "," + T3.class.getName());
        fields.add(TestEntityProcessorBase.getField("A", null, null, null, null));
        fields.add(TestEntityProcessorBase.getField("B", null, null, null, null));
        AbstractDataImportHandlerTestCase.TestContext context = TestEntityProcessorBase.getContext(null, null, (DataSource)new MockDataSource(), "FULL_DUMP", fields, entity);
        HashMap<String, String> src = new HashMap<String, String>();
        src.put("A", "NA");
        src.put("B", "NA");
        EntityProcessorWrapper sep = new EntityProcessorWrapper((EntityProcessor)new SqlEntityProcessor(), null, null);
        sep.init((Context)context);
        Map res = sep.applyTransformer(src);
        TestEntityProcessorBase.assertNotNull(res.get("T1"));
        TestEntityProcessorBase.assertNotNull(res.get("T2"));
        TestEntityProcessorBase.assertNotNull(res.get("T3"));
    }

    static class T3 {
        T3() {
        }

        public Object transformRow(Map<String, Object> aRow) {
            aRow.put("T3", "T3 called");
            return aRow;
        }
    }

    static class T2
    extends Transformer {
        T2() {
        }

        public Object transformRow(Map<String, Object> aRow, Context context) {
            aRow.put("T2", "T2 called");
            return aRow;
        }
    }

    static class T1
    extends Transformer {
        T1() {
        }

        public Object transformRow(Map<String, Object> aRow, Context context) {
            aRow.put("T1", "T1 called");
            return aRow;
        }
    }
}

