/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.DestroyCountCache;
import org.apache.solr.handler.dataimport.MockDataSource;
import org.apache.solr.request.SolrQueryRequest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestEphemeralCache
extends AbstractDataImportHandlerTestCase {
    @BeforeClass
    public static void beforeClass() throws Exception {
        TestEphemeralCache.initCore("dataimport-solrconfig.xml", "dataimport-schema.xml");
    }

    @Before
    public void reset() {
        DestroyCountCache.destroyed.clear();
        this.setupMockData();
    }

    @Test
    public void test() throws Exception {
        this.assertFullImport(this.getDataConfigDotXml());
    }

    private void setupMockData() {
        ArrayList<Map> parentRows = new ArrayList<Map>();
        parentRows.add(TestEphemeralCache.createMap("id", new BigDecimal("1"), "parent_s", "one"));
        parentRows.add(TestEphemeralCache.createMap("id", new BigDecimal("2"), "parent_s", "two"));
        parentRows.add(TestEphemeralCache.createMap("id", new BigDecimal("3"), "parent_s", "three"));
        parentRows.add(TestEphemeralCache.createMap("id", new BigDecimal("4"), "parent_s", "four"));
        parentRows.add(TestEphemeralCache.createMap("id", new BigDecimal("5"), "parent_s", "five"));
        ArrayList<Map> child1Rows = new ArrayList<Map>();
        child1Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("6"), "child1a_mult_s", "this is the number six."));
        child1Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("5"), "child1a_mult_s", "this is the number five."));
        child1Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("6"), "child1a_mult_s", "let's sing a song of six."));
        child1Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("3"), "child1a_mult_s", "three"));
        child1Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("3"), "child1a_mult_s", "III"));
        child1Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("3"), "child1a_mult_s", "3"));
        child1Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("3"), "child1a_mult_s", "|||"));
        child1Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("1"), "child1a_mult_s", "one"));
        child1Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("1"), "child1a_mult_s", "uno"));
        child1Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("2"), "child1b_s", "CHILD1B", "child1a_mult_s", "this is the number two."));
        ArrayList<Map> child2Rows = new ArrayList<Map>();
        child2Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("6"), "child2a_mult_s", "Child 2 says, 'this is the number six.'"));
        child2Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("5"), "child2a_mult_s", "Child 2 says, 'this is the number five.'"));
        child2Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("6"), "child2a_mult_s", "Child 2 says, 'let's sing a song of six.'"));
        child2Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("3"), "child2a_mult_s", "Child 2 says, 'three'"));
        child2Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("3"), "child2a_mult_s", "Child 2 says, 'III'"));
        child2Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("3"), "child2b_s", "CHILD2B", "child2a_mult_s", "Child 2 says, '3'"));
        child2Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("3"), "child2a_mult_s", "Child 2 says, '|||'"));
        child2Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("1"), "child2a_mult_s", "Child 2 says, 'one'"));
        child2Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("1"), "child2a_mult_s", "Child 2 says, 'uno'"));
        child2Rows.add(TestEphemeralCache.createMap("id", new BigDecimal("2"), "child2a_mult_s", "Child 2 says, 'this is the number two.'"));
        MockDataSource.setIterator((String)"SELECT * FROM PARENT", parentRows.iterator());
        MockDataSource.setIterator((String)"SELECT * FROM CHILD_1", child1Rows.iterator());
        MockDataSource.setIterator((String)"SELECT * FROM CHILD_2", child2Rows.iterator());
    }

    private String getDataConfigDotXml() {
        return "<dataConfig> <dataSource type=\"MockDataSource\" /> <document>   <entity      name=\"PARENT\"     processor=\"SqlEntityProcessor\"     cacheImpl=\"org.apache.solr.handler.dataimport.DestroyCountCache\"     cacheName=\"PARENT\"     query=\"SELECT * FROM PARENT\"     >     <entity       name=\"CHILD_1\"       processor=\"SqlEntityProcessor\"       cacheImpl=\"org.apache.solr.handler.dataimport.DestroyCountCache\"       cacheName=\"CHILD\"       cacheKey=\"id\"       cacheLookup=\"PARENT.id\"       fieldNames=\"id,         child1a_mult_s, child1b_s\"       fieldTypes=\"BIGDECIMAL, STRING,         STRING\"       query=\"SELECT * FROM CHILD_1\"            />     <entity       name=\"CHILD_2\"       processor=\"SqlEntityProcessor\"       cacheImpl=\"org.apache.solr.handler.dataimport.DestroyCountCache\"       cacheKey=\"id\"       cacheLookup=\"PARENT.id\"       query=\"SELECT * FROM CHILD_2\"            />   </entity> </document></dataConfig>";
    }

    private void assertFullImport(String dataConfig) throws Exception {
        this.runFullImport(dataConfig);
        TestEphemeralCache.assertQ((SolrQueryRequest)TestEphemeralCache.req((String[])new String[]{"*:*"}), (String[])new String[]{"//*[@numFound='5']"});
        TestEphemeralCache.assertQ((SolrQueryRequest)TestEphemeralCache.req((String[])new String[]{"id:1"}), (String[])new String[]{"//*[@numFound='1']"});
        TestEphemeralCache.assertQ((SolrQueryRequest)TestEphemeralCache.req((String[])new String[]{"id:6"}), (String[])new String[]{"//*[@numFound='0']"});
        TestEphemeralCache.assertQ((SolrQueryRequest)TestEphemeralCache.req((String[])new String[]{"parent_s:four"}), (String[])new String[]{"//*[@numFound='1']"});
        TestEphemeralCache.assertQ((SolrQueryRequest)TestEphemeralCache.req((String[])new String[]{"child1a_mult_s:this\\ is\\ the\\ numbe*"}), (String[])new String[]{"//*[@numFound='2']"});
        TestEphemeralCache.assertQ((SolrQueryRequest)TestEphemeralCache.req((String[])new String[]{"child2a_mult_s:Child\\ 2\\ say*"}), (String[])new String[]{"//*[@numFound='4']"});
        TestEphemeralCache.assertQ((SolrQueryRequest)TestEphemeralCache.req((String[])new String[]{"child1b_s:CHILD1B"}), (String[])new String[]{"//*[@numFound='1']"});
        TestEphemeralCache.assertQ((SolrQueryRequest)TestEphemeralCache.req((String[])new String[]{"child2b_s:CHILD2B"}), (String[])new String[]{"//*[@numFound='1']"});
        TestEphemeralCache.assertQ((SolrQueryRequest)TestEphemeralCache.req((String[])new String[]{"child1a_mult_s:one"}), (String[])new String[]{"//*[@numFound='1']"});
        TestEphemeralCache.assertQ((SolrQueryRequest)TestEphemeralCache.req((String[])new String[]{"child1a_mult_s:uno"}), (String[])new String[]{"//*[@numFound='1']"});
        TestEphemeralCache.assertQ((SolrQueryRequest)TestEphemeralCache.req((String[])new String[]{"child1a_mult_s:(uno OR one)"}), (String[])new String[]{"//*[@numFound='1']"});
        TestEphemeralCache.assertThat((Object)DestroyCountCache.destroyed.size(), (Matcher)CoreMatchers.is((Object)3));
    }
}

