/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.MockDataSource;
import org.apache.solr.handler.dataimport.Transformer;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public class TestErrorHandling
extends AbstractDataImportHandlerTestCase {
    static String savedFactory;
    private String dataConfigWithStreaming = "<dataConfig>\n        <dataSource name=\"str\" type=\"TestErrorHandling$StringDataSource\" />    <document>\n        <entity name=\"node\" dataSource=\"str\" processor=\"XPathEntityProcessor\" url=\"test\" stream=\"true\" forEach=\"/root/node\" onError=\"skip\">\n            <field column=\"id\" xpath=\"/root/node/id\" />\n            <field column=\"desc\" xpath=\"/root/node/desc\" />\n        </entity>\n    </document>\n</dataConfig>";
    private String dataConfigWithoutStreaming = "<dataConfig>\n        <dataSource name=\"str\" type=\"TestErrorHandling$StringDataSource\" />    <document>\n        <entity name=\"node\" dataSource=\"str\" processor=\"XPathEntityProcessor\" url=\"test\" forEach=\"/root/node\" onError=\"skip\">\n            <field column=\"id\" xpath=\"/root/node/id\" />\n            <field column=\"desc\" xpath=\"/root/node/desc\" />\n        </entity>\n    </document>\n</dataConfig>";
    private String dataConfigAbortOnError = "<dataConfig>\n        <dataSource name=\"str\" type=\"TestErrorHandling$StringDataSource\" />    <document>\n        <entity name=\"node\" dataSource=\"str\" processor=\"XPathEntityProcessor\" url=\"test\" forEach=\"/root/node\" onError=\"abort\">\n            <field column=\"id\" xpath=\"/root/node/id\" />\n            <field column=\"desc\" xpath=\"/root/node/desc\" />\n        </entity>\n    </document>\n</dataConfig>";
    private String dataConfigWithTransformer = "<dataConfig>\n        <dataSource name=\"str\" type=\"TestErrorHandling$StringDataSource\" /><dataSource  type=\"MockDataSource\"/>    <document>\n        <entity name=\"node\" dataSource=\"str\" processor=\"XPathEntityProcessor\" url=\"test\" forEach=\"/root/node\">\n            <field column=\"id\" xpath=\"/root/node/id\" />\n            <field column=\"desc\" xpath=\"/root/node/desc\" />\n            <entity name=\"child\" query=\"select * from foo\" transformer=\"TestErrorHandling$ExceptionTransformer\" onError=\"continue\">\n            </entity>        </entity>\n    </document>\n</dataConfig>";
    private String dataConfigWithEntity = "<!DOCTYPE dataConfig [\n  <!ENTITY internalTerm \"node\">\n  <!ENTITY externalTerm SYSTEM \"foo://bar.xyz/external\">\n]><dataConfig>\n    <dataSource name=\"str\" type=\"TestErrorHandling$StringDataSource\" />    <document>\n        <entity name=\"&internalTerm;\" dataSource=\"str\" processor=\"XPathEntityProcessor\" url=\"test\" forEach=\"/root/node\" onError=\"skip\">\n            <field column=\"id\" xpath=\"/root/node/id\">&externalTerm;</field>\n            <field column=\"desc\" xpath=\"/root/node/desc\" />\n        </entity>\n    </document>\n</dataConfig>";
    private String malformedXml = "<root>\n    <node>\n        <id>1</id>\n        <desc>test1</desc>\n    </node>\n    <node>\n        <id>2</id>\n        <desc>test2</desc>\n    </node>\n    <node>\n        <id/>3</id>\n        <desc>test3</desc>\n    </node>\n</root>";
    private String wellformedXml = "<root>\n    <node>\n        <id>1</id>\n        <desc>test1</desc>\n    </node>\n    <node>\n        <id>2</id>\n        <desc>test2</desc>\n    </node>\n    <node>\n        <id>3</id>\n        <desc>test3</desc>\n    </node>\n</root>";

    @BeforeClass
    public static void beforeClass() throws Exception {
        savedFactory = System.getProperty("solr.DirectoryFactory");
        System.setProperty("solr.directoryFactory", "solr.MockFSDirectoryFactory");
        TestErrorHandling.initCore("dataimport-solrconfig.xml", "dataimport-schema.xml");
        TestErrorHandling.ignoreException((String)"Unexpected close tag");
    }

    @AfterClass
    public static void afterClass() {
        if (savedFactory == null) {
            System.clearProperty("solr.directoryFactory");
        } else {
            System.setProperty("solr.directoryFactory", savedFactory);
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.clearIndex();
        TestErrorHandling.assertU((String)TestErrorHandling.commit((String[])new String[0]));
    }

    public void testMalformedStreamingXml() throws Exception {
        StringDataSource.xml = this.malformedXml;
        this.runFullImport(this.dataConfigWithStreaming);
        TestErrorHandling.assertQ((SolrQueryRequest)TestErrorHandling.req((String[])new String[]{"id:1"}), (String[])new String[]{"//*[@numFound='1']"});
        TestErrorHandling.assertQ((SolrQueryRequest)TestErrorHandling.req((String[])new String[]{"id:2"}), (String[])new String[]{"//*[@numFound='1']"});
    }

    public void testMalformedNonStreamingXml() throws Exception {
        StringDataSource.xml = this.malformedXml;
        this.runFullImport(this.dataConfigWithoutStreaming);
        TestErrorHandling.assertQ((SolrQueryRequest)TestErrorHandling.req((String[])new String[]{"id:1"}), (String[])new String[]{"//*[@numFound='1']"});
        TestErrorHandling.assertQ((SolrQueryRequest)TestErrorHandling.req((String[])new String[]{"id:2"}), (String[])new String[]{"//*[@numFound='1']"});
    }

    public void testAbortOnError() throws Exception {
        StringDataSource.xml = this.malformedXml;
        this.runFullImport(this.dataConfigAbortOnError);
        TestErrorHandling.assertQ((SolrQueryRequest)TestErrorHandling.req((String[])new String[]{"*:*"}), (String[])new String[]{"//*[@numFound='0']"});
    }

    public void testTransformerErrorContinue() throws Exception {
        StringDataSource.xml = this.wellformedXml;
        ArrayList<Map> rows = new ArrayList<Map>();
        rows.add(TestErrorHandling.createMap("id", "3", "desc", "exception-transformer"));
        MockDataSource.setIterator((String)"select * from foo", rows.iterator());
        this.runFullImport(this.dataConfigWithTransformer);
        TestErrorHandling.assertQ((SolrQueryRequest)TestErrorHandling.req((String[])new String[]{"*:*"}), (String[])new String[]{"//*[@numFound='3']"});
    }

    public void testExternalEntity() throws Exception {
        StringDataSource.xml = this.wellformedXml;
        this.runFullImport(this.dataConfigWithEntity);
        TestErrorHandling.assertQ((SolrQueryRequest)TestErrorHandling.req((String[])new String[]{"*:*"}), (String[])new String[]{"//*[@numFound='3']"});
    }

    public static class ExceptionTransformer
    extends Transformer {
        public Object transformRow(Map<String, Object> row, Context context) {
            throw new RuntimeException("Test exception");
        }
    }

    public static class StringDataSource
    extends DataSource<Reader> {
        public static String xml = "";

        public void init(Context context, Properties initProps) {
        }

        public Reader getData(String query) {
            return new StringReader(xml);
        }

        public void close() {
        }
    }
}

