/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.ArrayList;
import java.util.Map;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.DIHWriter;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.MockDataSource;
import org.apache.solr.handler.dataimport.RequestInfo;
import org.apache.solr.handler.dataimport.TestDocBuilder;
import org.junit.Test;

public class TestFieldReader
extends AbstractDataImportHandlerTestCase {
    String config = "<dataConfig>\n  <dataSource type=\"FieldReaderDataSource\" name=\"f\"/>\n  <dataSource type=\"MockDataSource\"/>\n  <document>\n    <entity name=\"a\" query=\"select * from a\" >\n      <entity name=\"b\" dataSource=\"f\" processor=\"XPathEntityProcessor\" forEach=\"/x\" dataField=\"a.xml\">\n        <field column=\"y\" xpath=\"/x/y\"/>\n      </entity>\n    </entity>\n  </document>\n</dataConfig>";
    String xml = "<x>\n <y>Hello</y>\n</x>";

    @Test
    public void simple() {
        DataImporter di = new DataImporter();
        di.loadAndInit(this.config);
        this.redirectTempProperties(di);
        TestDocBuilder.SolrWriterImpl sw = new TestDocBuilder.SolrWriterImpl();
        RequestInfo rp = new RequestInfo(null, TestFieldReader.createMap("command", "full-import"), null);
        ArrayList<Map> l = new ArrayList<Map>();
        l.add(TestFieldReader.createMap("xml", this.xml));
        MockDataSource.setIterator((String)"select * from a", l.iterator());
        di.runCmd(rp, (DIHWriter)sw);
        TestFieldReader.assertEquals((Object)sw.docs.get(0).getFieldValue("y"), (Object)"Hello");
        MockDataSource.clearCache();
    }
}

