/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.FileListEntityProcessor;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.junit.Test;

public class TestFileListEntityProcessor
extends AbstractDataImportHandlerTestCase {
    @Test
    public void testSimple() throws IOException {
        Map f;
        File tmpdir = TestFileListEntityProcessor.createTempDir().toFile();
        TestFileListEntityProcessor.createFile(tmpdir, "a.xml", "a.xml".getBytes(StandardCharsets.UTF_8), false);
        TestFileListEntityProcessor.createFile(tmpdir, "b.xml", "b.xml".getBytes(StandardCharsets.UTF_8), false);
        TestFileListEntityProcessor.createFile(tmpdir, "c.props", "c.props".getBytes(StandardCharsets.UTF_8), false);
        Map attrs = TestFileListEntityProcessor.createMap("fileName", "xml$", "baseDir", tmpdir.getAbsolutePath());
        AbstractDataImportHandlerTestCase.TestContext c = TestFileListEntityProcessor.getContext(null, new VariableResolver(), null, "FULL_DUMP", Collections.EMPTY_LIST, attrs);
        FileListEntityProcessor fileListEntityProcessor = new FileListEntityProcessor();
        fileListEntityProcessor.init((Context)c);
        ArrayList<String> fList = new ArrayList<String>();
        while ((f = fileListEntityProcessor.nextRow()) != null) {
            fList.add((String)f.get("fileAbsolutePath"));
        }
        TestFileListEntityProcessor.assertEquals((long)2L, (long)fList.size());
    }

    @Test
    public void testBiggerSmallerFiles() throws IOException {
        File tmpdir = TestFileListEntityProcessor.createTempDir().toFile();
        long minLength = Long.MAX_VALUE;
        String smallestFile = "";
        byte[] content = "abcdefgij".getBytes(StandardCharsets.UTF_8);
        TestFileListEntityProcessor.createFile(tmpdir, "a.xml", content, false);
        if (minLength > (long)content.length) {
            minLength = content.length;
            smallestFile = "a.xml";
        }
        content = "abcdefgij".getBytes(StandardCharsets.UTF_8);
        TestFileListEntityProcessor.createFile(tmpdir, "b.xml", content, false);
        if (minLength > (long)content.length) {
            minLength = content.length;
            smallestFile = "b.xml";
        }
        content = "abc".getBytes(StandardCharsets.UTF_8);
        TestFileListEntityProcessor.createFile(tmpdir, "c.props", content, false);
        if (minLength > (long)content.length) {
            minLength = content.length;
            smallestFile = "c.props";
        }
        Map attrs = TestFileListEntityProcessor.createMap("fileName", ".*", "baseDir", tmpdir.getAbsolutePath(), "biggerThan", String.valueOf(minLength));
        List<String> fList = TestFileListEntityProcessor.getFiles(null, attrs);
        TestFileListEntityProcessor.assertEquals((long)2L, (long)fList.size());
        HashSet<String> l = new HashSet<String>();
        l.add(new File(tmpdir, "a.xml").getAbsolutePath());
        l.add(new File(tmpdir, "b.xml").getAbsolutePath());
        TestFileListEntityProcessor.assertEquals(l, new HashSet<String>(fList));
        attrs = TestFileListEntityProcessor.createMap("fileName", ".*", "baseDir", tmpdir.getAbsolutePath(), "smallerThan", String.valueOf(minLength + 1L));
        fList = TestFileListEntityProcessor.getFiles(null, attrs);
        l.clear();
        l.add(new File(tmpdir, smallestFile).getAbsolutePath());
        TestFileListEntityProcessor.assertEquals(l, new HashSet<String>(fList));
        attrs = TestFileListEntityProcessor.createMap("fileName", ".*", "baseDir", tmpdir.getAbsolutePath(), "smallerThan", "${a.x}");
        VariableResolver resolver = new VariableResolver();
        resolver.addNamespace("a", TestFileListEntityProcessor.createMap("x", "4"));
        fList = TestFileListEntityProcessor.getFiles(resolver, attrs);
        TestFileListEntityProcessor.assertEquals(l, new HashSet<String>(fList));
    }

    static List<String> getFiles(VariableResolver resolver, Map attrs) {
        Map f;
        AbstractDataImportHandlerTestCase.TestContext c = TestFileListEntityProcessor.getContext(null, resolver, null, "FULL_DUMP", Collections.EMPTY_LIST, attrs);
        FileListEntityProcessor fileListEntityProcessor = new FileListEntityProcessor();
        fileListEntityProcessor.init((Context)c);
        ArrayList<String> fList = new ArrayList<String>();
        while ((f = fileListEntityProcessor.nextRow()) != null) {
            fList.add((String)f.get("fileAbsolutePath"));
        }
        return fList;
    }

    @Test
    @SuppressForbidden(reason="Needs currentTimeMillis to set last modified time")
    public void testNTOT() throws IOException {
        File tmpdir = TestFileListEntityProcessor.createTempDir().toFile();
        TestFileListEntityProcessor.createFile(tmpdir, "a.xml", "a.xml".getBytes(StandardCharsets.UTF_8), true);
        TestFileListEntityProcessor.createFile(tmpdir, "b.xml", "b.xml".getBytes(StandardCharsets.UTF_8), true);
        TestFileListEntityProcessor.createFile(tmpdir, "c.props", "c.props".getBytes(StandardCharsets.UTF_8), true);
        Map attrs = TestFileListEntityProcessor.createMap("fileName", "xml$", "baseDir", tmpdir.getAbsolutePath(), "olderThan", "'NOW'");
        List<String> fList = TestFileListEntityProcessor.getFiles(null, attrs);
        TestFileListEntityProcessor.assertEquals((long)2L, (long)fList.size());
        attrs = TestFileListEntityProcessor.createMap("fileName", ".xml$", "baseDir", tmpdir.getAbsolutePath(), "newerThan", "'NOW-2HOURS'");
        fList = TestFileListEntityProcessor.getFiles(null, attrs);
        TestFileListEntityProcessor.assertEquals((long)2L, (long)fList.size());
        attrs = TestFileListEntityProcessor.createMap("fileName", ".xml$", "baseDir", tmpdir.getAbsolutePath(), "newerThan", "${a.x}");
        VariableResolver resolver = new VariableResolver();
        String lastMod = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ROOT).format(new Date(System.currentTimeMillis() - 50000L));
        resolver.addNamespace("a", TestFileListEntityProcessor.createMap("x", lastMod));
        TestFileListEntityProcessor.createFile(tmpdir, "t.xml", "t.xml".getBytes(StandardCharsets.UTF_8), false);
        fList = TestFileListEntityProcessor.getFiles(resolver, attrs);
        TestFileListEntityProcessor.assertEquals((long)1L, (long)fList.size());
        TestFileListEntityProcessor.assertEquals((String)"File name must be t.xml", (Object)new File(tmpdir, "t.xml").getAbsolutePath(), (Object)fList.get(0));
    }

    @Test
    public void testRECURSION() throws IOException {
        File tmpdir = TestFileListEntityProcessor.createTempDir().toFile();
        File childdir = new File(tmpdir + "/child");
        childdir.mkdir();
        TestFileListEntityProcessor.createFile(childdir, "a.xml", "a.xml".getBytes(StandardCharsets.UTF_8), true);
        TestFileListEntityProcessor.createFile(childdir, "b.xml", "b.xml".getBytes(StandardCharsets.UTF_8), true);
        TestFileListEntityProcessor.createFile(childdir, "c.props", "c.props".getBytes(StandardCharsets.UTF_8), true);
        Map attrs = TestFileListEntityProcessor.createMap("fileName", "^.*\\.xml$", "baseDir", childdir.getAbsolutePath(), "recursive", "true");
        List<String> fList = TestFileListEntityProcessor.getFiles(null, attrs);
        TestFileListEntityProcessor.assertEquals((long)2L, (long)fList.size());
    }
}

