/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.File;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.BeforeClass;

public class TestFileListWithLineEntityProcessor
extends AbstractDataImportHandlerTestCase {
    @BeforeClass
    public static void beforeClass() throws Exception {
        TestFileListWithLineEntityProcessor.initCore("dataimport-solrconfig.xml", "dataimport-schema.xml");
    }

    public void test() throws Exception {
        File tmpdir = TestFileListWithLineEntityProcessor.createTempDir((String)LuceneTestCase.getTestClass().getSimpleName()).toFile();
        TestFileListWithLineEntityProcessor.createFile(tmpdir, "a.txt", "a line one\na line two\na line three".getBytes(StandardCharsets.UTF_8), false);
        TestFileListWithLineEntityProcessor.createFile(tmpdir, "b.txt", "b line one\nb line two".getBytes(StandardCharsets.UTF_8), false);
        TestFileListWithLineEntityProcessor.createFile(tmpdir, "c.txt", "c line one\nc line two\nc line three\nc line four".getBytes(StandardCharsets.UTF_8), false);
        String config = this.generateConfig(tmpdir);
        LocalSolrQueryRequest request = lrf.makeRequest(new String[]{"command", "full-import", "dataConfig", config, "clean", "true", "commit", "true", "synchronous", "true", "indent", "true"});
        h.query("/dataimport", (SolrQueryRequest)request);
        TestFileListWithLineEntityProcessor.assertQ((SolrQueryRequest)TestFileListWithLineEntityProcessor.req((String[])new String[]{"*:*"}), (String[])new String[]{"//*[@numFound='9']"});
        TestFileListWithLineEntityProcessor.assertQ((SolrQueryRequest)TestFileListWithLineEntityProcessor.req((String[])new String[]{"id:?\\ line\\ one"}), (String[])new String[]{"//*[@numFound='3']"});
        TestFileListWithLineEntityProcessor.assertQ((SolrQueryRequest)TestFileListWithLineEntityProcessor.req((String[])new String[]{"id:a\\ line*"}), (String[])new String[]{"//*[@numFound='3']"});
        TestFileListWithLineEntityProcessor.assertQ((SolrQueryRequest)TestFileListWithLineEntityProcessor.req((String[])new String[]{"id:b\\ line*"}), (String[])new String[]{"//*[@numFound='2']"});
        TestFileListWithLineEntityProcessor.assertQ((SolrQueryRequest)TestFileListWithLineEntityProcessor.req((String[])new String[]{"id:c\\ line*"}), (String[])new String[]{"//*[@numFound='4']"});
    }

    private String generateConfig(File dir) {
        return "<dataConfig> \n<dataSource type=\"FileDataSource\" encoding=\"UTF-8\" name=\"fds\"/> \n    <document> \n       <entity name=\"f\" processor=\"FileListEntityProcessor\" fileName=\".*[.]txt\" baseDir=\"" + dir.getAbsolutePath() + "\" recursive=\"false\" rootEntity=\"false\"  transformer=\"TemplateTransformer\"> \n             <entity name=\"jc\" processor=\"LineEntityProcessor\" url=\"${f.fileAbsolutePath}\" dataSource=\"fds\"  rootEntity=\"true\" transformer=\"TemplateTransformer\"> \n              <field column=\"rawLine\" name=\"id\" /> \n             </entity> \n        </entity> \n    </document> \n</dataConfig> \n";
    }
}

