/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.QueryBitSetProducer;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.MockDataSource;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SolrIndexSearcher;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHierarchicalDocBuilder
extends AbstractDataImportHandlerTestCase {
    private static final String FIELD_ID = "id";
    private int id = 0;
    private SolrQueryRequest req;
    private final String threeLevelHierarchyConfig = "<dataConfig>\n  <dataSource type='MockDataSource' />\n  <document>\n    <entity name='PARENT' query='select * from PARENT'>\n      <field column='id' />\n      <field column='desc' />\n      <field column='type_s' />\n      <entity child='true' name='CHILD' query=\"select * from CHILD where parent_id='${PARENT.id}'\">\n        <field column='id' />\n        <field column='desc' />\n        <field column='type_s' />\n          <entity child='true' name='GRANDCHILD' query=\"select * from GRANDCHILD where parent_id='${CHILD.id}'\">\n            <field column='id' />\n            <field column='desc' />\n            <field column='type_s' />\n          </entity>\n      </entity>\n    </entity>\n  </document>\n</dataConfig>";
    private final String dataConfigTemplate = "<dataConfig><dataSource type=\"MockDataSource\" />\n<document>\n {0}</document></dataConfig>";
    private final String rootEntityTemplate = "<entity name=\"{0}\" query=\"{1}\">\n{2} {3}\n</entity>\n";
    private final String childEntityTemplate = "<entity child=\"true\" name=\"{0}\" query=\"{1}\">\n {2} {3} </entity>\n";

    @BeforeClass
    public static void beforeClass() throws Exception {
        TestHierarchicalDocBuilder.initCore("dataimport-solrconfig.xml", "dataimport-schema.xml");
    }

    @Before
    public void before() {
        this.req = TestHierarchicalDocBuilder.req((String[])new String[]{"*:*"});
        MockDataSource.clearCache();
    }

    @After
    public void after() {
        this.req.close();
        MockDataSource.clearCache();
    }

    @Test
    public void testThreeLevelHierarchy() throws Exception {
        int parentsNum = 3;
        int childrenNum = 0;
        int grandChildrenNum = 0;
        String parentType = "parent";
        String childType = "child";
        String grandChildType = "grand_child";
        List<String> parentIds = this.createDataIterator("select * from PARENT", "parent", "parent", parentsNum);
        Collections.shuffle(parentIds, TestHierarchicalDocBuilder.random());
        String parentId1 = parentIds.get(0);
        String parentId2 = parentIds.get(1);
        int firstParentChildrenNum = 3;
        String select = "select * from CHILD where parent_id='" + parentId1 + "'";
        List<String> childrenIds = this.createDataIterator(select, "child", "child of first parent", firstParentChildrenNum);
        ArrayList<String> firstParentChildrenIds = new ArrayList<String>(childrenIds);
        childrenNum += childrenIds.size();
        String childId = childrenIds.get(0);
        String description = "grandchild of first parent, child of " + childId + " child";
        select = "select * from GRANDCHILD where parent_id='" + childId + "'";
        List<String> grandChildrenIds = this.createDataIterator(select, "grand_child", description, TestHierarchicalDocBuilder.atLeast((int)2));
        grandChildrenNum += grandChildrenIds.size();
        childId = childrenIds.get(1);
        description = "grandchild of first parent, child of " + childId + " child";
        select = "select * from GRANDCHILD where parent_id='" + childId + "'";
        List<String> grandChildrenIds2 = this.createDataIterator(select, "grand_child", description, TestHierarchicalDocBuilder.atLeast((int)2));
        grandChildrenIds.addAll(grandChildrenIds2);
        select = "select * from CHILD where parent_id='" + parentId2 + "'";
        childrenIds = this.createDataIterator(select, "child", "child of second parent", TestHierarchicalDocBuilder.atLeast((int)2));
        int totalDocsNum = parentsNum + (childrenNum += childrenIds.size()) + (grandChildrenNum += grandChildrenIds2.size());
        this.runFullImport("<dataConfig>\n  <dataSource type='MockDataSource' />\n  <document>\n    <entity name='PARENT' query='select * from PARENT'>\n      <field column='id' />\n      <field column='desc' />\n      <field column='type_s' />\n      <entity child='true' name='CHILD' query=\"select * from CHILD where parent_id='${PARENT.id}'\">\n        <field column='id' />\n        <field column='desc' />\n        <field column='type_s' />\n          <entity child='true' name='GRANDCHILD' query=\"select * from GRANDCHILD where parent_id='${CHILD.id}'\">\n            <field column='id' />\n            <field column='desc' />\n            <field column='type_s' />\n          </entity>\n      </entity>\n    </entity>\n  </document>\n</dataConfig>");
        TestHierarchicalDocBuilder.assertTrue((String)"Update request processor processAdd was not called", (boolean)AbstractDataImportHandlerTestCase.TestUpdateRequestProcessor.processAddCalled);
        TestHierarchicalDocBuilder.assertTrue((String)"Update request processor processCommit was not callled", (boolean)AbstractDataImportHandlerTestCase.TestUpdateRequestProcessor.processCommitCalled);
        TestHierarchicalDocBuilder.assertTrue((String)"Update request processor finish was not called", (boolean)AbstractDataImportHandlerTestCase.TestUpdateRequestProcessor.finishCalled);
        TestHierarchicalDocBuilder.assertQ((SolrQueryRequest)TestHierarchicalDocBuilder.req((String[])new String[]{"*:*"}), (String[])new String[]{"//*[@numFound='" + totalDocsNum + "']"});
        TestHierarchicalDocBuilder.assertQ((SolrQueryRequest)TestHierarchicalDocBuilder.req((String[])new String[]{"type_s:parent"}), (String[])new String[]{"//*[@numFound='" + parentsNum + "']"});
        TestHierarchicalDocBuilder.assertQ((SolrQueryRequest)TestHierarchicalDocBuilder.req((String[])new String[]{"type_s:child"}), (String[])new String[]{"//*[@numFound='" + childrenNum + "']"});
        TestHierarchicalDocBuilder.assertQ((SolrQueryRequest)TestHierarchicalDocBuilder.req((String[])new String[]{"type_s:grand_child"}), (String[])new String[]{"//*[@numFound='" + grandChildrenNum + "']"});
        String randomGrandChildId = grandChildrenIds.get(TestHierarchicalDocBuilder.random().nextInt(grandChildrenIds.size()));
        ToParentBlockJoinQuery query = this.createToParentQuery("parent", FIELD_ID, randomGrandChildId);
        this.assertSearch((Query)query, FIELD_ID, parentId1);
        String randomChildId = (String)firstParentChildrenIds.get(TestHierarchicalDocBuilder.random().nextInt(firstParentChildrenIds.size()));
        query = this.createToParentQuery("parent", FIELD_ID, randomChildId);
        this.assertSearch((Query)query, FIELD_ID, parentId1);
        randomGrandChildId = grandChildrenIds.get(TestHierarchicalDocBuilder.random().nextInt(grandChildrenIds.size()));
        ToParentBlockJoinQuery childBlockJoinQuery = this.createToParentQuery("child", FIELD_ID, randomGrandChildId);
        ToParentBlockJoinQuery blockJoinQuery = new ToParentBlockJoinQuery((Query)childBlockJoinQuery, this.createParentFilter("parent"), ScoreMode.Avg);
        this.assertSearch((Query)blockJoinQuery, FIELD_ID, parentId1);
    }

    @Test
    public void testRandomDepthHierarchy() throws Exception {
        String parentType = "parent";
        int parentsNum = 2 + TestHierarchicalDocBuilder.random().nextInt(3);
        int depth = 2 + TestHierarchicalDocBuilder.random().nextInt(3);
        ContextHolder holder = new ContextHolder();
        String config = this.createRandomizedConfig(depth, "parent", parentsNum, holder);
        this.runFullImport(config);
        TestHierarchicalDocBuilder.assertTrue((String)"Update request processor processAdd was not called", (boolean)AbstractDataImportHandlerTestCase.TestUpdateRequestProcessor.processAddCalled);
        TestHierarchicalDocBuilder.assertTrue((String)"Update request processor processCommit was not callled", (boolean)AbstractDataImportHandlerTestCase.TestUpdateRequestProcessor.processCommitCalled);
        TestHierarchicalDocBuilder.assertTrue((String)"Update request processor finish was not called", (boolean)AbstractDataImportHandlerTestCase.TestUpdateRequestProcessor.finishCalled);
        TestHierarchicalDocBuilder.assertQ((SolrQueryRequest)TestHierarchicalDocBuilder.req((String[])new String[]{"type_s:parent"}), (String[])new String[]{"//*[@numFound='" + parentsNum + "']"});
        TestHierarchicalDocBuilder.assertQ((SolrQueryRequest)TestHierarchicalDocBuilder.req((String[])new String[]{"-type_s:parent"}), (String[])new String[]{"//*[@numFound='" + (holder.counter - parentsNum) + "']"});
        Hierarchy randomHierarchy = holder.hierarchies.get(TestHierarchicalDocBuilder.random().nextInt(holder.hierarchies.size()));
        Query deepestQuery = this.createBlockJoinQuery(randomHierarchy);
        this.assertSearch(deepestQuery, FIELD_ID, (String)randomHierarchy.elementData.get(FIELD_ID));
    }

    private Query createBlockJoinQuery(Hierarchy hierarchy) {
        List<Hierarchy> elements = hierarchy.elements;
        if (elements.isEmpty()) {
            BooleanQuery.Builder childQuery = new BooleanQuery.Builder();
            childQuery.add((Query)new TermQuery(new Term(FIELD_ID, (String)hierarchy.elementData.get(FIELD_ID))), BooleanClause.Occur.MUST);
            return childQuery.build();
        }
        Query childQuery = this.createBlockJoinQuery(elements.get(TestHierarchicalDocBuilder.random().nextInt(elements.size())));
        return this.createToParentQuery(hierarchy.elementType, childQuery);
    }

    private ToParentBlockJoinQuery createToParentQuery(String parentType, String childField, String childFieldValue) {
        BooleanQuery.Builder childQuery = new BooleanQuery.Builder();
        childQuery.add((Query)new TermQuery(new Term(childField, childFieldValue)), BooleanClause.Occur.MUST);
        ToParentBlockJoinQuery result = this.createToParentQuery(parentType, (Query)childQuery.build());
        return result;
    }

    private ToParentBlockJoinQuery createToParentQuery(String parentType, Query childQuery) {
        ToParentBlockJoinQuery blockJoinQuery = new ToParentBlockJoinQuery(childQuery, this.createParentFilter(parentType), ScoreMode.Avg);
        return blockJoinQuery;
    }

    private void assertSearch(Query query, String field, String ... values) throws IOException {
        SolrIndexSearcher searcher = this.req.getSearcher();
        TopDocs result = searcher.search(query, values.length * 2);
        TestHierarchicalDocBuilder.assertEquals((long)values.length, (long)result.totalHits);
        ArrayList<String> actualValues = new ArrayList<String>();
        for (int index = 0; index < values.length; ++index) {
            Document doc = searcher.doc(result.scoreDocs[index].doc);
            actualValues.add(doc.get(field));
        }
        for (String expectedValue : values) {
            boolean removed = actualValues.remove(expectedValue);
            if (removed) continue;
            TestHierarchicalDocBuilder.fail((String)"Search result does not contain expected values");
        }
    }

    private List<String> createDataIterator(String query, String type, String description, int count) {
        ArrayList<Map> data = new ArrayList<Map>();
        ArrayList<String> ids = new ArrayList<String>(count);
        for (int index = 0; index < count; ++index) {
            String docId = this.nextId();
            ids.add(docId);
            Map doc = TestHierarchicalDocBuilder.createMap(FIELD_ID, docId, "desc", docId + " " + description, "type_s", type);
            data.add(doc);
        }
        Collections.shuffle(data, TestHierarchicalDocBuilder.random());
        MockDataSource.setIterator((String)query, data.iterator());
        return ids;
    }

    private String createRandomizedConfig(int depth, String parentType, int parentsNum, ContextHolder holder) {
        List<Hierarchy> parentData = this.createMockedIterator(parentType, "SELECT * FROM " + parentType, parentsNum, holder);
        holder.hierarchies = parentData;
        String children = this.createChildren(parentType, 0, depth, parentData, holder);
        String rootFields = this.createFieldsList(FIELD_ID, "desc", "type_s");
        String rootEntity = StrUtils.formatString((String)"<entity name=\"{0}\" query=\"{1}\">\n{2} {3}\n</entity>\n", (Object[])new Object[]{parentType, "SELECT * FROM " + parentType, rootFields, children});
        String config = StrUtils.formatString((String)"<dataConfig><dataSource type=\"MockDataSource\" />\n<document>\n {0}</document></dataConfig>", (Object[])new Object[]{rootEntity});
        return config;
    }

    private List<Hierarchy> createMockedIterator(String type, String query, int amount, ContextHolder holder) {
        ArrayList<Hierarchy> hierarchies = new ArrayList<Hierarchy>();
        ArrayList<Map> data = new ArrayList<Map>();
        for (int index = 0; index < amount; ++index) {
            ++holder.counter;
            String idStr = String.valueOf(holder.counter);
            Map element = TestHierarchicalDocBuilder.createMap(FIELD_ID, idStr, "desc", type + "_" + holder.counter, "type_s", type);
            data.add(element);
            Hierarchy hierarchy = new Hierarchy();
            hierarchy.elementType = type;
            hierarchy.elementData = element;
            hierarchies.add(hierarchy);
        }
        MockDataSource.setIterator((String)query, data.iterator());
        return hierarchies;
    }

    private List<Hierarchy> createMockedIterator(String type, List<Hierarchy> parentData, ContextHolder holder) {
        ArrayList<Hierarchy> result = new ArrayList<Hierarchy>();
        for (Hierarchy parentHierarchy : parentData) {
            Map<String, Object> data = parentHierarchy.elementData;
            String id = (String)data.get(FIELD_ID);
            String select = String.format(Locale.ROOT, "select * from %s where %s='%s'", type, type + "_parent_id", id);
            int childrenNum = 1 + TestHierarchicalDocBuilder.random().nextInt(3);
            List<Hierarchy> childHierarchies = this.createMockedIterator(type, select, childrenNum, holder);
            parentHierarchy.elements.addAll(childHierarchies);
            result.addAll(childHierarchies);
        }
        return result;
    }

    private String createChildren(String parentName, int currentLevel, int maxLevel, List<Hierarchy> parentData, ContextHolder holder) {
        if (currentLevel == maxLevel) {
            return "";
        }
        int childrenNumber = 2 + TestHierarchicalDocBuilder.random().nextInt(3);
        StringBuilder builder = new StringBuilder();
        for (int childIndex = 0; childIndex < childrenNumber; ++childIndex) {
            String childName = parentName + "Child" + childIndex;
            String fields = this.createFieldsList(FIELD_ID, "desc", "type_s");
            String select = String.format(Locale.ROOT, "select * from %s where %s='%s'", childName, childName + "_parent_id", "${" + parentName + ".id}");
            List<Hierarchy> childData = this.createMockedIterator(childName, parentData, holder);
            String subChildren = this.createChildren(childName, currentLevel + 1, maxLevel, childData, holder);
            String child = StrUtils.formatString((String)"<entity child=\"true\" name=\"{0}\" query=\"{1}\">\n {2} {3} </entity>\n", (Object[])new Object[]{childName, select, fields, subChildren});
            builder.append(child);
            builder.append('\n');
        }
        return builder.toString();
    }

    private String createFieldsList(String ... fields) {
        StringBuilder builder = new StringBuilder();
        for (String field : fields) {
            String text = String.format(Locale.ROOT, "<field column='%s' />", field);
            builder.append(text);
            builder.append('\n');
        }
        return builder.toString();
    }

    private BitSetProducer createParentFilter(String type) {
        BooleanQuery.Builder parentQuery = new BooleanQuery.Builder();
        parentQuery.add((Query)new TermQuery(new Term("type_s", type)), BooleanClause.Occur.MUST);
        return new QueryBitSetProducer((Query)parentQuery.build());
    }

    private String nextId() {
        ++this.id;
        return String.valueOf(this.id);
    }

    private static class Hierarchy {
        String elementType;
        Map<String, Object> elementData = new HashMap<String, Object>();
        List<Hierarchy> elements = new ArrayList<Hierarchy>();

        private Hierarchy() {
        }
    }

    private static class ContextHolder {
        int counter = 0;
        List<Hierarchy> hierarchies = new ArrayList<Hierarchy>();

        private ContextHolder() {
        }
    }
}

