/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.JdbcDataSource;
import org.apache.solr.handler.dataimport.MockInitialContextFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestJdbcDataSource
extends AbstractDataImportHandlerTestCase {
    private Driver driver;
    private javax.sql.DataSource dataSource;
    private Connection connection;
    private JdbcDataSource jdbcDataSource = new JdbcDataSource();
    List<Map<String, String>> fields = new ArrayList<Map<String, String>>();
    Context context = AbstractDataImportHandlerTestCase.getContext(null, null, (DataSource)this.jdbcDataSource, "FULL_DUMP", this.fields, null);
    Properties props = new Properties();
    String sysProp = System.getProperty("java.naming.factory.initial");

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("java.naming.factory.initial", MockInitialContextFactory.class.getName());
        this.driver = (Driver)Mockito.mock(Driver.class);
        this.dataSource = (javax.sql.DataSource)Mockito.mock(javax.sql.DataSource.class);
        this.connection = (Connection)Mockito.mock(Connection.class);
        this.props.clear();
    }

    @After
    public void tearDown() throws Exception {
        if (this.sysProp == null) {
            System.getProperties().remove("java.naming.factory.initial");
        } else {
            System.setProperty("java.naming.factory.initial", this.sysProp);
        }
        super.tearDown();
        Mockito.reset((Object[])new Object[]{this.driver, this.dataSource, this.connection});
    }

    @Test
    public void testRetrieveFromJndi() throws Exception {
        MockInitialContextFactory.bind("java:comp/env/jdbc/JndiDB", this.dataSource);
        this.props.put("jndiName", "java:comp/env/jdbc/JndiDB");
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn((Object)this.connection);
        Connection conn = (Connection)this.jdbcDataSource.createConnectionFactory(this.context, this.props).call();
        ((Connection)Mockito.verify((Object)this.connection)).setAutoCommit(false);
        ((javax.sql.DataSource)Mockito.verify((Object)this.dataSource)).getConnection();
        TestJdbcDataSource.assertSame((String)"connection", (Object)conn, (Object)this.connection);
    }

    @Test
    public void testRetrieveFromJndiWithCredentials() throws Exception {
        MockInitialContextFactory.bind("java:comp/env/jdbc/JndiDB", this.dataSource);
        this.props.put("jndiName", "java:comp/env/jdbc/JndiDB");
        this.props.put("user", "Fred");
        this.props.put("password", "4r3d");
        this.props.put("holdability", "HOLD_CURSORS_OVER_COMMIT");
        Mockito.when((Object)this.dataSource.getConnection("Fred", "4r3d")).thenReturn((Object)this.connection);
        Connection conn = (Connection)this.jdbcDataSource.createConnectionFactory(this.context, this.props).call();
        ((Connection)Mockito.verify((Object)this.connection)).setAutoCommit(false);
        ((Connection)Mockito.verify((Object)this.connection)).setHoldability(1);
        ((javax.sql.DataSource)Mockito.verify((Object)this.dataSource)).getConnection("Fred", "4r3d");
        TestJdbcDataSource.assertSame((String)"connection", (Object)conn, (Object)this.connection);
    }

    @Test
    public void testRetrieveFromJndiWithCredentialsEncryptedAndResolved() throws Exception {
        MockInitialContextFactory.bind("java:comp/env/jdbc/JndiDB", this.dataSource);
        String user = "Fred";
        String plainPassword = "MyPassword";
        String encryptedPassword = "U2FsdGVkX18QMjY0yfCqlfBMvAB4d3XkwY96L7gfO2o=";
        String propsNamespace = "exampleNamespace";
        this.props.put("jndiName", "java:comp/env/jdbc/JndiDB");
        this.props.put("user", "${" + propsNamespace + ".user}");
        this.props.put("encryptKeyFile", "${" + propsNamespace + ".encryptKeyFile}");
        this.props.put("password", "${" + propsNamespace + ".password}");
        Mockito.when((Object)this.dataSource.getConnection(user, plainPassword)).thenReturn((Object)this.connection);
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("user", user);
        values.put("encryptKeyFile", this.createEncryptionKeyFile());
        values.put("password", encryptedPassword);
        this.context.getVariableResolver().addNamespace(propsNamespace, values);
        this.jdbcDataSource.init(this.context, this.props);
        Connection conn = this.jdbcDataSource.getConnection();
        ((Connection)Mockito.verify((Object)this.connection)).setAutoCommit(false);
        ((javax.sql.DataSource)Mockito.verify((Object)this.dataSource)).getConnection(user, plainPassword);
        TestJdbcDataSource.assertSame((String)"connection", (Object)conn, (Object)this.connection);
    }

    @Test
    public void testRetrieveFromJndiWithCredentialsWithEncryptedAndResolvedPwd() throws Exception {
        MockInitialContextFactory.bind("java:comp/env/jdbc/JndiDB", this.dataSource);
        Properties properties = new Properties();
        properties.put("jndiName", "java:comp/env/jdbc/JndiDB");
        properties.put("user", "Fred");
        properties.put("encryptKeyFile", "${foo.bar}");
        properties.put("password", "U2FsdGVkX18QMjY0yfCqlfBMvAB4d3XkwY96L7gfO2o=");
        Mockito.when((Object)this.dataSource.getConnection("Fred", "MyPassword")).thenReturn((Object)this.connection);
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("bar", this.createEncryptionKeyFile());
        this.context.getVariableResolver().addNamespace("foo", values);
        this.jdbcDataSource.init(this.context, properties);
        this.jdbcDataSource.getConnection();
        ((Connection)Mockito.verify((Object)this.connection)).setAutoCommit(false);
        ((javax.sql.DataSource)Mockito.verify((Object)this.dataSource)).getConnection("Fred", "MyPassword");
    }

    @Test
    public void testRetrieveFromJndiFailureNotHidden() throws Exception {
        MockInitialContextFactory.bind("java:comp/env/jdbc/JndiDB", this.dataSource);
        this.props.put("jndiName", "java:comp/env/jdbc/JndiDB");
        SQLException sqlException = new SQLException("fake");
        Mockito.when((Object)this.dataSource.getConnection()).thenThrow(new Throwable[]{sqlException});
        try {
            this.jdbcDataSource.createConnectionFactory(this.context, this.props).call();
        }
        catch (SQLException ex) {
            TestJdbcDataSource.assertSame((Object)sqlException, (Object)ex);
        }
        ((javax.sql.DataSource)Mockito.verify((Object)this.dataSource)).getConnection();
    }

    @Test
    public void testClosesConnectionWhenExceptionThrownOnSetAutocommit() throws Exception {
        MockInitialContextFactory.bind("java:comp/env/jdbc/JndiDB", this.dataSource);
        this.props.put("jndiName", "java:comp/env/jdbc/JndiDB");
        SQLException sqlException = new SQLException("fake");
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn((Object)this.connection);
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{sqlException}).when((Object)this.connection)).setAutoCommit(false);
        try {
            this.jdbcDataSource.createConnectionFactory(this.context, this.props).call();
        }
        catch (DataImportHandlerException ex) {
            TestJdbcDataSource.assertSame((Object)sqlException, (Object)ex.getCause());
        }
        ((javax.sql.DataSource)Mockito.verify((Object)this.dataSource)).getConnection();
        ((Connection)Mockito.verify((Object)this.connection)).setAutoCommit(false);
        ((Connection)Mockito.verify((Object)this.connection)).close();
    }

    @Test
    public void testClosesStatementWhenExceptionThrownOnExecuteQuery() throws Exception {
        MockInitialContextFactory.bind("java:comp/env/jdbc/JndiDB", this.dataSource);
        this.props.put("jndiName", "java:comp/env/jdbc/JndiDB");
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn((Object)this.connection);
        this.jdbcDataSource.init(this.context, this.props);
        SQLException sqlException = new SQLException("fake");
        Statement statement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)this.connection.createStatement(1003, 1007)).thenReturn((Object)statement);
        Mockito.when((Object)statement.execute("query")).thenThrow(new Throwable[]{sqlException});
        try {
            this.jdbcDataSource.getData("query");
            TestJdbcDataSource.fail((String)"exception expected");
        }
        catch (DataImportHandlerException ex) {
            TestJdbcDataSource.assertSame((Object)sqlException, (Object)ex.getCause());
        }
        ((javax.sql.DataSource)Mockito.verify((Object)this.dataSource)).getConnection();
        ((Connection)Mockito.verify((Object)this.connection)).setAutoCommit(false);
        ((Connection)Mockito.verify((Object)this.connection)).createStatement(1003, 1007);
        ((Statement)Mockito.verify((Object)statement)).setFetchSize(500);
        ((Statement)Mockito.verify((Object)statement)).setMaxRows(0);
        ((Statement)Mockito.verify((Object)statement)).execute("query");
        ((Statement)Mockito.verify((Object)statement)).close();
    }

    @Test
    public void testClosesStatementWhenResultSetNull() throws Exception {
        MockInitialContextFactory.bind("java:comp/env/jdbc/JndiDB", this.dataSource);
        this.props.put("jndiName", "java:comp/env/jdbc/JndiDB");
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn((Object)this.connection);
        this.jdbcDataSource.init(this.context, this.props);
        Statement statement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)this.connection.createStatement(1003, 1007)).thenReturn((Object)statement);
        Mockito.when((Object)statement.execute("query")).thenReturn((Object)false);
        Mockito.when((Object)statement.getUpdateCount()).thenReturn((Object)-1);
        this.jdbcDataSource.getData("query");
        ((javax.sql.DataSource)Mockito.verify((Object)this.dataSource)).getConnection();
        ((Connection)Mockito.verify((Object)this.connection)).setAutoCommit(false);
        ((Connection)Mockito.verify((Object)this.connection)).createStatement(1003, 1007);
        ((Statement)Mockito.verify((Object)statement)).setFetchSize(500);
        ((Statement)Mockito.verify((Object)statement)).setMaxRows(0);
        ((Statement)Mockito.verify((Object)statement)).execute("query");
        ((Statement)Mockito.verify((Object)statement)).getUpdateCount();
        ((Statement)Mockito.verify((Object)statement)).close();
    }

    @Test
    public void testClosesStatementWhenHasNextCalledAndResultSetNull() throws Exception {
        MockInitialContextFactory.bind("java:comp/env/jdbc/JndiDB", this.dataSource);
        this.props.put("jndiName", "java:comp/env/jdbc/JndiDB");
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn((Object)this.connection);
        this.jdbcDataSource.init(this.context, this.props);
        Statement statement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)this.connection.createStatement(1003, 1007)).thenReturn((Object)statement);
        Mockito.when((Object)statement.execute("query")).thenReturn((Object)true);
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)statement.getResultSet()).thenReturn((Object)resultSet);
        ResultSetMetaData metaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)resultSet.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getColumnCount()).thenReturn((Object)0);
        Iterator data = this.jdbcDataSource.getData("query");
        JdbcDataSource.ResultSetIterator resultSetIterator = (JdbcDataSource.ResultSetIterator)data.getClass().getDeclaredField("this$1").get(data);
        resultSetIterator.setResultSet(null);
        data.hasNext();
        ((javax.sql.DataSource)Mockito.verify((Object)this.dataSource)).getConnection();
        ((Connection)Mockito.verify((Object)this.connection)).setAutoCommit(false);
        ((Connection)Mockito.verify((Object)this.connection)).createStatement(1003, 1007);
        ((Statement)Mockito.verify((Object)statement)).setFetchSize(500);
        ((Statement)Mockito.verify((Object)statement)).setMaxRows(0);
        ((Statement)Mockito.verify((Object)statement)).execute("query");
        ((Statement)Mockito.verify((Object)statement)).getResultSet();
        ((Statement)Mockito.verify((Object)statement)).close();
        ((ResultSet)Mockito.verify((Object)resultSet)).getMetaData();
        ((ResultSetMetaData)Mockito.verify((Object)metaData)).getColumnCount();
    }

    @Test
    public void testClosesResultSetAndStatementWhenDataSourceIsClosed() throws Exception {
        MockInitialContextFactory.bind("java:comp/env/jdbc/JndiDB", this.dataSource);
        this.props.put("jndiName", "java:comp/env/jdbc/JndiDB");
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn((Object)this.connection);
        this.jdbcDataSource.init(this.context, this.props);
        Statement statement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)this.connection.createStatement(1003, 1007)).thenReturn((Object)statement);
        Mockito.when((Object)statement.execute("query")).thenReturn((Object)true);
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)statement.getResultSet()).thenReturn((Object)resultSet);
        ResultSetMetaData metaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)resultSet.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getColumnCount()).thenReturn((Object)0);
        this.jdbcDataSource.getData("query");
        this.jdbcDataSource.close();
        ((javax.sql.DataSource)Mockito.verify((Object)this.dataSource)).getConnection();
        ((Connection)Mockito.verify((Object)this.connection)).setAutoCommit(false);
        ((Connection)Mockito.verify((Object)this.connection)).createStatement(1003, 1007);
        ((Statement)Mockito.verify((Object)statement)).setFetchSize(500);
        ((Statement)Mockito.verify((Object)statement)).setMaxRows(0);
        ((Statement)Mockito.verify((Object)statement)).execute("query");
        ((Statement)Mockito.verify((Object)statement)).getResultSet();
        ((ResultSet)Mockito.verify((Object)resultSet)).getMetaData();
        ((ResultSetMetaData)Mockito.verify((Object)metaData)).getColumnCount();
        ((ResultSet)Mockito.verify((Object)resultSet)).close();
        ((Statement)Mockito.verify((Object)statement)).close();
        ((Connection)Mockito.verify((Object)this.connection)).commit();
        ((Connection)Mockito.verify((Object)this.connection)).close();
    }

    @Test
    public void testClosesCurrentResultSetIteratorWhenNewOneIsCreated() throws Exception {
        MockInitialContextFactory.bind("java:comp/env/jdbc/JndiDB", this.dataSource);
        this.props.put("jndiName", "java:comp/env/jdbc/JndiDB");
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn((Object)this.connection);
        this.jdbcDataSource.init(this.context, this.props);
        Statement statement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)this.connection.createStatement(1003, 1007)).thenReturn((Object)statement);
        Mockito.when((Object)statement.execute("query")).thenReturn((Object)true);
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)statement.getResultSet()).thenReturn((Object)resultSet);
        ResultSetMetaData metaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)resultSet.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getColumnCount()).thenReturn((Object)0);
        Mockito.when((Object)statement.execute("other query")).thenReturn((Object)false);
        Mockito.when((Object)statement.getUpdateCount()).thenReturn((Object)-1);
        this.jdbcDataSource.getData("query");
        this.jdbcDataSource.getData("other query");
        ((javax.sql.DataSource)Mockito.verify((Object)this.dataSource)).getConnection();
        ((Connection)Mockito.verify((Object)this.connection)).setAutoCommit(false);
        ((Connection)Mockito.verify((Object)this.connection, (VerificationMode)Mockito.times((int)2))).createStatement(1003, 1007);
        ((Statement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)2))).setFetchSize(500);
        ((Statement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)2))).setMaxRows(0);
        ((Statement)Mockito.verify((Object)statement)).execute("query");
        ((Statement)Mockito.verify((Object)statement)).getResultSet();
        ((ResultSet)Mockito.verify((Object)resultSet)).getMetaData();
        ((ResultSetMetaData)Mockito.verify((Object)metaData)).getColumnCount();
        ((ResultSet)Mockito.verify((Object)resultSet)).close();
        ((Statement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)2))).close();
        ((Statement)Mockito.verify((Object)statement)).execute("other query");
    }

    @Test
    public void testMultipleResultsSets_UpdateCountUpdateCountResultSet() throws Exception {
        MockInitialContextFactory.bind("java:comp/env/jdbc/JndiDB", this.dataSource);
        this.props.put("jndiName", "java:comp/env/jdbc/JndiDB");
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn((Object)this.connection);
        this.jdbcDataSource.init(this.context, this.props);
        Statement statement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)this.connection.createStatement(1003, 1007)).thenReturn((Object)statement);
        Mockito.when((Object)statement.execute("query")).thenReturn((Object)false);
        Mockito.when((Object)statement.getUpdateCount()).thenReturn((Object)1);
        Mockito.when((Object)statement.getMoreResults()).thenReturn((Object)false).thenReturn((Object)true);
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)statement.getResultSet()).thenReturn((Object)resultSet);
        ResultSetMetaData metaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)resultSet.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getColumnCount()).thenReturn((Object)0);
        JdbcDataSource jdbcDataSource = this.jdbcDataSource;
        Objects.requireNonNull(jdbcDataSource);
        JdbcDataSource.ResultSetIterator resultSetIterator = new JdbcDataSource.ResultSetIterator(jdbcDataSource, "query");
        TestJdbcDataSource.assertSame((Object)resultSet, (Object)resultSetIterator.getResultSet());
        ((Connection)Mockito.verify((Object)this.connection)).setAutoCommit(false);
        ((Connection)Mockito.verify((Object)this.connection)).createStatement(1003, 1007);
        ((Statement)Mockito.verify((Object)statement)).setFetchSize(500);
        ((Statement)Mockito.verify((Object)statement)).setMaxRows(0);
        ((Statement)Mockito.verify((Object)statement)).execute("query");
        ((Statement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)2))).getUpdateCount();
        ((Statement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)2))).getMoreResults();
    }

    @Test
    public void testMultipleResultsSets_ResultSetResultSet() throws Exception {
        MockInitialContextFactory.bind("java:comp/env/jdbc/JndiDB", this.dataSource);
        this.props.put("jndiName", "java:comp/env/jdbc/JndiDB");
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn((Object)this.connection);
        this.jdbcDataSource.init(this.context, this.props);
        this.connection.setAutoCommit(false);
        Statement statement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)this.connection.createStatement(1003, 1007)).thenReturn((Object)statement);
        Mockito.when((Object)statement.execute("query")).thenReturn((Object)true);
        ResultSet resultSet1 = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSet resultSet2 = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)statement.getResultSet()).thenReturn((Object)resultSet1).thenReturn((Object)resultSet2).thenReturn(null);
        Mockito.when((Object)statement.getMoreResults()).thenReturn((Object)true).thenReturn((Object)false);
        ResultSetMetaData metaData1 = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)resultSet1.getMetaData()).thenReturn((Object)metaData1);
        Mockito.when((Object)metaData1.getColumnCount()).thenReturn((Object)0);
        Mockito.when((Object)resultSet1.next()).thenReturn((Object)false);
        ResultSetMetaData metaData2 = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)resultSet2.getMetaData()).thenReturn((Object)metaData2);
        Mockito.when((Object)metaData2.getColumnCount()).thenReturn((Object)0);
        Mockito.when((Object)resultSet2.next()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)statement.getUpdateCount()).thenReturn((Object)-1);
        JdbcDataSource jdbcDataSource = this.jdbcDataSource;
        Objects.requireNonNull(jdbcDataSource);
        JdbcDataSource.ResultSetIterator resultSetIterator = new JdbcDataSource.ResultSetIterator(jdbcDataSource, "query");
        TestJdbcDataSource.assertSame((Object)resultSet1, (Object)resultSetIterator.getResultSet());
        TestJdbcDataSource.assertTrue((boolean)resultSetIterator.hasnext());
        TestJdbcDataSource.assertSame((Object)resultSet2, (Object)resultSetIterator.getResultSet());
        TestJdbcDataSource.assertFalse((boolean)resultSetIterator.hasnext());
        ((javax.sql.DataSource)Mockito.verify((Object)this.dataSource)).getConnection();
        ((Connection)Mockito.verify((Object)this.connection, (VerificationMode)Mockito.times((int)2))).setAutoCommit(false);
        ((Connection)Mockito.verify((Object)this.connection)).createStatement(1003, 1007);
        ((Statement)Mockito.verify((Object)statement)).setFetchSize(500);
        ((Statement)Mockito.verify((Object)statement)).setMaxRows(0);
        ((Statement)Mockito.verify((Object)statement)).execute("query");
        ((Statement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)2))).getResultSet();
        ((ResultSet)Mockito.verify((Object)resultSet1)).getMetaData();
        ((ResultSetMetaData)Mockito.verify((Object)metaData1)).getColumnCount();
        ((ResultSet)Mockito.verify((Object)resultSet1)).next();
        ((ResultSet)Mockito.verify((Object)resultSet1)).close();
        ((ResultSet)Mockito.verify((Object)resultSet2)).getMetaData();
        ((ResultSetMetaData)Mockito.verify((Object)metaData2)).getColumnCount();
        ((ResultSet)Mockito.verify((Object)resultSet2, (VerificationMode)Mockito.times((int)2))).next();
        ((ResultSet)Mockito.verify((Object)resultSet2)).close();
        ((Statement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)2))).getMoreResults();
        ((Statement)Mockito.verify((Object)statement)).getUpdateCount();
        ((Statement)Mockito.verify((Object)statement)).close();
    }

    @Test
    public void testRetrieveFromDriverManager() throws Exception {
        MockDriver mockDriver = new MockDriver(this.connection);
        DriverManager.registerDriver(mockDriver);
        try {
            this.props.put("driver", MockDriver.class.getName());
            this.props.put("url", "jdbc:fakedb");
            this.props.put("holdability", "HOLD_CURSORS_OVER_COMMIT");
            Connection conn = (Connection)this.jdbcDataSource.createConnectionFactory(this.context, this.props).call();
            ((Connection)Mockito.verify((Object)this.connection)).setAutoCommit(false);
            ((Connection)Mockito.verify((Object)this.connection)).setHoldability(1);
            TestJdbcDataSource.assertSame((String)"connection", (Object)conn, (Object)this.connection);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            DriverManager.deregisterDriver(mockDriver);
        }
    }

    @Test
    public void testEmptyResultSet() throws Exception {
        MockInitialContextFactory.bind("java:comp/env/jdbc/JndiDB", this.dataSource);
        this.props.put("jndiName", "java:comp/env/jdbc/JndiDB");
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn((Object)this.connection);
        this.jdbcDataSource.init(this.context, this.props);
        Statement statement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)this.connection.createStatement(1003, 1007)).thenReturn((Object)statement);
        Mockito.when((Object)statement.execute("query")).thenReturn((Object)true);
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)statement.getResultSet()).thenReturn((Object)resultSet);
        ResultSetMetaData metaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)resultSet.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getColumnCount()).thenReturn((Object)0);
        Mockito.when((Object)resultSet.next()).thenReturn((Object)false);
        Mockito.when((Object)statement.getMoreResults()).thenReturn((Object)false);
        Mockito.when((Object)statement.getUpdateCount()).thenReturn((Object)-1);
        Iterator resultSetIterator = this.jdbcDataSource.getData("query");
        resultSetIterator.hasNext();
        resultSetIterator.hasNext();
        ((Connection)Mockito.verify((Object)this.connection)).setAutoCommit(false);
        ((Connection)Mockito.verify((Object)this.connection)).createStatement(1003, 1007);
        ((Statement)Mockito.verify((Object)statement)).setFetchSize(500);
        ((Statement)Mockito.verify((Object)statement)).setMaxRows(0);
        ((Statement)Mockito.verify((Object)statement)).execute("query");
        ((Statement)Mockito.verify((Object)statement)).getResultSet();
        ((ResultSet)Mockito.verify((Object)resultSet)).getMetaData();
        ((ResultSetMetaData)Mockito.verify((Object)metaData)).getColumnCount();
        ((ResultSet)Mockito.verify((Object)resultSet)).next();
        ((ResultSet)Mockito.verify((Object)resultSet)).close();
        ((Statement)Mockito.verify((Object)statement)).getMoreResults();
        ((Statement)Mockito.verify((Object)statement)).getUpdateCount();
        ((Statement)Mockito.verify((Object)statement)).close();
    }

    @Test
    @Ignore(value="Needs a Mock database server to work")
    public void testBasic() throws Exception {
        JdbcDataSource dataSource = new JdbcDataSource();
        Properties p = new Properties();
        p.put("driver", "com.mysql.jdbc.Driver");
        p.put("url", "jdbc:mysql://127.0.0.1/autos");
        p.put("user", "root");
        p.put("password", "");
        ArrayList<Map<String, String>> flds = new ArrayList<Map<String, String>>();
        HashMap<String, String> f = new HashMap<String, String>();
        f.put("column", "trim_id");
        f.put("type", "long");
        flds.add(f);
        f = new HashMap();
        f.put("column", "msrp");
        f.put("type", "float");
        flds.add(f);
        AbstractDataImportHandlerTestCase.TestContext c = TestJdbcDataSource.getContext(null, null, (DataSource)dataSource, "FULL_DUMP", flds, null);
        dataSource.init((Context)c, p);
        Iterator i = dataSource.getData("select make,model,year,msrp,trim_id from atrimlisting where make='Acura'");
        int count = 0;
        Object msrp = null;
        Object trim_id = null;
        while (i.hasNext()) {
            Map map = (Map)i.next();
            msrp = map.get("msrp");
            trim_id = map.get("trim_id");
            ++count;
        }
        TestJdbcDataSource.assertEquals((long)5L, (long)count);
        TestJdbcDataSource.assertEquals(Float.class, msrp.getClass());
        TestJdbcDataSource.assertEquals(Long.class, trim_id.getClass());
    }

    private String createEncryptionKeyFile() throws IOException {
        File tmpdir = TestJdbcDataSource.createTempDir().toFile();
        byte[] content = "secret".getBytes(StandardCharsets.UTF_8);
        TestJdbcDataSource.createFile(tmpdir, "enckeyfile.txt", content, false);
        return new File(tmpdir, "enckeyfile.txt").getAbsolutePath();
    }

    public static final class MockDriver
    implements Driver {
        public static final String MY_JDBC_URL = "jdbc:fakedb";
        private final Connection conn;

        public MockDriver() throws SQLException {
            throw new AssertionError((Object)"The driver should never be directly instantiated by DIH's JdbcDataSource");
        }

        MockDriver(Connection conn) throws SQLException {
            this.conn = conn;
        }

        @Override
        public boolean acceptsURL(String url) throws SQLException {
            return MY_JDBC_URL.equals(url);
        }

        @Override
        public Connection connect(String url, Properties info) throws SQLException {
            return this.acceptsURL(url) ? this.conn : null;
        }

        @Override
        public int getMajorVersion() {
            return 1;
        }

        @Override
        public int getMinorVersion() {
            return 0;
        }

        @Override
        @SuppressForbidden(reason="Required by JDBC")
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
            return new DriverPropertyInfo[0];
        }

        @Override
        public boolean jdbcCompliant() {
            return false;
        }
    }
}

