/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import com.carrotsearch.randomizedtesting.annotations.ThreadLeakAction;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakLingering;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakScope;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakZombies;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.JdbcDataSource;

@ThreadLeakAction(value={ThreadLeakAction.Action.WARN})
@ThreadLeakLingering(linger=0)
@ThreadLeakZombies(value=ThreadLeakZombies.Consequence.CONTINUE)
@ThreadLeakScope(value=ThreadLeakScope.Scope.NONE)
public class TestJdbcDataSourceConvertType
extends AbstractDataImportHandlerTestCase {
    public void testConvertType() throws Throwable {
        Locale loc = Locale.getDefault();
        TestJdbcDataSourceConvertType.assumeFalse((String)"Derby is not happy with locale sr-Latn-*", (Objects.equals(new Locale("sr").getLanguage(), loc.getLanguage()) && Objects.equals("Latn", loc.getScript()) ? 1 : 0) != 0);
        this.convertTypeTest("false", String.class);
        this.convertTypeTest("true", Long.class);
    }

    private void convertTypeTest(String convertType, Class resultClass) throws Throwable {
        JdbcDataSource dataSource = new JdbcDataSource();
        Properties p = new Properties();
        p.put("driver", "org.apache.derby.jdbc.EmbeddedDriver");
        p.put("url", "jdbc:derby:memory:tempDB;create=true;territory=en_US");
        p.put("convertType", convertType);
        ArrayList<Map<String, String>> flds = new ArrayList<Map<String, String>>();
        HashMap<String, String> f = new HashMap<String, String>();
        f.put("column", "some_i");
        f.put("type", "long");
        flds.add(f);
        AbstractDataImportHandlerTestCase.TestContext c = TestJdbcDataSourceConvertType.getContext(null, null, (DataSource)dataSource, "FULL_DUMP", flds, null);
        dataSource.init((Context)c, p);
        Iterator i = dataSource.getData("select 1 as id, CAST(9999 AS DECIMAL) as \"some_i\" from sysibm.sysdummy1");
        TestJdbcDataSourceConvertType.assertTrue((boolean)i.hasNext());
        Map map = (Map)i.next();
        Object val = map.get("some_i");
        TestJdbcDataSourceConvertType.assertEquals((Object)resultClass, val.getClass());
        dataSource.close();
    }
}

