/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.LineEntityProcessor;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.junit.Test;

public class TestLineEntityProcessor
extends AbstractDataImportHandlerTestCase {
    private static final String filecontents = "\n# this is what the output from 'find . -ls; looks like, athough the format\n# of the time stamp varies depending on the age of the file and your LANG \n# env setting\n412577   0 drwxr-xr-x  6 user group    204 1 Apr 10:53 /Volumes/spare/ts\n412582   0 drwxr-xr-x 13 user group    442 1 Apr 10:18 /Volumes/spare/ts/config\n412583  24 -rwxr-xr-x  1 user group   8318 1 Apr 11:10 /Volumes/spare/ts/config/dc.xsd\n412584  32 -rwxr-xr-x  1 user group  12847 1 Apr 11:10 /Volumes/spare/ts/config/dcterms.xsd\n412585   8 -rwxr-xr-x  1 user group   3156 1 Apr 11:10 /Volumes/spare/ts/config/s-deliver.css\n412586 192 -rwxr-xr-x  1 user group  97764 1 Apr 11:10 /Volumes/spare/ts/config/s-deliver.xsl\n412587 224 -rwxr-xr-x  1 user group 112700 1 Apr 11:10 /Volumes/spare/ts/config/sml-delivery-2.1.xsd\n412588 208 -rwxr-xr-x  1 user group 103419 1 Apr 11:10 /Volumes/spare/ts/config/sml-delivery-norm-2.0.dtd\n412589 248 -rwxr-xr-x  1 user group 125296 1 Apr 11:10 /Volumes/spare/ts/config/sml-delivery-norm-2.1.dtd\n412590  72 -rwxr-xr-x  1 user group  36256 1 Apr 11:10 /Volumes/spare/ts/config/jm.xsd\n412591   8 -rwxr-xr-x  1 user group    990 1 Apr 11:10 /Volumes/spare/ts/config/video.gif\n412592   8 -rwxr-xr-x  1 user group   1498 1 Apr 11:10 /Volumes/spare/ts/config/xlink.xsd\n412593   8 -rwxr-xr-x  1 user group   1155 1 Apr 11:10 /Volumes/spare/ts/config/xml.xsd\n412594   0 drwxr-xr-x  4 user group    136 1 Apr 10:18 /Volumes/spare/ts/acm19\n412621   0 drwxr-xr-x 57 user group   1938 1 Apr 10:18 /Volumes/spare/ts/acm19/data\n412622  24 -rwxr-xr-x  1 user group   8894 1 Apr 11:09 /Volumes/spare/ts/acm19/data/00000510.xml\n412623  32 -rwxr-xr-x  1 user group  14124 1 Apr 11:09 /Volumes/spare/ts/acm19/data/00000603.xml\n412624  24 -rwxr-xr-x  1 user group  11976 1 Apr 11:09 /Volumes/spare/ts/acm19/data/00001292.xml\n# tacked on an extra line to cause a file to be deleted.\nDELETE /Volumes/spare/ts/acm19/data/00001292old.xml\n";

    @Test
    public void testSimple() throws IOException {
        Map f;
        Map attrs = TestLineEntityProcessor.createMap("url", "dummy.lis", "acceptLineRegex", null, "skipLineRegex", null);
        AbstractDataImportHandlerTestCase.TestContext c = TestLineEntityProcessor.getContext(null, new VariableResolver(), this.getDataSource(filecontents), "FULL_DUMP", Collections.EMPTY_LIST, attrs);
        LineEntityProcessor ep = new LineEntityProcessor();
        ep.init((Context)c);
        if (VERBOSE) {
            System.out.print("\n");
        }
        ArrayList<String> fList = new ArrayList<String>();
        while ((f = ep.nextRow()) != null) {
            fList.add((String)f.get("rawLine"));
            if (!VERBOSE) continue;
            System.out.print("     rawLine='" + f.get("rawLine") + "'\n");
        }
        TestLineEntityProcessor.assertEquals((long)24L, (long)fList.size());
    }

    @Test
    public void testOnly_xml_files() throws IOException {
        Map f;
        Map attrs = TestLineEntityProcessor.createMap("url", "dummy.lis", "acceptLineRegex", "xml", "skipLineRegex", null);
        AbstractDataImportHandlerTestCase.TestContext c = TestLineEntityProcessor.getContext(null, new VariableResolver(), this.getDataSource(filecontents), "FULL_DUMP", Collections.EMPTY_LIST, attrs);
        LineEntityProcessor ep = new LineEntityProcessor();
        ep.init((Context)c);
        ArrayList<String> fList = new ArrayList<String>();
        while ((f = ep.nextRow()) != null) {
            fList.add((String)f.get("rawLine"));
        }
        TestLineEntityProcessor.assertEquals((long)5L, (long)fList.size());
    }

    @Test
    public void testOnly_xml_files_no_xsd() throws IOException {
        Map f;
        Map attrs = TestLineEntityProcessor.createMap("url", "dummy.lis", "acceptLineRegex", "\\.xml", "skipLineRegex", "\\.xsd");
        AbstractDataImportHandlerTestCase.TestContext c = TestLineEntityProcessor.getContext(null, new VariableResolver(), this.getDataSource(filecontents), "FULL_DUMP", Collections.EMPTY_LIST, attrs);
        LineEntityProcessor ep = new LineEntityProcessor();
        ep.init((Context)c);
        ArrayList<String> fList = new ArrayList<String>();
        while ((f = ep.nextRow()) != null) {
            fList.add((String)f.get("rawLine"));
        }
        TestLineEntityProcessor.assertEquals((long)4L, (long)fList.size());
    }

    @Test
    public void testNo_xsd_files() throws IOException {
        Map f;
        Map attrs = TestLineEntityProcessor.createMap("url", "dummy.lis", "skipLineRegex", "\\.xsd");
        AbstractDataImportHandlerTestCase.TestContext c = TestLineEntityProcessor.getContext(null, new VariableResolver(), this.getDataSource(filecontents), "FULL_DUMP", Collections.EMPTY_LIST, attrs);
        LineEntityProcessor ep = new LineEntityProcessor();
        ep.init((Context)c);
        ArrayList<String> fList = new ArrayList<String>();
        while ((f = ep.nextRow()) != null) {
            fList.add((String)f.get("rawLine"));
        }
        TestLineEntityProcessor.assertEquals((long)18L, (long)fList.size());
    }

    public static Map<String, String> createField(String col, String type, String srcCol, String re, String rw, String gn) {
        HashMap<String, String> vals = new HashMap<String, String>();
        vals.put("column", col);
        vals.put("type", type);
        vals.put("sourceColName", srcCol);
        vals.put("regex", re);
        vals.put("replaceWith", rw);
        vals.put("groupNames", gn);
        return vals;
    }

    private DataSource<Reader> getDataSource(final String xml) {
        return new DataSource<Reader>(){

            public void init(Context context, Properties initProps) {
            }

            public void close() {
            }

            public Reader getData(String query) {
                return new StringReader(xml);
            }
        };
    }
}

