/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.lang.invoke.MethodHandles;
import org.apache.solr.handler.dataimport.AbstractDIHJdbcTestCase;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNestedChildren
extends AbstractDIHJdbcTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void test() throws Exception {
        h.query("/dataimport", (SolrQueryRequest)this.generateRequest());
        TestNestedChildren.assertQ((SolrQueryRequest)TestNestedChildren.req((String[])new String[]{"*:*"}), (String[])new String[]{"//*[@numFound='1']"});
        TestNestedChildren.assertQ((SolrQueryRequest)TestNestedChildren.req((String[])new String[]{"third_s:CHICKEN"}), (String[])new String[]{"//*[@numFound='1']"});
    }

    @Override
    protected String generateConfig() {
        StringBuilder sb = new StringBuilder();
        sb.append("<dataConfig> \n");
        sb.append("<dataSource name=\"derby\" driver=\"org.apache.derby.jdbc.EmbeddedDriver\" url=\"jdbc:derby:memory:derbyDB;territory=en_US\" /> \n");
        sb.append("<document name=\"TestSimplePropertiesWriter\"> \n");
        sb.append("<entity name=\"FIRST\" processor=\"SqlEntityProcessor\" dataSource=\"derby\" ");
        sb.append(" query=\"select 1 as id, 'PORK' as FIRST_S from sysibm.sysdummy1 \" >\n");
        sb.append("  <field column=\"FIRST_S\" name=\"first_s\" /> \n");
        sb.append("  <entity name=\"SECOND\" processor=\"SqlEntityProcessor\" dataSource=\"derby\" ");
        sb.append("   query=\"select 1 as id, 2 as SECOND_ID, 'BEEF' as SECOND_S from sysibm.sysdummy1 WHERE 1=${FIRST.ID}\" >\n");
        sb.append("   <field column=\"SECOND_S\" name=\"second_s\" /> \n");
        sb.append("   <entity name=\"THIRD\" processor=\"SqlEntityProcessor\" dataSource=\"derby\" ");
        sb.append("    query=\"select 1 as id, 'CHICKEN' as THIRD_S from sysibm.sysdummy1 WHERE 2=${SECOND.SECOND_ID}\" >\n");
        sb.append("    <field column=\"THIRD_S\" name=\"third_s\" /> \n");
        sb.append("   </entity>\n");
        sb.append("  </entity>\n");
        sb.append("</entity>\n");
        sb.append("</document> \n");
        sb.append("</dataConfig> \n");
        String config = sb.toString();
        log.debug(config);
        return config;
    }

    @Override
    protected AbstractDIHJdbcTestCase.Database setAllowedDatabases() {
        return AbstractDIHJdbcTestCase.Database.DERBY;
    }
}

