/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.MockDataSource;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestNonWritablePersistFile
extends AbstractDataImportHandlerTestCase {
    private static final String FULLIMPORT_QUERY = "select * from x";
    private static final String DELTA_QUERY = "select id from x where last_modified > NOW";
    private static final String DELETED_PK_QUERY = "select id from x where last_modified > NOW AND deleted='true'";
    private static final String dataConfig_delta = "<dataConfig>  <dataSource  type=\"MockDataSource\"/>\n  <document>\n    <entity name=\"x\" transformer=\"TemplateTransformer\"            query=\"select * from x\"            deletedPkQuery=\"select id from x where last_modified > NOW AND deleted='true'\"            deltaImportQuery=\"select * from x where id='${dih.delta.id}'\"            deltaQuery=\"select id from x where last_modified > NOW\">\n      <field column=\"id\" name=\"id\"/>\n      <entity name=\"y\" query=\"select * from y where y.A='${x.id}'\">\n        <field column=\"desc\" />\n      </entity>\n    </entity>\n  </document>\n</dataConfig>\n";
    private static String tmpSolrHome;

    @BeforeClass
    public static void createTempSolrHomeAndCore() throws Exception {
        tmpSolrHome = TestNonWritablePersistFile.createTempDir().toFile().getAbsolutePath();
        FileUtils.copyDirectory((File)TestNonWritablePersistFile.getFile((String)"dih/solr"), (File)new File(tmpSolrHome).getAbsoluteFile());
        TestNonWritablePersistFile.initCore((String)"dataimport-solrconfig.xml", (String)"dataimport-schema.xml", (String)new File(tmpSolrHome).getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonWritablePersistFile() throws Exception {
        String configDir;
        String filePath = configDir = h.getCore().getResourceLoader().getConfigDir();
        if (configDir != null && !configDir.endsWith(File.separator)) {
            filePath = filePath + File.separator;
        }
        filePath = filePath + "dataimport.properties";
        File f = new File(filePath);
        try {
            TestNonWritablePersistFile.assumeTrue((String)"No dataimport.properties file", (f.exists() || f.createNewFile() ? 1 : 0) != 0);
            TestNonWritablePersistFile.assumeTrue((String)"dataimport.properties can't be set read only", (boolean)f.setReadOnly());
            TestNonWritablePersistFile.assumeFalse((String)"dataimport.properties is still writable even though marked readonly - test running as superuser?", (boolean)f.canWrite());
            TestNonWritablePersistFile.ignoreException((String)"Properties is not writable");
            ArrayList<Map> parentRow = new ArrayList<Map>();
            parentRow.add(TestNonWritablePersistFile.createMap("id", "1"));
            MockDataSource.setIterator((String)FULLIMPORT_QUERY, parentRow.iterator());
            ArrayList<Map> childRow = new ArrayList<Map>();
            childRow.add(TestNonWritablePersistFile.createMap("desc", "hello"));
            MockDataSource.setIterator((String)"select * from y where y.A='1'", childRow.iterator());
            this.runFullImport(dataConfig_delta);
            TestNonWritablePersistFile.assertQ((SolrQueryRequest)TestNonWritablePersistFile.req((String[])new String[]{"id:1"}), (String[])new String[]{"//*[@numFound='0']"});
        }
        finally {
            f.setWritable(true);
        }
    }
}

