/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.NumberFormatTransformer;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.junit.Test;

public class TestNumberFormatTransformer
extends AbstractDataImportHandlerTestCase {
    private char GROUPING_SEP = new DecimalFormatSymbols(Locale.ROOT).getGroupingSeparator();
    private char DECIMAL_SEP = new DecimalFormatSymbols(Locale.ROOT).getDecimalSeparator();

    @Test
    public void testTransformRow_SingleNumber() {
        char GERMAN_GROUPING_SEP = new DecimalFormatSymbols(Locale.GERMANY).getGroupingSeparator();
        ArrayList<Map<String, String>> l = new ArrayList<Map<String, String>>();
        l.add(TestNumberFormatTransformer.createMap("column", "num", "formatStyle", "number"));
        l.add(TestNumberFormatTransformer.createMap("column", "localizedNum", "formatStyle", "number", "locale", "de-DE"));
        AbstractDataImportHandlerTestCase.TestContext c = TestNumberFormatTransformer.getContext(null, null, null, "FULL_DUMP", l, null);
        Map m = TestNumberFormatTransformer.createMap("num", "123" + this.GROUPING_SEP + "567", "localizedNum", "123" + GERMAN_GROUPING_SEP + "567");
        new NumberFormatTransformer().transformRow(m, (Context)c);
        TestNumberFormatTransformer.assertEquals((Object)new Long(123567L), m.get("num"));
        TestNumberFormatTransformer.assertEquals((Object)new Long(123567L), m.get("localizedNum"));
    }

    @Test
    public void testTransformRow_MultipleNumbers() throws Exception {
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        fields.add(TestNumberFormatTransformer.createMap("column", "inputs"));
        fields.add(TestNumberFormatTransformer.createMap("column", "outputs", "sourceColName", "inputs", "formatStyle", "number"));
        ArrayList<String> inputs = new ArrayList<String>();
        inputs.add("123" + this.GROUPING_SEP + "567");
        inputs.add("245" + this.GROUPING_SEP + "678");
        Map row = TestNumberFormatTransformer.createMap("inputs", inputs);
        VariableResolver resolver = new VariableResolver();
        resolver.addNamespace("e", row);
        AbstractDataImportHandlerTestCase.TestContext context = TestNumberFormatTransformer.getContext(null, resolver, null, "FULL_DUMP", fields, null);
        new NumberFormatTransformer().transformRow(row, (Context)context);
        ArrayList<Long> output = new ArrayList<Long>();
        output.add(new Long(123567L));
        output.add(new Long(245678L));
        Map outputRow = TestNumberFormatTransformer.createMap("inputs", inputs, "outputs", output);
        TestNumberFormatTransformer.assertEquals((Object)outputRow, (Object)row);
    }

    @Test(expected=DataImportHandlerException.class)
    public void testTransformRow_InvalidInput1_Number() {
        ArrayList<Map<String, String>> l = new ArrayList<Map<String, String>>();
        l.add(TestNumberFormatTransformer.createMap("column", "num", "formatStyle", "number"));
        AbstractDataImportHandlerTestCase.TestContext c = TestNumberFormatTransformer.getContext(null, null, null, "FULL_DUMP", l, null);
        Map m = TestNumberFormatTransformer.createMap("num", "123" + this.GROUPING_SEP + "5a67");
        new NumberFormatTransformer().transformRow(m, (Context)c);
    }

    @Test(expected=DataImportHandlerException.class)
    public void testTransformRow_InvalidInput2_Number() {
        ArrayList<Map<String, String>> l = new ArrayList<Map<String, String>>();
        l.add(TestNumberFormatTransformer.createMap("column", "num", "formatStyle", "number"));
        AbstractDataImportHandlerTestCase.TestContext c = TestNumberFormatTransformer.getContext(null, null, null, "FULL_DUMP", l, null);
        Map m = TestNumberFormatTransformer.createMap("num", "123" + this.GROUPING_SEP + "567b");
        new NumberFormatTransformer().transformRow(m, (Context)c);
    }

    @Test(expected=DataImportHandlerException.class)
    public void testTransformRow_InvalidInput2_Currency() {
        ArrayList<Map<String, String>> l = new ArrayList<Map<String, String>>();
        l.add(TestNumberFormatTransformer.createMap("column", "num", "formatStyle", "currency"));
        AbstractDataImportHandlerTestCase.TestContext c = TestNumberFormatTransformer.getContext(null, null, null, "FULL_DUMP", l, null);
        Map m = TestNumberFormatTransformer.createMap("num", "123" + this.GROUPING_SEP + "567b");
        new NumberFormatTransformer().transformRow(m, (Context)c);
    }

    @Test(expected=DataImportHandlerException.class)
    public void testTransformRow_InvalidInput1_Percent() {
        ArrayList<Map<String, String>> l = new ArrayList<Map<String, String>>();
        l.add(TestNumberFormatTransformer.createMap("column", "num", "formatStyle", "percent"));
        AbstractDataImportHandlerTestCase.TestContext c = TestNumberFormatTransformer.getContext(null, null, null, "FULL_DUMP", l, null);
        Map m = TestNumberFormatTransformer.createMap("num", "123" + this.GROUPING_SEP + "5a67");
        new NumberFormatTransformer().transformRow(m, (Context)c);
    }

    @Test(expected=DataImportHandlerException.class)
    public void testTransformRow_InvalidInput3_Currency() {
        ArrayList<Map<String, String>> l = new ArrayList<Map<String, String>>();
        l.add(TestNumberFormatTransformer.createMap("column", "num", "formatStyle", "currency"));
        AbstractDataImportHandlerTestCase.TestContext c = TestNumberFormatTransformer.getContext(null, null, null, "FULL_DUMP", l, null);
        Map m = TestNumberFormatTransformer.createMap("num", "123" + this.DECIMAL_SEP + "456" + this.DECIMAL_SEP + "789");
        new NumberFormatTransformer().transformRow(m, (Context)c);
    }

    @Test(expected=DataImportHandlerException.class)
    public void testTransformRow_InvalidInput3_Number() {
        ArrayList<Map<String, String>> l = new ArrayList<Map<String, String>>();
        l.add(TestNumberFormatTransformer.createMap("column", "num", "formatStyle", "number"));
        AbstractDataImportHandlerTestCase.TestContext c = TestNumberFormatTransformer.getContext(null, null, null, "FULL_DUMP", l, null);
        Map m = TestNumberFormatTransformer.createMap("num", "123" + this.DECIMAL_SEP + "456" + this.DECIMAL_SEP + "789");
        new NumberFormatTransformer().transformRow(m, (Context)c);
    }

    @Test
    public void testTransformRow_MalformedInput_Number() {
        ArrayList<Map<String, String>> l = new ArrayList<Map<String, String>>();
        l.add(TestNumberFormatTransformer.createMap("column", "num", "formatStyle", "number"));
        AbstractDataImportHandlerTestCase.TestContext c = TestNumberFormatTransformer.getContext(null, null, null, "FULL_DUMP", l, null);
        Map m = TestNumberFormatTransformer.createMap("num", "123" + this.GROUPING_SEP + this.GROUPING_SEP + "789");
        new NumberFormatTransformer().transformRow(m, (Context)c);
        TestNumberFormatTransformer.assertEquals((Object)new Long(123789L), m.get("num"));
    }
}

