/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DIHWriter;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.RequestInfo;
import org.apache.solr.handler.dataimport.TestDocBuilder;
import org.junit.Test;

public class TestPlainTextEntityProcessor
extends AbstractDataImportHandlerTestCase {
    static String DATA_CONFIG = "<dataConfig>\n\t<dataSource type=\"TestPlainTextEntityProcessor$DS\" />\n\t<document>\n\t\t<entity processor=\"PlainTextEntityProcessor\" name=\"x\" query=\"x\">\n\t\t\t<field column=\"plainText\" name=\"x\" />\n\t\t</entity>\n\t</document>\n</dataConfig>";

    @Test
    public void testSimple() throws IOException {
        DataImporter di = new DataImporter();
        di.loadAndInit(DATA_CONFIG);
        this.redirectTempProperties(di);
        TestDocBuilder.SolrWriterImpl sw = new TestDocBuilder.SolrWriterImpl();
        RequestInfo rp = new RequestInfo(null, TestPlainTextEntityProcessor.createMap("command", "full-import"), null);
        di.runCmd(rp, (DIHWriter)sw);
        TestPlainTextEntityProcessor.assertEquals((Object)DS.s, (Object)sw.docs.get(0).getFieldValue("x"));
    }

    public static class DS
    extends DataSource {
        static String s = "hello world";

        public void init(Context context, Properties initProps) {
        }

        public Object getData(String query) {
            return new StringReader(s);
        }

        public void close() {
        }
    }
}

