/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.RegexTransformer;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.junit.Test;

public class TestRegexTransformer
extends AbstractDataImportHandlerTestCase {
    @Test
    public void testCommaSeparated() {
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        fields.add(TestRegexTransformer.getField("col1", "string", null, "a", ","));
        AbstractDataImportHandlerTestCase.TestContext context = TestRegexTransformer.getContext(null, null, null, "FULL_DUMP", fields, null);
        HashMap<String, String> src = new HashMap<String, String>();
        src.put("a", "a,bb,cc,d");
        Map result = new RegexTransformer().transformRow(src, (Context)context);
        TestRegexTransformer.assertEquals((long)2L, (long)result.size());
        TestRegexTransformer.assertEquals((long)4L, (long)((List)result.get("col1")).size());
    }

    @Test
    public void testGroupNames() {
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("column", "fullName");
        m.put("groupNames", ",firstName,lastName");
        m.put("regex", "(\\w*) (\\w*) (\\w*)");
        fields.add(m);
        AbstractDataImportHandlerTestCase.TestContext context = TestRegexTransformer.getContext(null, null, null, "FULL_DUMP", fields, null);
        HashMap<String, Object> src = new HashMap<String, Object>();
        src.put("fullName", "Mr Noble Paul");
        Map result = new RegexTransformer().transformRow(src, (Context)context);
        TestRegexTransformer.assertEquals((Object)"Noble", result.get("firstName"));
        TestRegexTransformer.assertEquals((Object)"Paul", result.get("lastName"));
        src = new HashMap();
        ArrayList<String> l = new ArrayList<String>();
        l.add("Mr Noble Paul");
        l.add("Mr Shalin Mangar");
        src.put("fullName", l);
        result = new RegexTransformer().transformRow(src, (Context)context);
        List l1 = (List)result.get("firstName");
        List l2 = (List)result.get("lastName");
        TestRegexTransformer.assertEquals((Object)"Noble", l1.get(0));
        TestRegexTransformer.assertEquals((Object)"Shalin", l1.get(1));
        TestRegexTransformer.assertEquals((Object)"Paul", l2.get(0));
        TestRegexTransformer.assertEquals((Object)"Mangar", l2.get(1));
    }

    @Test
    public void testReplaceWith() {
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        Map<String, String> fld = TestRegexTransformer.getField("name", "string", "'", null, null);
        fld.put("replaceWith", "''");
        fields.add(fld);
        AbstractDataImportHandlerTestCase.TestContext context = TestRegexTransformer.getContext(null, null, null, "FULL_DUMP", fields, null);
        HashMap<String, String> src = new HashMap<String, String>();
        String s = "D'souza";
        src.put("name", s);
        Map result = new RegexTransformer().transformRow(src, (Context)context);
        TestRegexTransformer.assertEquals((Object)"D''souza", result.get("name"));
        fld = TestRegexTransformer.getField("title_underscore", "string", "\\s+", "title", null);
        fld.put("replaceWith", "_");
        fields.clear();
        fields.add(fld);
        context = TestRegexTransformer.getContext(null, null, null, "FULL_DUMP", fields, null);
        src.clear();
        src.put("title", "value with spaces");
        result = new RegexTransformer().transformRow(src, (Context)context);
        TestRegexTransformer.assertEquals((Object)"value_with_spaces", result.get("title_underscore"));
        src.clear();
        src.put("title", "valueWithoutSpaces");
        result = new RegexTransformer().transformRow(src, (Context)context);
        TestRegexTransformer.assertEquals((Object)"valueWithoutSpaces", result.get("title_underscore"));
    }

    @Test
    public void testMileage() {
        List<Map<String, String>> fields = TestRegexTransformer.getFields();
        Map<String, String> fld = TestRegexTransformer.getField("hltCityMPG", "string", ".*(${e.city_mileage})", "rowdata", null);
        fld.put("replaceWith", "*** $1 ***");
        fields.add(fld);
        fld = TestRegexTransformer.getField("t1", "string", "duff", "rowdata", null);
        fields.add(fld);
        fld = TestRegexTransformer.getField("t2", "string", "duff", "rowdata", null);
        fld.put("replaceWith", "60");
        fields.add(fld);
        fld = TestRegexTransformer.getField("t3", "string", "(Range)", "rowdata", null);
        fld.put("replaceWith", "range");
        fld.put("groupNames", "t4,t5");
        fields.add(fld);
        HashMap<String, String> row = new HashMap<String, String>();
        String s = "Fuel Economy Range: 26 mpg Hwy, 19 mpg City";
        row.put("rowdata", s);
        VariableResolver resolver = new VariableResolver();
        resolver.addNamespace("e", row);
        Map eAttrs = TestRegexTransformer.createMap("name", "e");
        AbstractDataImportHandlerTestCase.TestContext context = TestRegexTransformer.getContext(null, resolver, null, "FULL_DUMP", fields, eAttrs);
        Map result = new RegexTransformer().transformRow(row, (Context)context);
        TestRegexTransformer.assertEquals((long)6L, (long)result.size());
        TestRegexTransformer.assertEquals((Object)s, result.get("t2"));
        TestRegexTransformer.assertEquals((Object)s, result.get("rowdata"));
        TestRegexTransformer.assertEquals((Object)"26", result.get("highway_mileage"));
        TestRegexTransformer.assertEquals((Object)"19", result.get("city_mileage"));
        TestRegexTransformer.assertEquals((Object)"*** 19 *** mpg City", result.get("hltCityMPG"));
        TestRegexTransformer.assertEquals((Object)"Fuel Economy range: 26 mpg Hwy, 19 mpg City", result.get("t3"));
    }

    @Test
    public void testMultiValuedRegex() {
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        Map<String, String> fld = TestRegexTransformer.getField("participant", null, "(.*)", "person", null);
        fields.add(fld);
        AbstractDataImportHandlerTestCase.TestContext context = TestRegexTransformer.getContext(null, null, null, "FULL_DUMP", fields, null);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("hello");
        strings.add("world");
        Map result = new RegexTransformer().transformRow(TestRegexTransformer.createMap("person", strings), (Context)context);
        TestRegexTransformer.assertEquals(strings, result.get("participant"));
    }

    public static List<Map<String, String>> getFields() {
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        fields.add(TestRegexTransformer.getField("city_mileage", "sint", "Fuel Economy Range:\\s*?\\d*?\\s*?mpg Hwy,\\s*?(\\d*?)\\s*?mpg City", "rowdata", null));
        fields.add(TestRegexTransformer.getField("highway_mileage", "sint", "Fuel Economy Range:\\s*?(\\d*?)\\s*?mpg Hwy,\\s*?\\d*?\\s*?mpg City", "rowdata", null));
        fields.add(TestRegexTransformer.getField("seating_capacity", "sint", "Seating capacity:(.*)", "rowdata", null));
        fields.add(TestRegexTransformer.getField("warranty", "string", "Warranty:(.*)", "rowdata", null));
        fields.add(TestRegexTransformer.getField("rowdata", "string", null, "rowdata", null));
        return fields;
    }
}

