/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.EntityProcessorWrapper;
import org.apache.solr.handler.dataimport.SqlEntityProcessor;
import org.apache.solr.handler.dataimport.config.DIHConfiguration;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class TestScriptTransformer
extends AbstractDataImportHandlerTestCase {
    static String xml = "<dataConfig>\n<script><![CDATA[\nfunction checkNextToken(row)\t{\n var nt = row.get('nextToken'); if (nt && nt !='' ){     row.put('$hasMore', 'true');}\n    return row;\n}]]></script>\t<document>\n\t\t<entity name=\"mbx\" pk=\"articleNumber\" processor=\"XPathEntityProcessor\"\n\t\t\turl=\"?boardId=${dataimporter.defaults.boardId}&amp;maxRecords=20&amp;includeBody=true&amp;startDate=${dataimporter.defaults.startDate}&amp;guid=:autosearch001&amp;reqId=1&amp;transactionId=stringfortracing&amp;listPos=${mbx.nextToken}\"\n\t\t\tforEach=\"/mbmessage/articles/navigation | /mbmessage/articles/article\" transformer=\"script:checkNextToken\">\n\n\t\t\t<field column=\"nextToken\"\n\t\t\t\txpath=\"/mbmessage/articles/navigation/nextToken\" />\n\n\t\t</entity>\n\t</document>\n</dataConfig>";

    @Test
    public void testBasic() {
        try {
            String script = "function f1(row,context){row.put('name','Hello ' + row.get('name'));return row;\n}";
            Context context = this.getContext("f1", script);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", "Scott");
            EntityProcessorWrapper sep = new EntityProcessorWrapper((EntityProcessor)new SqlEntityProcessor(), null, null);
            sep.init(context);
            sep.applyTransformer(map);
            TestScriptTransformer.assertEquals((Object)"Hello Scott", (Object)map.get("name").toString());
        }
        catch (DataImportHandlerException e) {
            TestScriptTransformer.assumeFalse((String)"This JVM does not have JavaScript installed.  Test Skipped.", (boolean)e.getMessage().startsWith("Cannot load Script Engine for language"));
            throw e;
        }
    }

    private Context getContext(String funcName, String script) {
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        HashMap<String, String> entity = new HashMap<String, String>();
        entity.put("name", "hello");
        entity.put("transformer", "script:" + funcName);
        AbstractDataImportHandlerTestCase.TestContext context = TestScriptTransformer.getContext(null, null, null, "FULL_DUMP", fields, entity);
        context.script = script;
        context.scriptlang = "JavaScript";
        return context;
    }

    @Test
    public void testOneparam() {
        try {
            String script = "function f1(row){row.put('name','Hello ' + row.get('name'));return row;\n}";
            Context context = this.getContext("f1", script);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", "Scott");
            EntityProcessorWrapper sep = new EntityProcessorWrapper((EntityProcessor)new SqlEntityProcessor(), null, null);
            sep.init(context);
            sep.applyTransformer(map);
            TestScriptTransformer.assertEquals((Object)"Hello Scott", (Object)map.get("name").toString());
        }
        catch (DataImportHandlerException e) {
            TestScriptTransformer.assumeFalse((String)"This JVM does not have JavaScript installed.  Test Skipped.", (boolean)e.getMessage().startsWith("Cannot load Script Engine for language"));
            throw e;
        }
    }

    @Test
    public void testReadScriptTag() throws Exception {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(xml)));
            DataImporter di = new DataImporter();
            DIHConfiguration dc = di.readFromXml(document);
            TestScriptTransformer.assertTrue((dc.getScript().getText().indexOf("checkNextToken") > -1 ? 1 : 0) != 0);
        }
        catch (DataImportHandlerException e) {
            TestScriptTransformer.assumeFalse((String)"This JVM does not have JavaScript installed.  Test Skipped.", (boolean)e.getMessage().startsWith("Cannot load Script Engine for language"));
            throw e;
        }
    }

    @Test
    public void testCheckScript() throws Exception {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(xml)));
            DataImporter di = new DataImporter();
            DIHConfiguration dc = di.readFromXml(document);
            Context c = this.getContext("checkNextToken", dc.getScript().getText());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("nextToken", "hello");
            EntityProcessorWrapper sep = new EntityProcessorWrapper((EntityProcessor)new SqlEntityProcessor(), null, null);
            sep.init(c);
            sep.applyTransformer(map);
            TestScriptTransformer.assertEquals((Object)"true", map.get("$hasMore"));
            map = new HashMap();
            map.put("nextToken", "");
            sep.applyTransformer(map);
            TestScriptTransformer.assertNull(map.get("$hasMore"));
        }
        catch (DataImportHandlerException e) {
            TestScriptTransformer.assumeFalse((String)"This JVM does not have JavaScript installed.  Test Skipped.", (boolean)e.getMessage().startsWith("Cannot load Script Engine for language"));
            throw e;
        }
    }
}

