/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.handler.dataimport.AbstractDIHJdbcTestCase;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.SimplePropertiesWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSimplePropertiesWriter
extends AbstractDIHJdbcTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean useJdbcEscapeSyntax;
    private String dateFormat;
    private String fileLocation;
    private String fileName;

    @Before
    public void spwBefore() throws Exception {
        this.fileLocation = TestSimplePropertiesWriter.createTempDir().toFile().getAbsolutePath();
        this.fileName = "the.properties";
    }

    @Test
    @SuppressForbidden(reason="Needs currentTimeMillis to construct date stamps")
    public void testSimplePropertiesWriter() throws Exception {
        SimpleDateFormat errMsgFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS", Locale.ROOT);
        String[] d = new String[]{"{'ts' ''yyyy-MM-dd HH:mm:ss.SSSSSS''}", "{'ts' ''yyyy-MM-dd HH:mm:ss''}", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSSSSS"};
        for (int i = 0; i < d.length; ++i) {
            TestSimplePropertiesWriter.delQ((String)"*:*");
            TestSimplePropertiesWriter.commit((String[])new String[0]);
            this.useJdbcEscapeSyntax = i < 2;
            this.dateFormat = d[i];
            SimpleDateFormat df = new SimpleDateFormat(this.dateFormat, Locale.ROOT);
            Date oneSecondAgo = new Date(System.currentTimeMillis() - 1000L);
            HashMap<String, String> init = new HashMap<String, String>();
            init.put("dateFormat", this.dateFormat);
            init.put("filename", this.fileName);
            init.put("directory", this.fileLocation);
            SimplePropertiesWriter spw = new SimplePropertiesWriter();
            spw.init(new DataImporter(), init);
            Map props = new HashMap<String, Date>();
            props.put("SomeDates.last_index_time", oneSecondAgo);
            props.put("last_index_time", oneSecondAgo);
            spw.persist(props);
            h.query("/dataimport", (SolrQueryRequest)this.generateRequest());
            props = spw.readIndexerProperties();
            Date entityDate = df.parse((String)props.get("SomeDates.last_index_time"));
            Date docDate = df.parse((String)props.get("last_index_time"));
            int year = this.currentYearFromDatabase();
            Assert.assertTrue((String)("This date: " + errMsgFormat.format(oneSecondAgo) + " should be prior to the document date: " + errMsgFormat.format(docDate)), (docDate.getTime() - oneSecondAgo.getTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)("This date: " + errMsgFormat.format(oneSecondAgo) + " should be prior to the entity date: " + errMsgFormat.format(entityDate)), (entityDate.getTime() - oneSecondAgo.getTime() > 0L ? 1 : 0) != 0);
            TestSimplePropertiesWriter.assertQ((SolrQueryRequest)TestSimplePropertiesWriter.req((String[])new String[]{"*:*"}), (String[])new String[]{"//*[@numFound='1']", "//doc/str[@name=\"ayear_s\"]=\"" + year + "\""});
        }
    }

    private int currentYearFromDatabase() throws Exception {
        Connection conn = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            conn = this.newConnection();
            s = conn.createStatement();
            rs = s.executeQuery("select year(current_timestamp) from sysibm.sysdummy1");
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            Assert.fail((String)"We should have gotten a row from the db.");
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                s.close();
            }
            catch (Exception exception) {}
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    @Override
    protected AbstractDIHJdbcTestCase.Database setAllowedDatabases() {
        return AbstractDIHJdbcTestCase.Database.DERBY;
    }

    @Override
    protected String generateConfig() {
        StringBuilder sb = new StringBuilder();
        String q = this.useJdbcEscapeSyntax ? "" : "'";
        sb.append("<dataConfig> \n");
        sb.append("<propertyWriter dateFormat=\"" + this.dateFormat + "\" type=\"SimplePropertiesWriter\" directory=\"" + this.fileLocation + "\" filename=\"" + this.fileName + "\" />\n");
        sb.append("<dataSource name=\"derby\" driver=\"org.apache.derby.jdbc.EmbeddedDriver\" url=\"jdbc:derby:memory:derbyDB;territory=en_US\" /> \n");
        sb.append("<document name=\"TestSimplePropertiesWriter\"> \n");
        sb.append("<entity name=\"SomeDates\" processor=\"SqlEntityProcessor\" dataSource=\"derby\" ");
        sb.append("query=\"select 1 as id, YEAR(" + q + "${dih.last_index_time}" + q + ") as AYEAR_S from sysibm.sysdummy1 \" >\n");
        sb.append("<field column=\"AYEAR_S\" name=\"ayear_s\" /> \n");
        sb.append("</entity>\n");
        sb.append("</document> \n");
        sb.append("</dataConfig> \n");
        String config = sb.toString();
        log.debug(config);
        return config;
    }
}

