/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.MockDataSource;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSolrEntityProcessorEndToEnd
extends AbstractDataImportHandlerTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String SOLR_CONFIG = "dataimport-solrconfig.xml";
    private static final String SOLR_SCHEMA = "dataimport-schema.xml";
    private static final String SOURCE_CONF_DIR = "dih" + File.separator + "solr" + File.separator + "collection1" + File.separator + "conf" + File.separator;
    private static final String ROOT_DIR = "dih" + File.separator + "solr" + File.separator;
    private static final String DEAD_SOLR_SERVER = "http://[ff01::114]:33332/solr";
    private static final List<Map<String, Object>> DB_DOCS = new ArrayList<Map<String, Object>>();
    private static final List<Map<String, Object>> SOLR_DOCS = new ArrayList<Map<String, Object>>();
    private SolrInstance instance = null;
    private JettySolrRunner jetty;
    static String savedFactory;

    private String getDihConfigTagsInnerEntity() {
        return "<dataConfig>\r\n  <dataSource type='MockDataSource' />\r\n  <document>\r\n    <entity name='db' query='select * from x'>\r\n      <field column='dbid_s' />\r\n      <field column='dbdesc_s' />\r\n      <entity name='se' processor='SolrEntityProcessor' query='id:${db.dbid_s}'\n     url='" + this.getSourceUrl() + "' fields='id,desc'>\r\n        <field column='id' />\r\n        <field column='desc' />\r\n      </entity>\r\n    </entity>\r\n  </document>\r\n</dataConfig>\r\n";
    }

    private String generateDIHConfig(String options, boolean useDeadServer) {
        return "<dataConfig>\r\n  <document>\r\n    <entity name='se' processor='SolrEntityProcessor'   url='" + (useDeadServer ? DEAD_SOLR_SERVER : this.getSourceUrl()) + "' " + options + " />\r\n  </document>\r\n</dataConfig>\r\n";
    }

    private String getSourceUrl() {
        return TestSolrEntityProcessorEndToEnd.buildUrl((int)this.jetty.getLocalPort(), (String)"/solr/collection1");
    }

    @BeforeClass
    public static void beforeClass() {
        savedFactory = System.getProperty("solr.DirectoryFactory");
        System.setProperty("solr.directoryFactory", "solr.StandardDirectoryFactory");
    }

    @AfterClass
    public static void afterClass() {
        if (savedFactory == null) {
            System.clearProperty("solr.directoryFactory");
        } else {
            System.setProperty("solr.directoryFactory", savedFactory);
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        TestSolrEntityProcessorEndToEnd.initCore(SOLR_CONFIG, SOLR_SCHEMA);
        this.instance = new SolrInstance();
        this.instance.setUp();
        this.jetty = this.createJetty(this.instance);
    }

    @After
    public void tearDown() throws Exception {
        try {
            TestSolrEntityProcessorEndToEnd.deleteCore();
        }
        catch (Exception e) {
            LOG.error("Error deleting core", (Throwable)e);
        }
        this.jetty.stop();
        this.instance.tearDown();
        super.tearDown();
    }

    public void testFullImport() {
        TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"*:*"}), (String[])new String[]{"//result[@numFound='0']"});
        try {
            this.addDocumentsToSolr(SOLR_DOCS);
            this.runFullImport(this.generateDIHConfig("query='*:*' rows='2' fl='id,desc' onError='skip'", false));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            TestSolrEntityProcessorEndToEnd.fail((String)e.getMessage());
        }
        TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"*:*"}), (String[])new String[]{"//result[@numFound='1']"});
        TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"id:1"}), (String[])new String[]{"//result/doc/str[@name='id'][.='1']", "//result/doc/arr[@name='desc'][.='SolrDescription']"});
    }

    public void testFullImportFqParam() {
        TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"*:*"}), (String[])new String[]{"//result[@numFound='0']"});
        try {
            this.addDocumentsToSolr(TestSolrEntityProcessorEndToEnd.generateSolrDocuments(30));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("rows", "50");
            this.runFullImport(this.generateDIHConfig("query='*:*' fq='desc:Description1*,desc:Description*2' rows='2'", false), map);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            TestSolrEntityProcessorEndToEnd.fail((String)e.getMessage());
        }
        TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"*:*"}), (String[])new String[]{"//result[@numFound='1']"});
        TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"id:12"}), (String[])new String[]{"//result[@numFound='1']", "//result/doc/arr[@name='desc'][.='Description12']"});
    }

    public void testFullImportFieldsParam() {
        TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"*:*"}), (String[])new String[]{"//result[@numFound='0']"});
        try {
            this.addDocumentsToSolr(TestSolrEntityProcessorEndToEnd.generateSolrDocuments(7));
            this.runFullImport(this.generateDIHConfig("query='*:*' fl='id' rows='2'" + (TestSolrEntityProcessorEndToEnd.random().nextBoolean() ? " cursorMark='true' sort='id asc'" : ""), false));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            TestSolrEntityProcessorEndToEnd.fail((String)e.getMessage());
        }
        TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"*:*"}), (String[])new String[]{"//result[@numFound='7']"});
        TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"id:1"}), (String[])new String[]{"//result[@numFound='1']"});
        try {
            TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"id:1"}), (String[])new String[]{"//result/doc/arr[@name='desc']"});
            TestSolrEntityProcessorEndToEnd.fail((String)"The document has a field with name desc");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFullImportInnerEntity() {
        TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"*:*"}), (String[])new String[]{"//result[@numFound='0']"});
        try {
            ArrayList<Map<String, Object>> DOCS = new ArrayList<Map<String, Object>>(DB_DOCS);
            HashMap<String, String> doc = new HashMap<String, String>();
            doc.put("dbid_s", "2");
            doc.put("dbdesc_s", "DbDescription2");
            DOCS.add(doc);
            MockDataSource.setIterator((String)"select * from x", DOCS.iterator());
            DOCS = new ArrayList<Map<String, Object>>(SOLR_DOCS);
            HashMap<String, String> solrDoc = new HashMap<String, String>();
            solrDoc.put("id", "2");
            solrDoc.put("desc", "SolrDescription2");
            DOCS.add(solrDoc);
            this.addDocumentsToSolr(DOCS);
            this.runFullImport(this.getDihConfigTagsInnerEntity());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            TestSolrEntityProcessorEndToEnd.fail((String)e.getMessage());
        }
        finally {
            MockDataSource.clearCache();
        }
        TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"*:*"}), (String[])new String[]{"//result[@numFound='2']"});
        TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"id:1"}), (String[])new String[]{"//result/doc/str[@name='id'][.='1']", "//result/doc/str[@name='dbdesc_s'][.='DbDescription']", "//result/doc/str[@name='dbid_s'][.='1']", "//result/doc/arr[@name='desc'][.='SolrDescription']"});
        TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"id:2"}), (String[])new String[]{"//result/doc/str[@name='id'][.='2']", "//result/doc/str[@name='dbdesc_s'][.='DbDescription2']", "//result/doc/str[@name='dbid_s'][.='2']", "//result/doc/arr[@name='desc'][.='SolrDescription2']"});
    }

    public void testFullImportWrongSolrUrl() {
        TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"*:*"}), (String[])new String[]{"//result[@numFound='0']"});
        try {
            this.runFullImport(this.generateDIHConfig("query='*:*' rows='2' fl='id,desc' onError='skip'", true));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            TestSolrEntityProcessorEndToEnd.fail((String)e.getMessage());
        }
        TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"*:*"}), (String[])new String[]{"//result[@numFound='0']"});
    }

    public void testFullImportBadConfig() {
        TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"*:*"}), (String[])new String[]{"//result[@numFound='0']"});
        try {
            this.runFullImport(this.generateDIHConfig("query='bogus:3' rows='2' fl='id,desc' onError='" + (TestSolrEntityProcessorEndToEnd.random().nextBoolean() ? "abort" : "justtogetcoverage") + "'", false));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            TestSolrEntityProcessorEndToEnd.fail((String)e.getMessage());
        }
        TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"*:*"}), (String[])new String[]{"//result[@numFound='0']"});
    }

    public void testCursorMarkNoSort() throws SolrServerException, IOException {
        TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"*:*"}), (String[])new String[]{"//result[@numFound='0']"});
        this.addDocumentsToSolr(TestSolrEntityProcessorEndToEnd.generateSolrDocuments(7));
        try {
            List<String> errors = Arrays.asList("sort='id'", "", "sort='id asc' timeout='12345'");
            Collections.shuffle(errors, TestSolrEntityProcessorEndToEnd.random());
            String attrs = "query='*:*' rows='2' fl='id,desc' cursorMark='true' " + errors.get(0);
            this.runFullImport(this.generateDIHConfig(attrs, false));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            TestSolrEntityProcessorEndToEnd.fail((String)e.getMessage());
        }
        TestSolrEntityProcessorEndToEnd.assertQ((SolrQueryRequest)TestSolrEntityProcessorEndToEnd.req((String[])new String[]{"*:*"}), (String[])new String[]{"//result[@numFound='0']"});
    }

    private static List<Map<String, Object>> generateSolrDocuments(int num) {
        ArrayList<Map<String, Object>> docList = new ArrayList<Map<String, Object>>();
        for (int i = 1; i <= num; ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", i);
            map.put("desc", "Description" + i);
            docList.add(map);
        }
        return docList;
    }

    private void addDocumentsToSolr(List<Map<String, Object>> docs) throws SolrServerException, IOException {
        ArrayList<SolrInputDocument> sidl = new ArrayList<SolrInputDocument>();
        for (Map<String, Object> doc : docs) {
            SolrInputDocument sd = new SolrInputDocument(new String[0]);
            for (Map.Entry<String, Object> entry : doc.entrySet()) {
                sd.addField(entry.getKey(), entry.getValue());
            }
            sidl.add(sd);
        }
        try (HttpSolrClient solrServer = TestSolrEntityProcessorEndToEnd.getHttpSolrClient((String)this.getSourceUrl());){
            solrServer.setConnectionTimeout(15000);
            solrServer.setSoTimeout(30000);
            solrServer.add(sidl);
            solrServer.commit(true, true);
        }
    }

    private JettySolrRunner createJetty(SolrInstance instance) throws Exception {
        Properties nodeProperties = new Properties();
        nodeProperties.setProperty("solr.data.dir", instance.getDataDir());
        JettySolrRunner jetty = new JettySolrRunner(instance.getHomeDir(), nodeProperties, TestSolrEntityProcessorEndToEnd.buildJettyConfig((String)"/solr"));
        jetty.start();
        return jetty;
    }

    static {
        HashMap<String, String> dbDoc = new HashMap<String, String>();
        dbDoc.put("dbid_s", "1");
        dbDoc.put("dbdesc_s", "DbDescription");
        DB_DOCS.add(dbDoc);
        HashMap<String, String> solrDoc = new HashMap<String, String>();
        solrDoc.put("id", "1");
        solrDoc.put("desc", "SolrDescription");
        SOLR_DOCS.add(solrDoc);
    }

    private static class SolrInstance {
        File homeDir;
        File confDir;

        private SolrInstance() {
        }

        public String getHomeDir() {
            return this.homeDir.toString();
        }

        public String getSchemaFile() {
            return SOURCE_CONF_DIR + TestSolrEntityProcessorEndToEnd.SOLR_SCHEMA;
        }

        public String getDataDir() {
            return initCoreDataDir.toString();
        }

        public String getSolrConfigFile() {
            return SOURCE_CONF_DIR + TestSolrEntityProcessorEndToEnd.SOLR_CONFIG;
        }

        public String getSolrXmlFile() {
            return ROOT_DIR + "solr.xml";
        }

        public void setUp() throws Exception {
            this.homeDir = LuceneTestCase.createTempDir().toFile();
            initCoreDataDir = new File(this.homeDir + "/collection1", "data");
            this.confDir = new File(this.homeDir + "/collection1", "conf");
            this.homeDir.mkdirs();
            initCoreDataDir.mkdirs();
            this.confDir.mkdirs();
            FileUtils.copyFile((File)SolrTestCaseJ4.getFile((String)this.getSolrXmlFile()), (File)new File(this.homeDir, "solr.xml"));
            File f = new File(this.confDir, "solrconfig.xml");
            FileUtils.copyFile((File)SolrTestCaseJ4.getFile((String)this.getSolrConfigFile()), (File)f);
            f = new File(this.confDir, "schema.xml");
            FileUtils.copyFile((File)SolrTestCaseJ4.getFile((String)this.getSchemaFile()), (File)f);
            f = new File(this.confDir, "data-config.xml");
            FileUtils.copyFile((File)SolrTestCaseJ4.getFile((String)(SOURCE_CONF_DIR + "dataconfig-contentstream.xml")), (File)f);
            Files.createFile(this.confDir.toPath().resolve("../core.properties"), new FileAttribute[0]);
        }

        public void tearDown() throws Exception {
            IOUtils.rm((Path[])new Path[]{this.homeDir.toPath()});
        }
    }
}

