/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.MockSolrEntityProcessor;
import org.apache.solr.handler.dataimport.SolrEntityProcessor;
import org.junit.Test;

public class TestSolrEntityProcessorUnit
extends AbstractDataImportHandlerTestCase {
    private static final String ID = "id";

    public void testQuery() {
        List<SolrTestCaseJ4.Doc> docs = this.generateUniqueDocs(2);
        MockSolrEntityProcessor processor = this.createAndInit(docs);
        try {
            TestSolrEntityProcessorUnit.assertExpectedDocs(docs, processor);
            TestSolrEntityProcessorUnit.assertEquals((long)1L, (long)processor.getQueryCount());
        }
        finally {
            processor.destroy();
        }
    }

    private MockSolrEntityProcessor createAndInit(List<SolrTestCaseJ4.Doc> docs) {
        return this.createAndInit(docs, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNumDocsGreaterThanRows() {
        List<SolrTestCaseJ4.Doc> docs = this.generateUniqueDocs(44);
        int rowsNum = 10;
        MockSolrEntityProcessor processor = this.createAndInit(docs, rowsNum);
        try {
            TestSolrEntityProcessorUnit.assertExpectedDocs(docs, processor);
            TestSolrEntityProcessorUnit.assertEquals((long)5L, (long)processor.getQueryCount());
        }
        finally {
            processor.destroy();
        }
    }

    private MockSolrEntityProcessor createAndInit(List<SolrTestCaseJ4.Doc> docs, int rowsNum) {
        MockSolrEntityProcessor processor = new MockSolrEntityProcessor(docs, rowsNum);
        HashMap<String, String> entityAttrs = new HashMap<String, String>(){
            {
                this.put("url", "http://route:66/no");
            }
        };
        processor.init(TestSolrEntityProcessorUnit.getContext(null, null, null, null, Collections.emptyList(), (Map<String, String>)entityAttrs));
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiValuedFields() {
        ArrayList<SolrTestCaseJ4.Doc> docs = new ArrayList<SolrTestCaseJ4.Doc>();
        ArrayList<SolrTestCaseJ4.FldType> types = new ArrayList<SolrTestCaseJ4.FldType>();
        types.add(new SolrTestCaseJ4.FldType(ID, (SolrTestCaseJ4.IVals)ONE_ONE, (SolrTestCaseJ4.Vals)new SolrTestCaseJ4.SVal('A', 'Z', 4, 4)));
        types.add(new SolrTestCaseJ4.FldType("description", (SolrTestCaseJ4.IVals)new SolrTestCaseJ4.IRange(3, 3), (SolrTestCaseJ4.Vals)new SolrTestCaseJ4.SVal('a', 'c', 1, 1)));
        SolrTestCaseJ4.Doc testDoc = TestSolrEntityProcessorUnit.createDoc(types);
        docs.add(testDoc);
        MockSolrEntityProcessor processor = this.createAndInit(docs);
        try {
            Map next = processor.nextRow();
            TestSolrEntityProcessorUnit.assertNotNull((Object)next);
            List multiField = (List)next.get("description");
            TestSolrEntityProcessorUnit.assertEquals((long)testDoc.getValues("description").size(), (long)multiField.size());
            TestSolrEntityProcessorUnit.assertEquals((Object)testDoc.getValues("description"), (Object)multiField);
            TestSolrEntityProcessorUnit.assertEquals((long)1L, (long)processor.getQueryCount());
            TestSolrEntityProcessorUnit.assertNull((Object)processor.nextRow());
        }
        finally {
            processor.destroy();
        }
    }

    @Test(expected=DataImportHandlerException.class)
    public void testNoQuery() {
        SolrEntityProcessor processor = new SolrEntityProcessor();
        HashMap<String, String> entityAttrs = new HashMap<String, String>(){
            {
                this.put("url", "http://route:66/no");
            }
        };
        processor.init((Context)TestSolrEntityProcessorUnit.getContext(null, null, null, null, Collections.emptyList(), (Map<String, String>)entityAttrs));
        try {
            processor.buildIterator();
        }
        finally {
            processor.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPagingQuery() {
        NoNextMockProcessor processor = new NoNextMockProcessor();
        HashMap<String, String> entityAttrs = new HashMap<String, String>(){
            {
                this.put("url", "http://route:66/no");
                if (LuceneTestCase.random().nextBoolean()) {
                    List<String> noCursor = Arrays.asList("", "false", "*");
                    Collections.shuffle(noCursor, LuceneTestCase.random());
                    this.put("cursorMark", noCursor.get(0));
                }
            }
        };
        processor.init(TestSolrEntityProcessorUnit.getContext(null, null, null, null, Collections.emptyList(), (Map<String, String>)entityAttrs));
        try {
            processor.buildIterator();
            SolrQuery query = new SolrQuery();
            ((SolrEntityProcessor.SolrDocumentListIterator)processor.rowIterator).passNextPage(query);
            TestSolrEntityProcessorUnit.assertEquals((Object)"0", (Object)query.get("start"));
            TestSolrEntityProcessorUnit.assertNull((Object)query.get("cursorMark"));
            TestSolrEntityProcessorUnit.assertNotNull((Object)query.get("timeAllowed"));
        }
        finally {
            processor.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCursorQuery() {
        NoNextMockProcessor processor = new NoNextMockProcessor();
        HashMap<String, String> entityAttrs = new HashMap<String, String>(){
            {
                this.put("url", "http://route:66/no");
                this.put("cursorMark", "true");
            }
        };
        processor.init(TestSolrEntityProcessorUnit.getContext(null, null, null, null, Collections.emptyList(), (Map<String, String>)entityAttrs));
        try {
            processor.buildIterator();
            SolrQuery query = new SolrQuery();
            ((SolrEntityProcessor.SolrDocumentListIterator)processor.rowIterator).passNextPage(query);
            TestSolrEntityProcessorUnit.assertNull((Object)query.get("start"));
            TestSolrEntityProcessorUnit.assertEquals((Object)"*", (Object)query.get("cursorMark"));
            TestSolrEntityProcessorUnit.assertNull((Object)query.get("timeAllowed"));
        }
        finally {
            processor.destroy();
        }
    }

    private List<SolrTestCaseJ4.Doc> generateUniqueDocs(int numDocs) {
        ArrayList<SolrTestCaseJ4.FldType> types = new ArrayList<SolrTestCaseJ4.FldType>();
        types.add(new SolrTestCaseJ4.FldType(ID, (SolrTestCaseJ4.IVals)ONE_ONE, (SolrTestCaseJ4.Vals)new SolrTestCaseJ4.SVal('A', 'Z', 4, 40)));
        types.add(new SolrTestCaseJ4.FldType("description", (SolrTestCaseJ4.IVals)new SolrTestCaseJ4.IRange(1, 3), (SolrTestCaseJ4.Vals)new SolrTestCaseJ4.SVal('a', 'c', 1, 1)));
        HashSet<Comparable> previousIds = new HashSet<Comparable>();
        ArrayList<SolrTestCaseJ4.Doc> docs = new ArrayList<SolrTestCaseJ4.Doc>(numDocs);
        for (int i = 0; i < numDocs; ++i) {
            SolrTestCaseJ4.Doc doc = TestSolrEntityProcessorUnit.createDoc(types);
            while (previousIds.contains(doc.id)) {
                doc = TestSolrEntityProcessorUnit.createDoc(types);
            }
            previousIds.add(doc.id);
            docs.add(doc);
        }
        return docs;
    }

    private static void assertExpectedDocs(List<SolrTestCaseJ4.Doc> expectedDocs, SolrEntityProcessor processor) {
        for (SolrTestCaseJ4.Doc expectedDoc : expectedDocs) {
            Map next = processor.nextRow();
            TestSolrEntityProcessorUnit.assertNotNull((Object)next);
            TestSolrEntityProcessorUnit.assertEquals((Object)expectedDoc.id, next.get(ID));
            TestSolrEntityProcessorUnit.assertEquals((Object)expectedDoc.getValues("description"), next.get("description"));
        }
        TestSolrEntityProcessorUnit.assertNull((Object)processor.nextRow());
    }

    private static final class NoNextMockProcessor
    extends SolrEntityProcessor {
        private NoNextMockProcessor() {
        }

        protected void nextPage() {
        }
    }
}

