/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.solr.handler.dataimport.AbstractDIHCacheTestCase;
import org.apache.solr.handler.dataimport.DIHCache;
import org.apache.solr.handler.dataimport.SortedMapBackedCache;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSortedMapBackedCache
extends AbstractDIHCacheTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testCacheWithKeyLookup() {
        SortedMapBackedCache cache = null;
        try {
            cache = new SortedMapBackedCache();
            cache.open(TestSortedMapBackedCache.getContext(new HashMap<String, String>()));
            this.loadData((DIHCache)cache, this.data, this.fieldNames, true);
            List<AbstractDIHCacheTestCase.ControlData> testData = this.extractDataByKeyLookup((DIHCache)cache, this.fieldNames);
            this.compareData(this.data, testData);
        }
        catch (Exception e) {
            log.warn("Exception thrown: " + e.toString());
            Assert.fail();
        }
        finally {
            try {
                cache.destroy();
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testCacheWithOrderedLookup() {
        SortedMapBackedCache cache = null;
        try {
            cache = new SortedMapBackedCache();
            cache.open(TestSortedMapBackedCache.getContext(new HashMap<String, String>()));
            this.loadData((DIHCache)cache, this.data, this.fieldNames, true);
            List<AbstractDIHCacheTestCase.ControlData> testData = this.extractDataInKeyOrder((DIHCache)cache, this.fieldNames);
            this.compareData(this.data, testData);
        }
        catch (Exception e) {
            log.warn("Exception thrown: " + e.toString());
            Assert.fail();
        }
        finally {
            try {
                cache.destroy();
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testNullKeys() throws Exception {
        SortedMapBackedCache cache = null;
        try {
            cache = new SortedMapBackedCache();
            HashMap<String, String> cacheProps = new HashMap<String, String>();
            cacheProps.put("cacheKey", "a_id");
            cache.open(TestSortedMapBackedCache.getContext(cacheProps));
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("a_id", null);
            data.put("bogus", "data");
            cache.add(data);
            Iterator cacheIter = cache.iterator();
            while (cacheIter.hasNext()) {
                Assert.fail((String)"cache should be empty.");
            }
            Assert.assertNull((Object)cache.iterator(null));
            cache.delete(null);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                cache.destroy();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCacheReopensWithUpdate() {
        SortedMapBackedCache cache = null;
        try {
            HashMap<String, String> cacheProps = new HashMap<String, String>();
            cacheProps.put("cacheKey", "a_id");
            cache = new SortedMapBackedCache();
            cache.open(TestSortedMapBackedCache.getContext(cacheProps));
            this.loadData((DIHCache)cache, this.data, this.fieldNames, false);
            cache.close();
            ArrayList<AbstractDIHCacheTestCase.ControlData> newControlData = new ArrayList<AbstractDIHCacheTestCase.ControlData>();
            Object[] newIdEqualsThree = null;
            int j = 0;
            for (int i = 0; i < this.data.size(); ++i) {
                if (((AbstractDIHCacheTestCase.ControlData)this.data.get((int)i)).data[0].equals(new Integer(1))) continue;
                if (((AbstractDIHCacheTestCase.ControlData)this.data.get((int)i)).data[0].equals(new Integer(3))) {
                    newIdEqualsThree = new Object[((AbstractDIHCacheTestCase.ControlData)this.data.get((int)i)).data.length];
                    System.arraycopy(((AbstractDIHCacheTestCase.ControlData)this.data.get((int)i)).data, 0, newIdEqualsThree, 0, newIdEqualsThree.length);
                    newIdEqualsThree[3] = "Carrot";
                    newControlData.add(new AbstractDIHCacheTestCase.ControlData(newIdEqualsThree));
                } else {
                    newControlData.add((AbstractDIHCacheTestCase.ControlData)this.data.get(i));
                }
                ++j;
            }
            Object[] newDataRow1 = new Object[]{new Integer(99), new BigDecimal(Math.PI), "Z", "Zebra", new Float(99.99), Feb21_2011, null};
            Object[] newDataRow2 = new Object[]{new Integer(2), new BigDecimal(Math.PI), "B", "Ballerina", new Float(2.22), Feb21_2011, null};
            newControlData.add(new AbstractDIHCacheTestCase.ControlData(newDataRow1));
            newControlData.add(new AbstractDIHCacheTestCase.ControlData(newDataRow2));
            cache.open(TestSortedMapBackedCache.getContext(new HashMap<String, String>()));
            cache.delete((Object)new Integer(1));
            cache.delete((Object)new Integer(3));
            cache.add(this.controlDataToMap(new AbstractDIHCacheTestCase.ControlData(newIdEqualsThree), this.fieldNames, false));
            cache.add(this.controlDataToMap(new AbstractDIHCacheTestCase.ControlData(newDataRow1), this.fieldNames, false));
            cache.add(this.controlDataToMap(new AbstractDIHCacheTestCase.ControlData(newDataRow2), this.fieldNames, false));
            List<AbstractDIHCacheTestCase.ControlData> testData = this.extractDataInKeyOrder((DIHCache)cache, this.fieldNames);
            this.compareData(newControlData, testData);
            cache.close();
            cache.open(TestSortedMapBackedCache.getContext(new HashMap<String, String>()));
            testData = this.extractDataInKeyOrder((DIHCache)cache, this.fieldNames);
            this.compareData(newControlData, testData);
        }
        catch (Exception e) {
            log.warn("Exception thrown: " + e.toString());
            Assert.fail();
        }
        finally {
            try {
                cache.destroy();
            }
            catch (Exception exception) {}
        }
    }
}

