/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import org.apache.solr.handler.dataimport.AbstractSqlEntityProcessorTestCase;
import org.junit.Ignore;
import org.junit.Test;

public class TestSqlEntityProcessor
extends AbstractSqlEntityProcessorTestCase {
    @Test
    public void testSingleEntity() throws Exception {
        this.singleEntity(1);
    }

    @Test
    public void testWithSimpleTransformer() throws Exception {
        this.simpleTransform(1);
    }

    @Test
    public void testWithComplexTransformer() throws Exception {
        this.complexTransform(1, 0);
    }

    @Test
    public void testChildEntities() throws Exception {
        this.withChildEntities(false, true);
    }

    @Test
    public void testCachedChildEntities() throws Exception {
        this.withChildEntities(true, true);
    }

    @Test
    public void testSportZipperChildEntities() throws Exception {
        this.sportsZipper = true;
        this.withChildEntities(true, true);
    }

    @Test
    public void testCountryZipperChildEntities() throws Exception {
        this.countryZipper = true;
        this.withChildEntities(true, true);
    }

    @Test
    public void testBothZipperChildEntities() throws Exception {
        this.countryZipper = true;
        this.sportsZipper = true;
        this.withChildEntities(true, true);
    }

    @Test(expected=RuntimeException.class)
    public void testSportZipperChildEntitiesWrongOrder() throws Exception {
        if (TestSqlEntityProcessor.random().nextBoolean()) {
            this.wrongPeopleOrder = true;
        } else {
            this.wrongSportsOrder = true;
        }
        this.testSportZipperChildEntities();
    }

    @Test(expected=RuntimeException.class)
    public void testCountryZipperChildEntitiesWrongOrder() throws Exception {
        if (TestSqlEntityProcessor.random().nextBoolean()) {
            this.wrongPeopleOrder = true;
        } else {
            this.wrongCountryOrder = true;
        }
        this.testCountryZipperChildEntities();
    }

    @Test(expected=RuntimeException.class)
    public void testBothZipperChildEntitiesWrongOrder() throws Exception {
        if (TestSqlEntityProcessor.random().nextBoolean()) {
            this.wrongPeopleOrder = true;
        } else if (TestSqlEntityProcessor.random().nextBoolean()) {
            this.wrongSportsOrder = true;
        } else {
            this.wrongCountryOrder = true;
        }
        this.testBothZipperChildEntities();
    }

    @Test
    @Ignore(value="broken see SOLR-3857")
    public void testSimpleCacheChildEntities() throws Exception {
        this.simpleCacheChildEntities(true);
    }

    @Override
    protected String deltaQueriesCountryTable() {
        return "";
    }

    @Override
    protected String deltaQueriesPersonTable() {
        return "";
    }
}

