/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.lang.invoke.MethodHandles;
import org.apache.solr.handler.dataimport.AbstractSqlEntityProcessorTestCase;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSqlEntityProcessorDelta
extends AbstractSqlEntityProcessorTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean delta = false;
    private boolean useParentDeltaQueryParam = false;
    private AbstractSqlEntityProcessorTestCase.IntChanges personChanges = null;
    private String[] countryChanges = null;

    @Before
    public void setupDeltaTest() {
        this.delta = false;
        this.personChanges = null;
        this.countryChanges = null;
    }

    @Test
    public void testSingleEntity() throws Exception {
        log.debug("testSingleEntity full-import...");
        this.singleEntity(1);
        this.logPropertiesFile();
        this.changeStuff();
        int c = this.calculateDatabaseCalls();
        log.debug("testSingleEntity delta-import (" + c + " database calls expected)...");
        this.singleEntity(c);
        this.validateChanges();
    }

    @Test
    public void testDeltaImportWithoutInitialFullImport() throws Exception {
        log.debug("testDeltaImportWithoutInitialFullImport delta-import...");
        this.countryEntity = false;
        this.delta = true;
        this.singleEntity(this.totalPeople() + 2);
        this.validateChanges();
    }

    @Test
    public void testWithSimpleTransformer() throws Exception {
        log.debug("testWithSimpleTransformer full-import...");
        this.simpleTransform(1);
        this.logPropertiesFile();
        this.changeStuff();
        int c = this.calculateDatabaseCalls();
        this.simpleTransform(c);
        log.debug("testWithSimpleTransformer delta-import (" + c + " database calls expected)...");
        this.validateChanges();
    }

    @Test
    public void testWithComplexTransformer() throws Exception {
        log.debug("testWithComplexTransformer full-import...");
        this.complexTransform(1, 0);
        this.logPropertiesFile();
        this.changeStuff();
        int c = this.calculateDatabaseCalls();
        log.debug("testWithComplexTransformer delta-import (" + c + " database calls expected)...");
        this.complexTransform(c, this.personChanges.deletedKeys.length);
        this.validateChanges();
    }

    @Test
    public void testChildEntities() throws Exception {
        log.debug("testChildEntities full-import...");
        this.useParentDeltaQueryParam = TestSqlEntityProcessorDelta.random().nextBoolean();
        log.debug("using parent delta? " + this.useParentDeltaQueryParam);
        this.withChildEntities(false, true);
        this.logPropertiesFile();
        this.changeStuff();
        log.debug("testChildEntities delta-import...");
        this.withChildEntities(false, false);
        this.validateChanges();
    }

    private int calculateDatabaseCalls() {
        int c = 1;
        if (this.countryChanges != null) {
            c += this.countryChanges.length + 1;
        }
        if (this.personChanges != null) {
            c += this.personChanges.addedKeys.length + this.personChanges.changedKeys.length + 1;
        }
        return c;
    }

    private void validateChanges() throws Exception {
        if (this.personChanges != null) {
            int id;
            int n;
            Object[] objectArray = this.personChanges.addedKeys;
            int n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                id = (Integer)objectArray[n];
                TestSqlEntityProcessorDelta.assertQ((SolrQueryRequest)TestSqlEntityProcessorDelta.req((String[])new String[]{"id:" + id}), (String[])new String[]{"//*[@numFound='1']"});
            }
            objectArray = this.personChanges.deletedKeys;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                id = (Integer)objectArray[n];
                TestSqlEntityProcessorDelta.assertQ((SolrQueryRequest)TestSqlEntityProcessorDelta.req((String[])new String[]{"id:" + id}), (String[])new String[]{"//*[@numFound='0']"});
            }
            objectArray = this.personChanges.changedKeys;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                id = (Integer)objectArray[n];
                TestSqlEntityProcessorDelta.assertQ((SolrQueryRequest)TestSqlEntityProcessorDelta.req((String[])new String[]{"id:" + id}), (String[])new String[]{"//*[@numFound='1']", "substring(//doc/arr[@name='NAME_mult_s']/str[1], 1, 8)='MODIFIED'"});
            }
        }
        if (this.countryChanges != null) {
            for (String code : this.countryChanges) {
                TestSqlEntityProcessorDelta.assertQ((SolrQueryRequest)TestSqlEntityProcessorDelta.req((String[])new String[]{"COUNTRY_CODE_s:" + (String)code}), (String[])new String[]{"//*[@numFound='" + this.numberPeopleByCountryCode(code) + "']", "substring((//doc/str[@name='COUNTRY_NAME_s'])[1], 1, 8)='MODIFIED'"});
            }
        }
    }

    private void changeStuff() throws Exception {
        if (this.countryEntity) {
            int n = TestSqlEntityProcessorDelta.random().nextInt(2);
            switch (n) {
                case 0: {
                    this.personChanges = this.modifySomePeople();
                    break;
                }
                case 1: {
                    this.countryChanges = this.modifySomeCountries();
                    break;
                }
                case 2: {
                    this.personChanges = this.modifySomePeople();
                    this.countryChanges = this.modifySomeCountries();
                }
            }
        } else {
            this.personChanges = this.modifySomePeople();
        }
        this.countryChangesLog();
        this.personChangesLog();
        this.delta = true;
    }

    private void countryChangesLog() {
        if (this.countryChanges != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("country changes { ");
            for (String s : this.countryChanges) {
                sb.append(s).append(" ");
            }
            sb.append(" }");
            log.debug(sb.toString());
        }
    }

    private void personChangesLog() {
        if (this.personChanges != null) {
            log.debug("person changes { " + this.personChanges.toString() + " } ");
        }
    }

    @Override
    protected LocalSolrQueryRequest generateRequest() {
        return lrf.makeRequest(new String[]{"command", this.delta ? "delta-import" : "full-import", "dataConfig", this.generateConfig(), "clean", this.delta ? "false" : "true", "commit", "true", "synchronous", "true", "indent", "true"});
    }

    @Override
    protected String deltaQueriesPersonTable() {
        return "deletedPkQuery=''SELECT ID FROM PEOPLE WHERE DELETED='Y' AND last_modified &gt;='${dih.People.last_index_time}' '' deltaImportQuery=''SELECT ID, NAME, COUNTRY_CODE FROM PEOPLE where ID=${dih.delta.ID} '' deltaQuery=''SELECT ID FROM PEOPLE WHERE DELETED!='Y' AND last_modified &gt;='${dih.People.last_index_time}' " + (this.useParentDeltaQueryParam ? "" : "UNION DISTINCT SELECT ID FROM PEOPLE WHERE DELETED!='Y' AND COUNTRY_CODE IN (SELECT CODE FROM COUNTRIES WHERE last_modified &gt;='${dih.People.last_index_time}') ") + "'' ";
    }

    @Override
    protected String deltaQueriesCountryTable() {
        if (this.useParentDeltaQueryParam) {
            return "deltaQuery=''SELECT CODE FROM COUNTRIES WHERE DELETED != 'Y' AND last_modified &gt;='${dih.last_index_time}' ''  parentDeltaQuery=''SELECT ID FROM PEOPLE WHERE DELETED != 'Y' AND COUNTRY_CODE='${Countries.CODE}' '' ";
        }
        return "";
    }
}

