/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.TemplateTransformer;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.junit.Test;

public class TestTemplateTransformer
extends AbstractDataImportHandlerTestCase {
    @Test
    public void testTransformRow() {
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        fields.add(TestTemplateTransformer.createMap("column", "firstName"));
        fields.add(TestTemplateTransformer.createMap("column", "lastName"));
        fields.add(TestTemplateTransformer.createMap("column", "middleName"));
        fields.add(TestTemplateTransformer.createMap("column", "name", "template", "${e.lastName}, ${e.firstName} ${e.middleName}"));
        fields.add(TestTemplateTransformer.createMap("column", "emails", "template", "${e.mail}"));
        fields.add(TestTemplateTransformer.createMap("column", "mrname", "template", "Mr ${e.name}"));
        List<String> mails = Arrays.asList("a@b.com", "c@d.com");
        Map row = TestTemplateTransformer.createMap("firstName", "Shalin", "middleName", "Shekhar", "lastName", "Mangar", "mail", mails);
        VariableResolver resolver = new VariableResolver();
        resolver.addNamespace("e", row);
        Map entityAttrs = TestTemplateTransformer.createMap("name", "e");
        AbstractDataImportHandlerTestCase.TestContext context = TestTemplateTransformer.getContext(null, resolver, null, "FULL_DUMP", fields, entityAttrs);
        new TemplateTransformer().transformRow(row, (Context)context);
        TestTemplateTransformer.assertEquals((Object)"Mangar, Shalin Shekhar", row.get("name"));
        TestTemplateTransformer.assertEquals((Object)"Mr Mangar, Shalin Shekhar", row.get("mrname"));
        TestTemplateTransformer.assertEquals(mails, row.get("emails"));
    }

    @Test
    public void testTransformRowMultiValue() {
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        fields.add(TestTemplateTransformer.createMap("column", "year"));
        fields.add(TestTemplateTransformer.createMap("column", "month"));
        fields.add(TestTemplateTransformer.createMap("column", "day"));
        fields.add(TestTemplateTransformer.createMap("column", "date", "template", "${e.day} ${e.month}, ${e.year}"));
        fields.add(TestTemplateTransformer.createMap("column", "date", "template", "${e.month} ${e.day}, ${e.year}"));
        fields.add(TestTemplateTransformer.createMap("column", "date", "template", "${e.year}-${e.month}-${e.day}"));
        Map row = TestTemplateTransformer.createMap("year", "2016", "month", "Apr", "day", "30");
        VariableResolver resolver = new VariableResolver();
        resolver.addNamespace("e", row);
        Map entityAttrs = TestTemplateTransformer.createMap("date", "e");
        AbstractDataImportHandlerTestCase.TestContext context = TestTemplateTransformer.getContext(null, resolver, null, "FULL_DUMP", fields, entityAttrs);
        new TemplateTransformer().transformRow(row, (Context)context);
        TestTemplateTransformer.assertTrue((boolean)(row.get("date") instanceof List));
        List dates = (List)row.get("date");
        TestTemplateTransformer.assertEquals((long)dates.size(), (long)3L);
        TestTemplateTransformer.assertEquals((Object)dates.get(0).toString(), (Object)"30 Apr, 2016");
        TestTemplateTransformer.assertEquals((Object)dates.get(1).toString(), (Object)"Apr 30, 2016");
        TestTemplateTransformer.assertEquals((Object)dates.get(2).toString(), (Object)"2016-Apr-30");
    }
}

