/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.ContextImpl;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.Evaluator;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.apache.solr.util.DateMathParser;
import org.junit.Test;

public class TestVariableResolver
extends AbstractDataImportHandlerTestCase {
    @Test
    public void testSimpleNamespace() {
        VariableResolver vri = new VariableResolver();
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("world", "WORLD");
        vri.addNamespace("hello", ns);
        TestVariableResolver.assertEquals((Object)"WORLD", (Object)vri.resolve("hello.world"));
    }

    @Test
    public void testDefaults() {
        System.setProperty(TestVariableResolver.class.getName(), "hello");
        Properties p = new Properties();
        p.put("hello", "world");
        VariableResolver vri = new VariableResolver(p);
        Object val = vri.resolve(TestVariableResolver.class.getName());
        TestVariableResolver.assertEquals((Object)"hello", (Object)val);
        TestVariableResolver.assertEquals((Object)"world", (Object)vri.resolve("hello"));
    }

    @Test
    public void testNestedNamespace() {
        VariableResolver vri = new VariableResolver();
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("world", "WORLD");
        vri.addNamespace("hello", ns);
        ns = new HashMap();
        ns.put("world1", "WORLD1");
        vri.addNamespace("hello.my", ns);
        TestVariableResolver.assertEquals((Object)"WORLD1", (Object)vri.resolve("hello.my.world1"));
    }

    @Test
    public void test3LevelNestedNamespace() {
        VariableResolver vri = new VariableResolver();
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("world", "WORLD");
        vri.addNamespace("hello", ns);
        ns = new HashMap();
        ns.put("world1", "WORLD1");
        vri.addNamespace("hello.my.new", ns);
        TestVariableResolver.assertEquals((Object)"WORLD1", (Object)vri.resolve("hello.my.new.world1"));
    }

    @Test
    public void dateNamespaceWithValue() {
        VariableResolver vri = new VariableResolver();
        vri.setEvaluators(new DataImporter().getEvaluators(Collections.emptyList()));
        HashMap<String, Date> ns = new HashMap<String, Date>();
        Date d = new Date();
        ns.put("dt", d);
        vri.addNamespace("A", ns);
        TestVariableResolver.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ROOT).format(d), (Object)vri.replaceTokens("${dataimporter.functions.formatDate(A.dt,'yyyy-MM-dd HH:mm:ss')}"));
    }

    @Test
    public void dateNamespaceWithExpr() throws Exception {
        VariableResolver vri = new VariableResolver();
        vri.setEvaluators(new DataImporter().getEvaluators(Collections.emptyList()));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        DateMathParser dmp = new DateMathParser(TimeZone.getDefault());
        String s = vri.replaceTokens("${dataimporter.functions.formatDate('NOW/DAY','yyyy-MM-dd HH:mm')}");
        TestVariableResolver.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.ROOT).format(dmp.parseMath("/DAY")), (Object)s);
    }

    @Test
    public void testDefaultNamespace() {
        VariableResolver vri = new VariableResolver();
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("world", "WORLD");
        vri.addNamespace(null, ns);
        TestVariableResolver.assertEquals((Object)"WORLD", (Object)vri.resolve("world"));
    }

    @Test
    public void testDefaultNamespace1() {
        VariableResolver vri = new VariableResolver();
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("world", "WORLD");
        vri.addNamespace(null, ns);
        TestVariableResolver.assertEquals((Object)"WORLD", (Object)vri.resolve("world"));
    }

    @Test
    public void testFunctionNamespace1() throws Exception {
        VariableResolver resolver = new VariableResolver();
        ArrayList l = new ArrayList();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("name", "test");
        m.put("class", E.class.getName());
        l.add(m);
        resolver.setEvaluators(new DataImporter().getEvaluators(l));
        ContextImpl context = new ContextImpl(null, resolver, null, "FULL_DUMP", Collections.EMPTY_MAP, null, null);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        DateMathParser dmp = new DateMathParser(TimeZone.getDefault());
        String s = resolver.replaceTokens("${dataimporter.functions.formatDate('NOW/DAY','yyyy-MM-dd HH:mm')}");
        TestVariableResolver.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.ROOT).format(dmp.parseMath("/DAY")), (Object)s);
        TestVariableResolver.assertEquals((Object)"Hello World", (Object)resolver.replaceTokens("${dataimporter.functions.test('TEST')}"));
    }

    public static class E
    extends Evaluator {
        public String evaluate(String expression, Context context) {
            return "Hello World";
        }
    }
}

