/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.apache.solr.handler.dataimport.AbstractDIHJdbcTestCase;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestVariableResolverEndToEnd
extends AbstractDIHJdbcTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void test() throws Exception {
        h.query("/dataimport", (SolrQueryRequest)this.generateRequest());
        try (SolrQueryRequest req = null;){
            req = TestVariableResolverEndToEnd.req((String[])new String[]{"q", "*:*", "wt", "json", "indent", "true"});
            String response = h.query(req);
            log.debug(response);
            response = response.replaceAll("\\s", "");
            Assert.assertTrue((boolean)response.contains("\"numFound\":1"));
            Pattern p = Pattern.compile("[\"]second1_s[\"][:][\"](.*?)[\"]");
            Matcher m = p.matcher(response);
            Assert.assertTrue((boolean)m.find());
            String yearStr = m.group(1);
            Assert.assertTrue((boolean)response.contains("\"second1_s\":\"" + yearStr + "\""));
            Assert.assertTrue((boolean)response.contains("\"second2_s\":\"" + yearStr + "\""));
            Assert.assertTrue((boolean)response.contains("\"second3_s\":\"" + yearStr + "\""));
            Assert.assertTrue((boolean)response.contains("\"PORK_s\":\"GRILL\""));
            Assert.assertTrue((boolean)response.contains("\"FISH_s\":\"FRY\""));
            Assert.assertTrue((boolean)response.contains("\"BEEF_CUTS_mult_s\":[\"ROUND\",\"SIRLOIN\"]"));
        }
    }

    @Override
    protected String generateConfig() {
        String thirdLocaleParam = TestVariableResolverEndToEnd.random().nextBoolean() ? "" : ", '" + Locale.getDefault().toLanguageTag() + "'";
        StringBuilder sb = new StringBuilder();
        sb.append("<dataConfig> \n");
        sb.append("<dataSource name=\"hsqldb\" driver=\"${dataimporter.request.dots.in.hsqldb.driver}\" url=\"jdbc:hsqldb:mem:.\" /> \n");
        sb.append("<document name=\"TestEvaluators\"> \n");
        sb.append("<entity name=\"FIRST\" processor=\"SqlEntityProcessor\" dataSource=\"hsqldb\" ");
        sb.append(" query=\"select  1 as id,  'SELECT' as SELECT_KEYWORD,  CURRENT_TIMESTAMP as FIRST_TS from DUAL \" >\n");
        sb.append("  <field column=\"SELECT_KEYWORD\" name=\"select_keyword_s\" /> \n");
        sb.append("  <entity name=\"SECOND\" processor=\"SqlEntityProcessor\" dataSource=\"hsqldb\" transformer=\"TemplateTransformer\" ");
        sb.append("   query=\"${dataimporter.functions.encodeUrl(FIRST.SELECT_KEYWORD)}  1 as SORT,  CURRENT_TIMESTAMP as SECOND_TS,  '${dataimporter.functions.formatDate(FIRST.FIRST_TS, 'yyyy'" + thirdLocaleParam + ")}' as SECOND1_S,   'PORK' AS MEAT,  'GRILL' AS METHOD,  'ROUND' AS CUTS,  'BEEF_CUTS' AS WHATKIND from DUAL WHERE 1=${FIRST.ID} UNION ${dataimporter.functions.encodeUrl(FIRST.SELECT_KEYWORD)}  2 as SORT,  CURRENT_TIMESTAMP as SECOND_TS,  '${dataimporter.functions.formatDate(FIRST.FIRST_TS, 'yyyy'" + thirdLocaleParam + ")}' as SECOND1_S,   'FISH' AS MEAT,  'FRY' AS METHOD,  'SIRLOIN' AS CUTS,  'BEEF_CUTS' AS WHATKIND from DUAL WHERE 1=${FIRST.ID} ORDER BY SORT \">\n");
        sb.append("   <field column=\"SECOND_S\" name=\"second_s\" /> \n");
        sb.append("   <field column=\"SECOND1_S\" name=\"second1_s\" /> \n");
        sb.append("   <field column=\"second2_s\" template=\"${dataimporter.functions.formatDate(SECOND.SECOND_TS, 'yyyy'" + thirdLocaleParam + ")}\" /> \n");
        sb.append("   <field column=\"second3_s\" template=\"${dih.functions.formatDate(SECOND.SECOND_TS, 'yyyy'" + thirdLocaleParam + ")}\" /> \n");
        sb.append("   <field column=\"METHOD\" name=\"${SECOND.MEAT}_s\"/>\n");
        sb.append("   <field column=\"CUTS\" name=\"${SECOND.WHATKIND}_mult_s\"/>\n");
        sb.append("  </entity>\n");
        sb.append("</entity>\n");
        sb.append("</document> \n");
        sb.append("</dataConfig> \n");
        String config = sb.toString();
        log.debug(config);
        return config;
    }

    @Override
    protected void populateData(Connection conn) throws Exception {
        Statement s = null;
        try {
            s = conn.createStatement();
            s.executeUpdate("create table dual(dual char(1) not null)");
            s.executeUpdate("insert into dual values('Y')");
            conn.commit();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                s.close();
            }
            catch (Exception exception) {}
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected AbstractDIHJdbcTestCase.Database setAllowedDatabases() {
        return AbstractDIHJdbcTestCase.Database.HSQLDB;
    }
}

