/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.ArrayList;
import java.util.Map;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.MockDataSource;
import org.apache.solr.handler.dataimport.SolrWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestWriterImpl
extends AbstractDataImportHandlerTestCase {
    @BeforeClass
    public static void beforeClass() throws Exception {
        TestWriterImpl.initCore("dataimport-nodatasource-solrconfig.xml", "dataimport-schema.xml");
    }

    @Test
    public void testDataConfigWithDataSource() throws Exception {
        ArrayList<Map> rows = new ArrayList<Map>();
        rows.add(TestWriterImpl.createMap("id", "1", "desc", "one"));
        rows.add(TestWriterImpl.createMap("id", "2", "desc", "two"));
        rows.add(TestWriterImpl.createMap("id", "3", "desc", "break"));
        rows.add(TestWriterImpl.createMap("id", "4", "desc", "four"));
        MockDataSource.setIterator((String)"select * from x", rows.iterator());
        Map extraParams = TestWriterImpl.createMap("writerImpl", TestSolrWriter.class.getName(), "commit", "true");
        this.runFullImport(this.loadDataConfig("data-config-with-datasource.xml"), extraParams);
        TestWriterImpl.assertQ((SolrQueryRequest)TestWriterImpl.req((String[])new String[]{"id:1"}), (String[])new String[]{"//*[@numFound='1']"});
        TestWriterImpl.assertQ((SolrQueryRequest)TestWriterImpl.req((String[])new String[]{"id:2"}), (String[])new String[]{"//*[@numFound='1']"});
        TestWriterImpl.assertQ((SolrQueryRequest)TestWriterImpl.req((String[])new String[]{"id:3"}), (String[])new String[]{"//*[@numFound='0']"});
        TestWriterImpl.assertQ((SolrQueryRequest)TestWriterImpl.req((String[])new String[]{"id:4"}), (String[])new String[]{"//*[@numFound='1']"});
    }

    public static class TestSolrWriter
    extends SolrWriter {
        public TestSolrWriter(UpdateRequestProcessor processor, SolrQueryRequest req) {
            super(processor, req);
        }

        public boolean upload(SolrInputDocument doc) {
            if (doc.getField("desc").getFirstValue().equals("break")) {
                return false;
            }
            return super.upload(doc);
        }
    }
}

