/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.apache.solr.handler.dataimport.XPathEntityProcessor;
import org.junit.Test;

public class TestXPathEntityProcessor
extends AbstractDataImportHandlerTestCase {
    boolean simulateSlowReader;
    boolean simulateSlowResultProcessor;
    int rowsToRead = -1;
    private static final String xsl = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsl:stylesheet version=\"1.0\"\nxmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n<xsl:output version='1.0' method='xml' encoding='UTF-8' indent='yes'/>\n\n<xsl:template match=\"/\">\n  <add> \n      <xsl:for-each select=\"catalog/cd\">\n      <doc>\n      <field name=\"title\"><xsl:value-of select=\"title\"/></field>\n      <field name=\"artist\"><xsl:value-of select=\"artist\"/></field>\n      <field name=\"country\"><xsl:value-of select=\"country\"/></field>\n      <field name=\"company\"><xsl:value-of select=\"company\"/></field>      \n      <field name=\"price\"><xsl:value-of select=\"price\"/></field>\n      <field name=\"year\"><xsl:value-of select=\"year\"/></field>      \n      </doc>\n      </xsl:for-each>\n    </add>  \n</xsl:template>\n</xsl:stylesheet>";
    private static final String cdData = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?xml-stylesheet type=\"text/xsl\" href=\"solr.xsl\"?>\n<catalog>\n\t<cd>\n\t\t<title>Empire Burlesque</title>\n\t\t<artist>Bob Dylan</artist>\n\t\t<country>USA</country>\n\t\t<company>Columbia</company>\n\t\t<price>10.90</price>\n\t\t<year>1985</year>\n\t</cd>\n\t<cd>\n\t\t<title>Hide your heart</title>\n\t\t<artist>Bonnie Tyler</artist>\n\t\t<country>UK</country>\n\t\t<company>CBS Records</company>\n\t\t<price>9.90</price>\n\t\t<year>1988</year>\n\t</cd>\n\t<cd>\n\t\t<title>Greatest Hits</title>\n\t\t<artist>Dolly Parton</artist>\n\t\t<country>USA</country>\n\t\t<company>RCA</company>\n\t\t<price>9.90</price>\n\t\t<year>1982</year>\n\t</cd>\n</catalog>\t";
    private static final String testXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE root [\n<!ENTITY uuml \"&#252;\" >\n]>\n<root><a>1</a><a>2</a><a>&uuml;</a></root>";
    private static final String testXmlFlatten = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><a>1<b>B</b>2</a></root>";
    private static final String textMultipleDocuments = "<?xml version=\"1.0\" ?><documents> <doc>  <id>1</id>  <a>id1-a1</a>  <a>id1-a2</a>  <sec1>   <s1dataA>id1-s1dataA-1</s1dataA>   <s1dataB>id1-s1dataB-1</s1dataB>  </sec1>  <sec1>   <s1dataB>id1-s1dataB-2</s1dataB>  </sec1>  <sec1>   <s1dataA>id1-s1dataA-3</s1dataA>   <s1dataB>id1-s1dataB-3</s1dataB>  </sec1> </doc> <doc>  <id>2</id>  <sec1>   <s1dataB>id2-s1dataB-1</s1dataB>  </sec1> </doc> <doc>  <id>3</id>  <sec1>   <s1dataA>id3-s1dataA-1</s1dataA>  </sec1> </doc> <doc>  <id>4</id>  <sec1>   <s1dataA>id4-s1dataA-1</s1dataA>   <s1dataB>id4-s1dataB-1</s1dataB>   <s1dataC>id4-s1dataC-1</s1dataC>  </sec1> </doc> <doc>  <id>5</id>  <sec1>   <s1dataC>id5-s1dataC-1</s1dataC>  </sec1> </doc> <doc>  <id>6</id>  <sec1>   <s1dataA>id6-s1dataA-1</s1dataA>   <s1dataB>id6-s1dataB-1</s1dataB>   <s1dataC>id6-s1dataC-1</s1dataC>  </sec1>  <sec1>   <s1dataA>id6-s1dataA-2</s1dataA>   <s1dataB>id6-s1dataB-2</s1dataB>  </sec1>  <sec1>   <s1dataB>id6-s1dataB-3</s1dataB>   <s1dataC>id6-s1dataC-3</s1dataC>  </sec1> </doc></documents>";

    @Test
    public void withFieldsAndXpath() throws Exception {
        Map row;
        File tmpdir = TestXPathEntityProcessor.createTempDir().toFile();
        TestXPathEntityProcessor.createFile(tmpdir, "x.xsl", xsl.getBytes(StandardCharsets.UTF_8), false);
        Map entityAttrs = TestXPathEntityProcessor.createMap("name", "e", "url", "cd.xml", "forEach", "/catalog/cd");
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        fields.add(TestXPathEntityProcessor.createMap("column", "title", "xpath", "/catalog/cd/title"));
        fields.add(TestXPathEntityProcessor.createMap("column", "artist", "xpath", "/catalog/cd/artist"));
        fields.add(TestXPathEntityProcessor.createMap("column", "year", "xpath", "/catalog/cd/year"));
        AbstractDataImportHandlerTestCase.TestContext c = TestXPathEntityProcessor.getContext(null, new VariableResolver(), this.getDataSource(cdData), "FULL_DUMP", fields, entityAttrs);
        XPathEntityProcessor xPathEntityProcessor = new XPathEntityProcessor();
        xPathEntityProcessor.init((Context)c);
        ArrayList<Map> result = new ArrayList<Map>();
        while ((row = xPathEntityProcessor.nextRow()) != null) {
            result.add(row);
        }
        TestXPathEntityProcessor.assertEquals((long)3L, (long)result.size());
        TestXPathEntityProcessor.assertEquals((Object)"Empire Burlesque", ((Map)result.get(0)).get("title"));
        TestXPathEntityProcessor.assertEquals((Object)"Bonnie Tyler", ((Map)result.get(1)).get("artist"));
        TestXPathEntityProcessor.assertEquals((Object)"1982", ((Map)result.get(2)).get("year"));
    }

    @Test
    public void testMultiValued() throws Exception {
        Map row;
        Map entityAttrs = TestXPathEntityProcessor.createMap("name", "e", "url", "testdata.xml", "forEach", "/root");
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        fields.add(TestXPathEntityProcessor.createMap("column", "a", "xpath", "/root/a", "multiValued", "true"));
        AbstractDataImportHandlerTestCase.TestContext c = TestXPathEntityProcessor.getContext(null, new VariableResolver(), this.getDataSource(testXml), "FULL_DUMP", fields, entityAttrs);
        XPathEntityProcessor xPathEntityProcessor = new XPathEntityProcessor();
        xPathEntityProcessor.init((Context)c);
        ArrayList<Map> result = new ArrayList<Map>();
        while ((row = xPathEntityProcessor.nextRow()) != null) {
            result.add(row);
        }
        List l = (List)((Map)result.get(0)).get("a");
        TestXPathEntityProcessor.assertEquals((long)3L, (long)l.size());
        TestXPathEntityProcessor.assertEquals((Object)"1", l.get(0));
        TestXPathEntityProcessor.assertEquals((Object)"2", l.get(1));
        TestXPathEntityProcessor.assertEquals((Object)"\u00fc", l.get(2));
    }

    @Test
    public void testMultiValuedWithMultipleDocuments() throws Exception {
        Map row;
        Map entityAttrs = TestXPathEntityProcessor.createMap("name", "e", "url", "testdata.xml", "forEach", "/documents/doc");
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        fields.add(TestXPathEntityProcessor.createMap("column", "id", "xpath", "/documents/doc/id", "multiValued", "false"));
        fields.add(TestXPathEntityProcessor.createMap("column", "a", "xpath", "/documents/doc/a", "multiValued", "true"));
        fields.add(TestXPathEntityProcessor.createMap("column", "s1dataA", "xpath", "/documents/doc/sec1/s1dataA", "multiValued", "true"));
        fields.add(TestXPathEntityProcessor.createMap("column", "s1dataB", "xpath", "/documents/doc/sec1/s1dataB", "multiValued", "true"));
        fields.add(TestXPathEntityProcessor.createMap("column", "s1dataC", "xpath", "/documents/doc/sec1/s1dataC", "multiValued", "true"));
        AbstractDataImportHandlerTestCase.TestContext c = TestXPathEntityProcessor.getContext(null, new VariableResolver(), this.getDataSource(textMultipleDocuments), "FULL_DUMP", fields, entityAttrs);
        XPathEntityProcessor xPathEntityProcessor = new XPathEntityProcessor();
        xPathEntityProcessor.init((Context)c);
        ArrayList<Map> result = new ArrayList<Map>();
        while ((row = xPathEntityProcessor.nextRow()) != null) {
            result.add(row);
        }
        TestXPathEntityProcessor.assertEquals((Object)"1", ((Map)result.get(0)).get("id"));
        List a = (List)((Map)result.get(0)).get("a");
        List s1dataA = (List)((Map)result.get(0)).get("s1dataA");
        List s1dataB = (List)((Map)result.get(0)).get("s1dataB");
        List s1dataC = (List)((Map)result.get(0)).get("s1dataC");
        TestXPathEntityProcessor.assertEquals((long)2L, (long)a.size());
        TestXPathEntityProcessor.assertEquals((Object)"id1-a1", a.get(0));
        TestXPathEntityProcessor.assertEquals((Object)"id1-a2", a.get(1));
        TestXPathEntityProcessor.assertEquals((long)3L, (long)s1dataA.size());
        TestXPathEntityProcessor.assertEquals((Object)"id1-s1dataA-1", s1dataA.get(0));
        TestXPathEntityProcessor.assertNull(s1dataA.get(1));
        TestXPathEntityProcessor.assertEquals((Object)"id1-s1dataA-3", s1dataA.get(2));
        TestXPathEntityProcessor.assertEquals((long)3L, (long)s1dataB.size());
        TestXPathEntityProcessor.assertEquals((Object)"id1-s1dataB-1", s1dataB.get(0));
        TestXPathEntityProcessor.assertEquals((Object)"id1-s1dataB-2", s1dataB.get(1));
        TestXPathEntityProcessor.assertEquals((Object)"id1-s1dataB-3", s1dataB.get(2));
        TestXPathEntityProcessor.assertEquals((long)3L, (long)s1dataC.size());
        TestXPathEntityProcessor.assertNull(s1dataC.get(0));
        TestXPathEntityProcessor.assertNull(s1dataC.get(1));
        TestXPathEntityProcessor.assertNull(s1dataC.get(2));
        TestXPathEntityProcessor.assertEquals((Object)"2", ((Map)result.get(1)).get("id"));
        a = (List)((Map)result.get(1)).get("a");
        s1dataA = (List)((Map)result.get(1)).get("s1dataA");
        s1dataB = (List)((Map)result.get(1)).get("s1dataB");
        s1dataC = (List)((Map)result.get(1)).get("s1dataC");
        TestXPathEntityProcessor.assertTrue((a == null || a.size() == 0 ? 1 : 0) != 0);
        TestXPathEntityProcessor.assertEquals((long)1L, (long)s1dataA.size());
        TestXPathEntityProcessor.assertNull(s1dataA.get(0));
        TestXPathEntityProcessor.assertEquals((long)1L, (long)s1dataB.size());
        TestXPathEntityProcessor.assertEquals((Object)"id2-s1dataB-1", s1dataB.get(0));
        TestXPathEntityProcessor.assertEquals((long)1L, (long)s1dataC.size());
        TestXPathEntityProcessor.assertNull(s1dataC.get(0));
        TestXPathEntityProcessor.assertEquals((Object)"3", ((Map)result.get(2)).get("id"));
        a = (List)((Map)result.get(2)).get("a");
        s1dataA = (List)((Map)result.get(2)).get("s1dataA");
        s1dataB = (List)((Map)result.get(2)).get("s1dataB");
        s1dataC = (List)((Map)result.get(2)).get("s1dataC");
        TestXPathEntityProcessor.assertTrue((a == null || a.size() == 0 ? 1 : 0) != 0);
        TestXPathEntityProcessor.assertEquals((long)1L, (long)s1dataA.size());
        TestXPathEntityProcessor.assertEquals((Object)"id3-s1dataA-1", s1dataA.get(0));
        TestXPathEntityProcessor.assertEquals((long)1L, (long)s1dataB.size());
        TestXPathEntityProcessor.assertNull(s1dataB.get(0));
        TestXPathEntityProcessor.assertEquals((long)1L, (long)s1dataC.size());
        TestXPathEntityProcessor.assertNull(s1dataC.get(0));
        TestXPathEntityProcessor.assertEquals((Object)"4", ((Map)result.get(3)).get("id"));
        a = (List)((Map)result.get(3)).get("a");
        s1dataA = (List)((Map)result.get(3)).get("s1dataA");
        s1dataB = (List)((Map)result.get(3)).get("s1dataB");
        s1dataC = (List)((Map)result.get(3)).get("s1dataC");
        TestXPathEntityProcessor.assertTrue((a == null || a.size() == 0 ? 1 : 0) != 0);
        TestXPathEntityProcessor.assertEquals((long)1L, (long)s1dataA.size());
        TestXPathEntityProcessor.assertEquals((Object)"id4-s1dataA-1", s1dataA.get(0));
        TestXPathEntityProcessor.assertEquals((long)1L, (long)s1dataB.size());
        TestXPathEntityProcessor.assertEquals((Object)"id4-s1dataB-1", s1dataB.get(0));
        TestXPathEntityProcessor.assertEquals((long)1L, (long)s1dataC.size());
        TestXPathEntityProcessor.assertEquals((Object)"id4-s1dataC-1", s1dataC.get(0));
        TestXPathEntityProcessor.assertEquals((Object)"5", ((Map)result.get(4)).get("id"));
        a = (List)((Map)result.get(4)).get("a");
        s1dataA = (List)((Map)result.get(4)).get("s1dataA");
        s1dataB = (List)((Map)result.get(4)).get("s1dataB");
        s1dataC = (List)((Map)result.get(4)).get("s1dataC");
        TestXPathEntityProcessor.assertTrue((a == null || a.size() == 0 ? 1 : 0) != 0);
        TestXPathEntityProcessor.assertEquals((long)1L, (long)s1dataA.size());
        TestXPathEntityProcessor.assertNull(s1dataA.get(0));
        TestXPathEntityProcessor.assertEquals((long)1L, (long)s1dataB.size());
        TestXPathEntityProcessor.assertNull(s1dataB.get(0));
        TestXPathEntityProcessor.assertEquals((long)1L, (long)s1dataC.size());
        TestXPathEntityProcessor.assertEquals((Object)"id5-s1dataC-1", s1dataC.get(0));
        TestXPathEntityProcessor.assertEquals((Object)"6", ((Map)result.get(5)).get("id"));
        a = (List)((Map)result.get(5)).get("a");
        s1dataA = (List)((Map)result.get(5)).get("s1dataA");
        s1dataB = (List)((Map)result.get(5)).get("s1dataB");
        s1dataC = (List)((Map)result.get(5)).get("s1dataC");
        TestXPathEntityProcessor.assertTrue((a == null || a.size() == 0 ? 1 : 0) != 0);
        TestXPathEntityProcessor.assertEquals((long)3L, (long)s1dataA.size());
        TestXPathEntityProcessor.assertEquals((Object)"id6-s1dataA-1", s1dataA.get(0));
        TestXPathEntityProcessor.assertEquals((Object)"id6-s1dataA-2", s1dataA.get(1));
        TestXPathEntityProcessor.assertNull(s1dataA.get(2));
        TestXPathEntityProcessor.assertEquals((long)3L, (long)s1dataB.size());
        TestXPathEntityProcessor.assertEquals((Object)"id6-s1dataB-1", s1dataB.get(0));
        TestXPathEntityProcessor.assertEquals((Object)"id6-s1dataB-2", s1dataB.get(1));
        TestXPathEntityProcessor.assertEquals((Object)"id6-s1dataB-3", s1dataB.get(2));
        TestXPathEntityProcessor.assertEquals((long)3L, (long)s1dataC.size());
        TestXPathEntityProcessor.assertEquals((Object)"id6-s1dataC-1", s1dataC.get(0));
        TestXPathEntityProcessor.assertNull(s1dataC.get(1));
        TestXPathEntityProcessor.assertEquals((Object)"id6-s1dataC-3", s1dataC.get(2));
    }

    @Test
    public void testMultiValuedFlatten() throws Exception {
        Map row;
        Map entityAttrs = TestXPathEntityProcessor.createMap("name", "e", "url", "testdata.xml", "forEach", "/root");
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        fields.add(TestXPathEntityProcessor.createMap("column", "a", "xpath", "/root/a", "flatten", "true"));
        AbstractDataImportHandlerTestCase.TestContext c = TestXPathEntityProcessor.getContext(null, new VariableResolver(), this.getDataSource(testXmlFlatten), "FULL_DUMP", fields, entityAttrs);
        XPathEntityProcessor xPathEntityProcessor = new XPathEntityProcessor();
        xPathEntityProcessor.init((Context)c);
        Map result = null;
        while ((row = xPathEntityProcessor.nextRow()) != null) {
            result = row;
        }
        TestXPathEntityProcessor.assertEquals((Object)"1B2", result.get("a"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void withFieldsAndXpathStream() throws Exception {
        final Object monitor = new Object();
        final boolean[] done = new boolean[1];
        Map entityAttrs = TestXPathEntityProcessor.createMap("name", "e", "url", "cd.xml", "forEach", "/catalog/cd", "stream", "true", "batchSize", "1");
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        fields.add(TestXPathEntityProcessor.createMap("column", "title", "xpath", "/catalog/cd/title"));
        fields.add(TestXPathEntityProcessor.createMap("column", "artist", "xpath", "/catalog/cd/artist"));
        fields.add(TestXPathEntityProcessor.createMap("column", "year", "xpath", "/catalog/cd/year"));
        AbstractDataImportHandlerTestCase.TestContext c = TestXPathEntityProcessor.getContext(null, new VariableResolver(), this.getDataSource(cdData), "FULL_DUMP", fields, entityAttrs);
        XPathEntityProcessor xPathEntityProcessor = new XPathEntityProcessor(){
            private int count;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Map<String, Object> readRow(Map<String, Object> record, String xpath) {
                Object object = monitor;
                synchronized (object) {
                    if (TestXPathEntityProcessor.this.simulateSlowReader && !done[0]) {
                        try {
                            monitor.wait(100L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                return super.readRow(record, xpath);
            }
        };
        if (this.simulateSlowResultProcessor) {
            xPathEntityProcessor.blockingQueueSize = 1;
        }
        xPathEntityProcessor.blockingQueueTimeOut = 1;
        xPathEntityProcessor.blockingQueueTimeOutUnits = TimeUnit.MICROSECONDS;
        xPathEntityProcessor.init((Context)c);
        ArrayList<Map> result = new ArrayList<Map>();
        while (true) {
            Map row;
            if (this.rowsToRead >= 0 && result.size() >= this.rowsToRead) {
                Thread.currentThread().interrupt();
            }
            if ((row = xPathEntityProcessor.nextRow()) == null) break;
            result.add(row);
            if (!this.simulateSlowResultProcessor) continue;
            Thread thread = xPathEntityProcessor.publisherThread;
            synchronized (thread) {
                if (xPathEntityProcessor.publisherThread.isAlive()) {
                    xPathEntityProcessor.publisherThread.wait(1000L);
                }
            }
        }
        Object object = monitor;
        synchronized (object) {
            done[0] = true;
            monitor.notify();
        }
        xPathEntityProcessor.publisherThread.join(1000L);
        TestXPathEntityProcessor.assertEquals((String)"Expected thread to stop", (Object)false, (Object)xPathEntityProcessor.publisherThread.isAlive());
        TestXPathEntityProcessor.assertEquals((long)(this.rowsToRead < 0 ? 3L : (long)this.rowsToRead), (long)result.size());
        if (this.rowsToRead < 0) {
            TestXPathEntityProcessor.assertEquals((Object)"Empire Burlesque", ((Map)result.get(0)).get("title"));
            TestXPathEntityProcessor.assertEquals((Object)"Bonnie Tyler", ((Map)result.get(1)).get("artist"));
            TestXPathEntityProcessor.assertEquals((Object)"1982", ((Map)result.get(2)).get("year"));
        }
    }

    @Test
    public void withFieldsAndXpathStreamContinuesOnTimeout() throws Exception {
        this.simulateSlowReader = true;
        this.withFieldsAndXpathStream();
    }

    @Test
    public void streamWritesMessageAfterBlockedAttempt() throws Exception {
        this.simulateSlowResultProcessor = true;
        this.withFieldsAndXpathStream();
    }

    @Test
    public void streamStopsAfterInterrupt() throws Exception {
        this.simulateSlowResultProcessor = true;
        this.rowsToRead = 1;
        this.withFieldsAndXpathStream();
    }

    @Test
    public void withDefaultSolrAndXsl() throws Exception {
        Map row;
        File tmpdir = TestXPathEntityProcessor.createTempDir().toFile();
        AbstractDataImportHandlerTestCase.createFile(tmpdir, "x.xsl", xsl.getBytes(StandardCharsets.UTF_8), false);
        Map entityAttrs = TestXPathEntityProcessor.createMap("name", "e", "useSolrAddSchema", "true", "xsl", "" + new File(tmpdir, "x.xsl").toURI(), "url", "cd.xml");
        AbstractDataImportHandlerTestCase.TestContext c = TestXPathEntityProcessor.getContext(null, new VariableResolver(), this.getDataSource(cdData), "FULL_DUMP", null, entityAttrs);
        XPathEntityProcessor xPathEntityProcessor = new XPathEntityProcessor();
        xPathEntityProcessor.init((Context)c);
        ArrayList<Map> result = new ArrayList<Map>();
        while ((row = xPathEntityProcessor.nextRow()) != null) {
            result.add(row);
        }
        TestXPathEntityProcessor.assertEquals((long)3L, (long)result.size());
        TestXPathEntityProcessor.assertEquals((Object)"Empire Burlesque", ((Map)result.get(0)).get("title"));
        TestXPathEntityProcessor.assertEquals((Object)"Bonnie Tyler", ((Map)result.get(1)).get("artist"));
        TestXPathEntityProcessor.assertEquals((Object)"1982", ((Map)result.get(2)).get("year"));
    }

    private DataSource<Reader> getDataSource(final String xml) {
        return new DataSource<Reader>(){

            public void init(Context context, Properties initProps) {
            }

            public void close() {
            }

            public Reader getData(String query) {
                return new StringReader(xml);
            }
        };
    }
}

