/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.XPathRecordReader;
import org.junit.Test;

public class TestXPathRecordReader
extends AbstractDataImportHandlerTestCase {
    @Test
    public void testBasic() {
        String xml = "<root>\n   <b><c>Hello C1</c>\n      <c>Hello C1</c>\n      </b>\n   <b><c>Hello C2</c>\n     </b>\n</root>";
        XPathRecordReader rr = new XPathRecordReader("/root/b");
        rr.addField("c", "/root/b/c", true);
        List l = rr.getAllRecords((Reader)new StringReader(xml));
        TestXPathRecordReader.assertEquals((long)2L, (long)l.size());
        TestXPathRecordReader.assertEquals((long)2L, (long)((List)((Map)l.get(0)).get("c")).size());
        TestXPathRecordReader.assertEquals((long)1L, (long)((List)((Map)l.get(1)).get("c")).size());
    }

    @Test
    public void testAttributes() {
        String xml = "<root>\n   <b a=\"x0\" b=\"y0\" />\n   <b a=\"x1\" b=\"y1\" />\n   <b a=\"x2\" b=\"y2\" />\n</root>";
        XPathRecordReader rr = new XPathRecordReader("/root/b");
        rr.addField("a", "/root/b/@a", false);
        rr.addField("b", "/root/b/@b", false);
        List l = rr.getAllRecords((Reader)new StringReader(xml));
        TestXPathRecordReader.assertEquals((long)3L, (long)l.size());
        TestXPathRecordReader.assertEquals((Object)"x0", ((Map)l.get(0)).get("a"));
        TestXPathRecordReader.assertEquals((Object)"x1", ((Map)l.get(1)).get("a"));
        TestXPathRecordReader.assertEquals((Object)"x2", ((Map)l.get(2)).get("a"));
        TestXPathRecordReader.assertEquals((Object)"y0", ((Map)l.get(0)).get("b"));
        TestXPathRecordReader.assertEquals((Object)"y1", ((Map)l.get(1)).get("b"));
        TestXPathRecordReader.assertEquals((Object)"y2", ((Map)l.get(2)).get("b"));
    }

    @Test
    public void testAttrInRoot() {
        String xml = "<r>\n<merchantProduct id=\"814636051\" mid=\"189973\">\n                   <in_stock type=\"stock-4\" />\n                   <condition type=\"cond-0\" />\n                   <price>301.46</price>\n   </merchantProduct>\n<merchantProduct id=\"814636052\" mid=\"189974\">\n                   <in_stock type=\"stock-5\" />\n                   <condition type=\"cond-1\" />\n                   <price>302.46</price>\n   </merchantProduct>\n\n</r>";
        XPathRecordReader rr = new XPathRecordReader("/r/merchantProduct");
        rr.addField("id", "/r/merchantProduct/@id", false);
        rr.addField("mid", "/r/merchantProduct/@mid", false);
        rr.addField("price", "/r/merchantProduct/price", false);
        rr.addField("conditionType", "/r/merchantProduct/condition/@type", false);
        List l = rr.getAllRecords((Reader)new StringReader(xml));
        Map m = (Map)l.get(0);
        TestXPathRecordReader.assertEquals((Object)"814636051", m.get("id"));
        TestXPathRecordReader.assertEquals((Object)"189973", m.get("mid"));
        TestXPathRecordReader.assertEquals((Object)"301.46", m.get("price"));
        TestXPathRecordReader.assertEquals((Object)"cond-0", m.get("conditionType"));
        m = (Map)l.get(1);
        TestXPathRecordReader.assertEquals((Object)"814636052", m.get("id"));
        TestXPathRecordReader.assertEquals((Object)"189974", m.get("mid"));
        TestXPathRecordReader.assertEquals((Object)"302.46", m.get("price"));
        TestXPathRecordReader.assertEquals((Object)"cond-1", m.get("conditionType"));
    }

    @Test
    public void testAttributes2Level() {
        String xml = "<root>\n<a>\n  <b a=\"x0\" b=\"y0\" />\n       <b a=\"x1\" b=\"y1\" />\n       <b a=\"x2\" b=\"y2\" />\n       </a></root>";
        XPathRecordReader rr = new XPathRecordReader("/root/a/b");
        rr.addField("a", "/root/a/b/@a", false);
        rr.addField("b", "/root/a/b/@b", false);
        List l = rr.getAllRecords((Reader)new StringReader(xml));
        TestXPathRecordReader.assertEquals((long)3L, (long)l.size());
        TestXPathRecordReader.assertEquals((Object)"x0", ((Map)l.get(0)).get("a"));
        TestXPathRecordReader.assertEquals((Object)"y1", ((Map)l.get(1)).get("b"));
    }

    @Test
    public void testAttributes2LevelHetero() {
        String xml = "<root>\n<a>\n   <b a=\"x0\" b=\"y0\" />\n        <b a=\"x1\" b=\"y1\" />\n        <b a=\"x2\" b=\"y2\" />\n        </a><x>\n   <b a=\"x4\" b=\"y4\" />\n        <b a=\"x5\" b=\"y5\" />\n        <b a=\"x6\" b=\"y6\" />\n        </x></root>";
        XPathRecordReader rr = new XPathRecordReader("/root/a | /root/x");
        rr.addField("a", "/root/a/b/@a", false);
        rr.addField("b", "/root/a/b/@b", false);
        rr.addField("a", "/root/x/b/@a", false);
        rr.addField("b", "/root/x/b/@b", false);
        ArrayList a = new ArrayList();
        ArrayList x = new ArrayList();
        rr.streamRecords((Reader)new StringReader(xml), (record, xpath) -> {
            if (record == null) {
                return;
            }
            if (xpath.equals("/root/a")) {
                a.add(record);
            }
            if (xpath.equals("/root/x")) {
                x.add(record);
            }
        });
        TestXPathRecordReader.assertEquals((long)1L, (long)a.size());
        TestXPathRecordReader.assertEquals((long)1L, (long)x.size());
    }

    @Test
    public void testAttributes2LevelMissingAttrVal() {
        String xml = "<root>\n<a>\n  <b a=\"x0\" b=\"y0\" />\n       <b a=\"x1\" b=\"y1\" />\n       </a><a>\n  <b a=\"x3\"  />\n       <b b=\"y4\" />\n       </a></root>";
        XPathRecordReader rr = new XPathRecordReader("/root/a");
        rr.addField("a", "/root/a/b/@a", true);
        rr.addField("b", "/root/a/b/@b", true);
        List l = rr.getAllRecords((Reader)new StringReader(xml));
        TestXPathRecordReader.assertEquals((long)2L, (long)l.size());
        TestXPathRecordReader.assertNull(((List)((Map)l.get(1)).get("a")).get(1));
        TestXPathRecordReader.assertNull(((List)((Map)l.get(1)).get("b")).get(0));
    }

    @Test
    public void testElems2LevelMissing() {
        String xml = "<root>\n\t<a>\n\t   <b>\n\t  <x>x0</x>\n\t            <y>y0</y>\n\t            </b>\n\t   <b>\n\t  <x>x1</x>\n\t            <y>y1</y>\n\t            </b>\n\t   </a>\n\t<a>\n\t   <b>\n\t  <x>x3</x>\n\t   </b>\n\t   <b>\n\t  <y>y4</y>\n\t   </b>\n\t   </a>\n</root>";
        XPathRecordReader rr = new XPathRecordReader("/root/a");
        rr.addField("a", "/root/a/b/x", true);
        rr.addField("b", "/root/a/b/y", true);
        List l = rr.getAllRecords((Reader)new StringReader(xml));
        TestXPathRecordReader.assertEquals((long)2L, (long)l.size());
        TestXPathRecordReader.assertNull(((List)((Map)l.get(1)).get("a")).get(1));
        TestXPathRecordReader.assertNull(((List)((Map)l.get(1)).get("b")).get(0));
    }

    @Test
    public void testElems2LevelEmpty() {
        String xml = "<root>\n\t<a>\n\t   <b>\n\t  <x>x0</x>\n\t            <y>y0</y>\n\t   </b>\n\t   <b>\n\t  <x></x>\n\t            <y>y1</y>\n\t   </b>\n\t</a>\n</root>";
        XPathRecordReader rr = new XPathRecordReader("/root/a");
        rr.addField("a", "/root/a/b/x", true);
        rr.addField("b", "/root/a/b/y", true);
        List l = rr.getAllRecords((Reader)new StringReader(xml));
        TestXPathRecordReader.assertEquals((long)1L, (long)l.size());
        TestXPathRecordReader.assertEquals((Object)"x0", ((List)((Map)l.get(0)).get("a")).get(0));
        TestXPathRecordReader.assertEquals((Object)"y0", ((List)((Map)l.get(0)).get("b")).get(0));
        TestXPathRecordReader.assertEquals((Object)"", ((List)((Map)l.get(0)).get("a")).get(1));
        TestXPathRecordReader.assertEquals((Object)"y1", ((List)((Map)l.get(0)).get("b")).get(1));
    }

    @Test
    public void testMixedContent() {
        String xml = "<xhtml:p xmlns:xhtml=\"http://xhtml.com/\" >This text is \n  <xhtml:b>bold</xhtml:b> and this text is \n  <xhtml:u>underlined</xhtml:u>!\n</xhtml:p>";
        XPathRecordReader rr = new XPathRecordReader("/p");
        rr.addField("p", "/p", true);
        rr.addField("b", "/p/b", true);
        rr.addField("u", "/p/u", true);
        List l = rr.getAllRecords((Reader)new StringReader(xml));
        Map row = (Map)l.get(0);
        TestXPathRecordReader.assertEquals((Object)"bold", ((List)row.get("b")).get(0));
        TestXPathRecordReader.assertEquals((Object)"underlined", ((List)row.get("u")).get(0));
        String p = (String)((List)row.get("p")).get(0);
        TestXPathRecordReader.assertTrue((boolean)p.contains("This text is"));
        TestXPathRecordReader.assertTrue((boolean)p.contains("and this text is"));
        TestXPathRecordReader.assertTrue((boolean)p.contains("!"));
        TestXPathRecordReader.assertFalse((boolean)p.contains("bold"));
    }

    @Test
    public void testMixedContentFlattened() {
        String xml = "<xhtml:p xmlns:xhtml=\"http://xhtml.com/\" >This text is \n  <xhtml:b>bold</xhtml:b> and this text is \n  <xhtml:u>underlined</xhtml:u>!\n</xhtml:p>";
        XPathRecordReader rr = new XPathRecordReader("/p");
        rr.addField("p", "/p", false, 1);
        List l = rr.getAllRecords((Reader)new StringReader(xml));
        Map row = (Map)l.get(0);
        TestXPathRecordReader.assertEquals((Object)"This text is \n  bold and this text is \n  underlined!", (Object)((String)row.get("p")).trim());
    }

    @Test
    public void testElems2LevelWithAttrib() {
        String xml = "<root>\n\t<a>\n\t   <b k=\"x\">\n\t                        <x>x0</x>\n\t                        <y></y>\n\t                        </b>\n\t                     <b k=\"y\">\n\t                        <x></x>\n\t                        <y>y1</y>\n\t                        </b>\n\t                     <b k=\"z\">\n\t                        <x>x2</x>\n\t                        <y>y2</y>\n\t                        </b>\n\t                </a>\n\t           <a>\n\t   <b>\n\t                        <x>x3</x>\n\t                        </b>\n\t                     <b>\n\t                     <y>y4</y>\n\t                        </b>\n\t               </a>\n</root>";
        XPathRecordReader rr = new XPathRecordReader("/root/a");
        rr.addField("x", "/root/a/b[@k]/x", true);
        rr.addField("y", "/root/a/b[@k]/y", true);
        List l = rr.getAllRecords((Reader)new StringReader(xml));
        TestXPathRecordReader.assertEquals((long)2L, (long)l.size());
        TestXPathRecordReader.assertEquals((long)3L, (long)((List)((Map)l.get(0)).get("x")).size());
        TestXPathRecordReader.assertEquals((long)3L, (long)((List)((Map)l.get(0)).get("y")).size());
        TestXPathRecordReader.assertEquals((Object)"x0", ((List)((Map)l.get(0)).get("x")).get(0));
        TestXPathRecordReader.assertEquals((Object)"", ((List)((Map)l.get(0)).get("y")).get(0));
        TestXPathRecordReader.assertEquals((Object)"", ((List)((Map)l.get(0)).get("x")).get(1));
        TestXPathRecordReader.assertEquals((Object)"y1", ((List)((Map)l.get(0)).get("y")).get(1));
        TestXPathRecordReader.assertEquals((Object)"x2", ((List)((Map)l.get(0)).get("x")).get(2));
        TestXPathRecordReader.assertEquals((Object)"y2", ((List)((Map)l.get(0)).get("y")).get(2));
        TestXPathRecordReader.assertEquals((long)0L, (long)((Map)l.get(1)).size());
    }

    @Test
    public void testElems2LevelWithAttribMultiple() {
        String xml = "<root>\n\t<a>\n\t   <b k=\"x\" m=\"n\" >\n\t             <x>x0</x>\n\t             <y>y0</y>\n\t             </b>\n\t          <b k=\"y\" m=\"p\">\n\t             <x>x1</x>\n\t             <y>y1</y>\n\t             </b>\n\t   </a>\n\t<a>\n\t   <b k=\"x\">\n\t             <x>x3</x>\n\t             </b>\n\t          <b m=\"n\">\n\t             <y>y4</y>\n\t             </b>\n\t   </a>\n</root>";
        XPathRecordReader rr = new XPathRecordReader("/root/a");
        rr.addField("x", "/root/a/b[@k][@m='n']/x", true);
        rr.addField("y", "/root/a/b[@k][@m='n']/y", true);
        List l = rr.getAllRecords((Reader)new StringReader(xml));
        TestXPathRecordReader.assertEquals((long)2L, (long)l.size());
        TestXPathRecordReader.assertEquals((long)1L, (long)((List)((Map)l.get(0)).get("x")).size());
        TestXPathRecordReader.assertEquals((long)1L, (long)((List)((Map)l.get(0)).get("y")).size());
        TestXPathRecordReader.assertEquals((long)0L, (long)((Map)l.get(1)).size());
    }

    @Test
    public void testElems2LevelWithAttribVal() {
        String xml = "<root>\n\t<a>\n   <b k=\"x\">\n\t                  <x>x0</x>\n\t                  <y>y0</y>\n\t                  </b>\n\t                <b k=\"y\">\n\t                  <x>x1</x>\n\t                  <y>y1</y>\n\t                  </b>\n\t                </a>\n\t        <a>\n   <b><x>x3</x></b>\n\t                <b><y>y4</y></b>\n\t</a>\n</root>";
        XPathRecordReader rr = new XPathRecordReader("/root/a");
        rr.addField("x", "/root/a/b[@k='x']/x", true);
        rr.addField("y", "/root/a/b[@k='x']/y", true);
        List l = rr.getAllRecords((Reader)new StringReader(xml));
        TestXPathRecordReader.assertEquals((long)2L, (long)l.size());
        TestXPathRecordReader.assertEquals((long)1L, (long)((List)((Map)l.get(0)).get("x")).size());
        TestXPathRecordReader.assertEquals((long)1L, (long)((List)((Map)l.get(0)).get("y")).size());
        TestXPathRecordReader.assertEquals((long)0L, (long)((Map)l.get(1)).size());
    }

    @Test
    public void testAttribValWithSlash() {
        String xml = "<root><b>\n  <a x=\"a/b\" h=\"hello-A\"/>  \n</b></root>";
        XPathRecordReader rr = new XPathRecordReader("/root/b");
        rr.addField("x", "/root/b/a[@x='a/b']/@h", false);
        List l = rr.getAllRecords((Reader)new StringReader(xml));
        TestXPathRecordReader.assertEquals((long)1L, (long)l.size());
        Map m = (Map)l.get(0);
        TestXPathRecordReader.assertEquals((Object)"hello-A", m.get("x"));
    }

    @Test
    public void testUnsupported_Xpaths() {
        String xml = "<root><b><a x=\"a/b\" h=\"hello-A\"/>  </b></root>";
        XPathRecordReader rr = null;
        try {
            rr = new XPathRecordReader("//b");
            TestXPathRecordReader.fail((String)"A RuntimeException was expected: //b forEach cannot begin with '//'.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            rr.addField("bold", "b", false);
            TestXPathRecordReader.fail((String)"A RuntimeException was expected: 'b' xpaths must begin with '/'.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testAny_decendent_from_root() {
        XPathRecordReader rr = new XPathRecordReader("/anyd/contenido");
        rr.addField("descdend", "//boo", true);
        rr.addField("inr_descd", "//boo/i", false);
        rr.addField("cont", "/anyd/contenido", false);
        rr.addField("id", "/anyd/contenido/@id", false);
        rr.addField("status", "/anyd/status", false);
        rr.addField("title", "/anyd/contenido/titulo", false, 1);
        rr.addField("resume", "/anyd/contenido/resumen", false);
        rr.addField("text", "/anyd/contenido/texto", false);
        String xml = "<anyd>\n  this <boo>top level</boo> is ignored because it is external to the forEach\n  <status>as is <boo>this element</boo></status>\n  <contenido id=\"10097\" idioma=\"cat\">\n    This one is <boo>not ignored as it's</boo> inside a forEach\n    <antetitulo><i> big <boo>antler</boo></i></antetitulo>\n    <titulo>  My <i>flattened <boo>title</boo></i> </titulo>\n    <resumen> My summary <i>skip this!</i>  </resumen>\n    <texto>   <boo>Within the body of</boo>My text</texto>\n    <p>Access <boo>inner <i>sub clauses</i> as well</boo></p>\n    </contenido>\n</anyd>";
        List l = rr.getAllRecords((Reader)new StringReader(xml));
        TestXPathRecordReader.assertEquals((long)1L, (long)l.size());
        Map m = (Map)l.get(0);
        TestXPathRecordReader.assertEquals((Object)"This one is  inside a forEach", (Object)m.get("cont").toString().trim());
        TestXPathRecordReader.assertEquals((Object)"10097", m.get("id"));
        TestXPathRecordReader.assertEquals((Object)"My flattened title", (Object)m.get("title").toString().trim());
        TestXPathRecordReader.assertEquals((Object)"My summary", (Object)m.get("resume").toString().trim());
        TestXPathRecordReader.assertEquals((Object)"My text", (Object)m.get("text").toString().trim());
        TestXPathRecordReader.assertEquals((Object)"not ignored as it's", (Object)((String)((List)m.get("descdend")).get(0)));
        TestXPathRecordReader.assertEquals((Object)"antler", (Object)((String)((List)m.get("descdend")).get(1)));
        TestXPathRecordReader.assertEquals((Object)"Within the body of", (Object)((String)((List)m.get("descdend")).get(2)));
        TestXPathRecordReader.assertEquals((Object)"inner  as well", (Object)((String)((List)m.get("descdend")).get(3)));
        TestXPathRecordReader.assertEquals((Object)"sub clauses", (Object)m.get("inr_descd").toString().trim());
    }

    @Test
    public void testAny_decendent_of_a_child1() {
        XPathRecordReader rr = new XPathRecordReader("/anycd");
        rr.addField("descdend", "/anycd//boo", true);
        String xml = "<anycd>\n  this <boo>top level</boo> is ignored because it is external to the forEach\n  <status>as is <boo>this element</boo></status>\n  <contenido id=\"10097\" idioma=\"cat\">\n    This one is <boo>not ignored as it's</boo> inside a forEach\n    <antetitulo><i> big <boo>antler</boo></i></antetitulo>\n    <titulo>  My <i>flattened <boo>title</boo></i> </titulo>\n    <resumen> My summary <i>skip this!</i>  </resumen>\n    <texto>   <boo>Within the body of</boo>My text</texto>\n    <p>Access <boo>inner <i>sub clauses</i> as well</boo></p>\n    </contenido>\n</anycd>";
        List l = rr.getAllRecords((Reader)new StringReader(xml));
        TestXPathRecordReader.assertEquals((long)1L, (long)l.size());
        Map m = (Map)l.get(0);
        TestXPathRecordReader.assertEquals((Object)"top level", (Object)((String)((List)m.get("descdend")).get(0)));
        TestXPathRecordReader.assertEquals((Object)"this element", (Object)((String)((List)m.get("descdend")).get(1)));
        TestXPathRecordReader.assertEquals((Object)"not ignored as it's", (Object)((String)((List)m.get("descdend")).get(2)));
        TestXPathRecordReader.assertEquals((Object)"antler", (Object)((String)((List)m.get("descdend")).get(3)));
        TestXPathRecordReader.assertEquals((Object)"title", (Object)((String)((List)m.get("descdend")).get(4)));
        TestXPathRecordReader.assertEquals((Object)"Within the body of", (Object)((String)((List)m.get("descdend")).get(5)));
        TestXPathRecordReader.assertEquals((Object)"inner  as well", (Object)((String)((List)m.get("descdend")).get(6)));
    }

    @Test
    public void testAny_decendent_of_a_child2() {
        XPathRecordReader rr = new XPathRecordReader("/anycd");
        rr.addField("descdend", "/anycd/contenido//boo", true);
        String xml = "<anycd>\n  this <boo>top level</boo> is ignored because it is external to the forEach\n  <status>as is <boo>this element</boo></status>\n  <contenido id=\"10097\" idioma=\"cat\">\n    This one is <boo>not ignored as it's</boo> inside a forEach\n    <antetitulo><i> big <boo>antler</boo></i></antetitulo>\n    <titulo>  My <i>flattened <boo>title</boo></i> </titulo>\n    <resumen> My summary <i>skip this!</i>  </resumen>\n    <texto>   <boo>Within the body of</boo>My text</texto>\n    <p>Access <boo>inner <i>sub clauses</i> as well</boo></p>\n    </contenido>\n</anycd>";
        List l = rr.getAllRecords((Reader)new StringReader(xml));
        TestXPathRecordReader.assertEquals((long)1L, (long)l.size());
        Map m = (Map)l.get(0);
        TestXPathRecordReader.assertEquals((Object)"not ignored as it's", ((List)m.get("descdend")).get(0));
        TestXPathRecordReader.assertEquals((Object)"antler", ((List)m.get("descdend")).get(1));
        TestXPathRecordReader.assertEquals((Object)"title", ((List)m.get("descdend")).get(2));
        TestXPathRecordReader.assertEquals((Object)"Within the body of", ((List)m.get("descdend")).get(3));
        TestXPathRecordReader.assertEquals((Object)"inner  as well", ((List)m.get("descdend")).get(4));
    }

    @Test
    public void testAnother() {
        String xml = "<root>\n       <contenido id=\"10097\" idioma=\"cat\">\n    <antetitulo></antetitulo>\n    <titulo>    This is my title             </titulo>\n    <resumen>   This is my summary           </resumen>\n    <texto>     This is the body of my text  </texto>\n    </contenido>\n</root>";
        XPathRecordReader rr = new XPathRecordReader("/root/contenido");
        rr.addField("id", "/root/contenido/@id", false);
        rr.addField("title", "/root/contenido/titulo", false);
        rr.addField("resume", "/root/contenido/resumen", false);
        rr.addField("text", "/root/contenido/texto", false);
        List l = rr.getAllRecords((Reader)new StringReader(xml));
        TestXPathRecordReader.assertEquals((long)1L, (long)l.size());
        Map m = (Map)l.get(0);
        TestXPathRecordReader.assertEquals((Object)"10097", m.get("id"));
        TestXPathRecordReader.assertEquals((Object)"This is my title", (Object)m.get("title").toString().trim());
        TestXPathRecordReader.assertEquals((Object)"This is my summary", (Object)m.get("resume").toString().trim());
        TestXPathRecordReader.assertEquals((Object)"This is the body of my text", (Object)m.get("text").toString().trim());
    }

    @Test
    public void testSameForEachAndXpath() {
        String xml = "<root>\n   <cat>\n     <name>hello</name>\n   </cat>\n   <item name=\"item name\"/>\n</root>";
        XPathRecordReader rr = new XPathRecordReader("/root/cat/name");
        rr.addField("catName", "/root/cat/name", false);
        List l = rr.getAllRecords((Reader)new StringReader(xml));
        TestXPathRecordReader.assertEquals((Object)"hello", ((Map)l.get(0)).get("catName"));
    }

    @Test
    public void testPutNullTest() {
        String xml = "<root>\n  <i>\n    <x>\n      <a>A.1.1</a>\n      <b>B.1.1</b>\n    </x>\n    <x>\n      <b>B.1.2</b>\n      <c>C.1.2</c>\n    </x>\n  </i>\n  <i>\n    <x>\n      <a>A.2.1</a>\n      <c>C.2.1</c>\n    </x>\n    <x>\n      <b>B.2.2</b>\n      <c>C.2.2</c>\n    </x>\n  </i>\n</root>";
        XPathRecordReader rr = new XPathRecordReader("/root/i");
        rr.addField("a", "/root/i/x/a", true);
        rr.addField("b", "/root/i/x/b", true);
        rr.addField("c", "/root/i/x/c", true);
        List l = rr.getAllRecords((Reader)new StringReader(xml));
        Map map = (Map)l.get(0);
        List a = (List)map.get("a");
        List b = (List)map.get("b");
        List c = (List)map.get("c");
        TestXPathRecordReader.assertEquals((Object)"A.1.1", a.get(0));
        TestXPathRecordReader.assertEquals((Object)"B.1.1", b.get(0));
        TestXPathRecordReader.assertNull(c.get(0));
        TestXPathRecordReader.assertNull(a.get(1));
        TestXPathRecordReader.assertEquals((Object)"B.1.2", b.get(1));
        TestXPathRecordReader.assertEquals((Object)"C.1.2", c.get(1));
        map = (Map)l.get(1);
        a = (List)map.get("a");
        b = (List)map.get("b");
        c = (List)map.get("c");
        TestXPathRecordReader.assertEquals((Object)"A.2.1", a.get(0));
        TestXPathRecordReader.assertNull(b.get(0));
        TestXPathRecordReader.assertEquals((Object)"C.2.1", c.get(0));
        TestXPathRecordReader.assertNull(a.get(1));
        TestXPathRecordReader.assertEquals((Object)"B.2.2", b.get(1));
        TestXPathRecordReader.assertEquals((Object)"C.2.2", c.get(1));
    }

    @Test
    public void testError() {
        String malformedXml = "<root>\n    <node>\n        <id>1</id>\n        <desc>test1</desc>\n    </node>\n    <node>\n        <id>2</id>\n        <desc>test2</desc>\n    </node>\n    <node>\n        <id/>3</id>\n        <desc>test3</desc>\n    </node>\n</root>";
        XPathRecordReader rr = new XPathRecordReader("/root/node");
        rr.addField("id", "/root/node/id", true);
        rr.addField("desc", "/root/node/desc", true);
        try {
            rr.getAllRecords((Reader)new StringReader(malformedXml));
            TestXPathRecordReader.fail((String)"A RuntimeException was expected: the input XML is invalid.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

