/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.cloud.AbstractZkTestCase;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.dataimport.AbstractDataImportHandlerTestCase;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.MockDataSource;
import org.apache.solr.handler.dataimport.ZKPropertiesWriter;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestZKPropertiesWriter
extends AbstractDataImportHandlerTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static ZkTestServer zkServer;
    protected static String zkDir;
    private static CoreContainer cc;
    private String dateFormat = "yyyy-MM-dd HH:mm:ss.SSSSSS";

    @BeforeClass
    public static void dihZk_beforeClass() throws Exception {
        zkDir = TestZKPropertiesWriter.createTempDir((String)"zkData").toFile().getAbsolutePath();
        zkServer = new ZkTestServer(zkDir);
        zkServer.run();
        System.setProperty("solrcloud.skip.autorecovery", "true");
        System.setProperty("zkHost", zkServer.getZkAddress());
        System.setProperty("jetty.port", "0000");
        AbstractZkTestCase.buildZooKeeper((String)zkServer.getZkHost(), (String)zkServer.getZkAddress(), (File)TestZKPropertiesWriter.getFile((String)"dih/solr"), (String)"dataimport-solrconfig.xml", (String)"dataimport-schema.xml");
        cc = TestZKPropertiesWriter.createDefaultCoreContainer((Path)TestZKPropertiesWriter.getFile((String)"dih/solr").toPath());
    }

    @Before
    public void beforeDihZKTest() throws Exception {
    }

    @After
    public void afterDihZkTest() throws Exception {
        MockDataSource.clearCache();
    }

    @AfterClass
    public static void dihZk_afterClass() throws Exception {
        cc.shutdown();
        zkServer.shutdown();
        zkServer = null;
        zkDir = null;
        cc = null;
    }

    @Test
    @SuppressForbidden(reason="Needs currentTimeMillis to construct date stamps")
    public void testZKPropertiesWriter() throws Exception {
        TestZKPropertiesWriter.assertTrue((String)"Not using ZooKeeper", (boolean)h.getCoreContainer().isZooKeeperAware());
        h.getCoreContainer().getZkController().getZkStateReader().getLeaderUrl("collection1", "shard1", 30000);
        TestZKPropertiesWriter.assertQ((String)"test query on empty index", (SolrQueryRequest)this.request("qlkciyopsbgzyvkylsjhchghjrdf"), (String[])new String[]{"//result[@numFound='0']"});
        SimpleDateFormat errMsgFormat = new SimpleDateFormat(this.dateFormat, Locale.ROOT);
        TestZKPropertiesWriter.delQ((String)"*:*");
        TestZKPropertiesWriter.commit((String[])new String[0]);
        SimpleDateFormat df = new SimpleDateFormat(this.dateFormat, Locale.ROOT);
        Date oneSecondAgo = new Date(System.currentTimeMillis() - 1000L);
        HashMap<String, String> init = new HashMap<String, String>();
        init.put("dateFormat", this.dateFormat);
        ZKPropertiesWriter spw = new ZKPropertiesWriter();
        spw.init(new DataImporter(h.getCore(), "dataimport"), init);
        Map props = new HashMap<String, Date>();
        props.put("SomeDates.last_index_time", oneSecondAgo);
        props.put("last_index_time", oneSecondAgo);
        spw.persist(props);
        ArrayList<Map> rows = new ArrayList<Map>();
        rows.add(TestZKPropertiesWriter.createMap("id", "1", "year_s", "2013"));
        MockDataSource.setIterator((String)("select " + df.format(oneSecondAgo) + " from dummy"), rows.iterator());
        h.query("/dataimport", (SolrQueryRequest)lrf.makeRequest(new String[]{"command", "full-import", "dataConfig", this.generateConfig(), "clean", "true", "commit", "true", "synchronous", "true", "indent", "true"}));
        props = spw.readIndexerProperties();
        Date entityDate = df.parse((String)props.get("SomeDates.last_index_time"));
        Date docDate = df.parse((String)props.get("last_index_time"));
        Assert.assertTrue((String)("This date: " + errMsgFormat.format(oneSecondAgo) + " should be prior to the document date: " + errMsgFormat.format(docDate)), (docDate.getTime() - oneSecondAgo.getTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)("This date: " + errMsgFormat.format(oneSecondAgo) + " should be prior to the entity date: " + errMsgFormat.format(entityDate)), (entityDate.getTime() - oneSecondAgo.getTime() > 0L ? 1 : 0) != 0);
        TestZKPropertiesWriter.assertQ((SolrQueryRequest)this.request("*:*"), (String[])new String[]{"//*[@numFound='1']", "//doc/str[@name=\"year_s\"]=\"2013\""});
    }

    public SolrQueryRequest request(String ... q) {
        LocalSolrQueryRequest req = lrf.makeRequest(q);
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add(req.getParams());
        params.set("distrib", true);
        req.setParams((SolrParams)params);
        return req;
    }

    protected String generateConfig() {
        StringBuilder sb = new StringBuilder();
        sb.append("<dataConfig> \n");
        sb.append("<propertyWriter dateFormat=\"" + this.dateFormat + "\" type=\"ZKPropertiesWriter\" />\n");
        sb.append("<dataSource name=\"mock\" type=\"MockDataSource\"/>\n");
        sb.append("<document name=\"TestSimplePropertiesWriter\"> \n");
        sb.append("<entity name=\"SomeDates\" processor=\"SqlEntityProcessor\" dataSource=\"mock\" ");
        sb.append("query=\"select ${dih.last_index_time} from dummy\" >\n");
        sb.append("<field column=\"AYEAR_S\" name=\"year_s\" /> \n");
        sb.append("</entity>\n");
        sb.append("</document> \n");
        sb.append("</dataConfig> \n");
        String config = sb.toString();
        log.debug(config);
        return config;
    }
}

