/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.solr.common.EmptyEntityResolver;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.XMLErrorLogger;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DIHProperties;
import org.apache.solr.handler.dataimport.DIHWriter;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.DateFormatEvaluator;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.Evaluator;
import org.apache.solr.handler.dataimport.JdbcDataSource;
import org.apache.solr.handler.dataimport.RequestInfo;
import org.apache.solr.handler.dataimport.SolrQueryEscapingEvaluator;
import org.apache.solr.handler.dataimport.SqlEscapingEvaluator;
import org.apache.solr.handler.dataimport.UrlEvaluator;
import org.apache.solr.handler.dataimport.config.ConfigParseUtil;
import org.apache.solr.handler.dataimport.config.DIHConfiguration;
import org.apache.solr.handler.dataimport.config.Entity;
import org.apache.solr.handler.dataimport.config.PropertyWriter;
import org.apache.solr.handler.dataimport.config.Script;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.util.SystemIdResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class DataImporter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final XMLErrorLogger XMLLOG = new XMLErrorLogger(LOG);
    private Status status = Status.IDLE;
    private DIHConfiguration config;
    private Date indexStartTime;
    private Properties store = new Properties();
    private Map<String, Map<String, String>> requestLevelDataSourceProps = new HashMap<String, Map<String, String>>();
    private IndexSchema schema;
    public DocBuilder docBuilder;
    public DocBuilder.Statistics cumulativeStatistics = new DocBuilder.Statistics();
    private SolrCore core;
    private Map<String, Object> coreScopeSession = new ConcurrentHashMap<String, Object>();
    private ReentrantLock importLock = new ReentrantLock();
    private boolean isDeltaImportSupported = false;
    private final String handlerName;
    static final ThreadLocal<AtomicLong> QUERY_COUNT = new ThreadLocal<AtomicLong>(){

        @Override
        protected AtomicLong initialValue() {
            return new AtomicLong();
        }
    };
    public static final String COLUMN = "column";
    public static final String TYPE = "type";
    public static final String DATA_SRC = "dataSource";
    public static final String MULTI_VALUED = "multiValued";
    public static final String NAME = "name";
    public static final String STATUS_MSGS = "status-messages";
    public static final String FULL_IMPORT_CMD = "full-import";
    public static final String IMPORT_CMD = "import";
    public static final String DELTA_IMPORT_CMD = "delta-import";
    public static final String ABORT_CMD = "abort";
    public static final String DEBUG_MODE = "debug";
    public static final String RELOAD_CONF_CMD = "reload-config";
    public static final String SHOW_CONF_CMD = "show-config";

    DataImporter() {
        this.handlerName = "dataimport";
    }

    DataImporter(SolrCore core, String handlerName) {
        this.handlerName = handlerName;
        this.core = core;
        this.schema = core.getLatestSchema();
    }

    boolean maybeReloadConfiguration(RequestInfo params, NamedList<?> defaultParams) throws IOException {
        if (this.importLock.tryLock()) {
            boolean success = false;
            try {
                if (null != params.getRequest() && this.schema != params.getRequest().getSchema()) {
                    this.schema = params.getRequest().getSchema();
                }
                String dataConfigText = params.getDataConfig();
                String dataconfigFile = params.getConfigFile();
                InputSource is = null;
                if (dataConfigText != null && dataConfigText.length() > 0) {
                    is = new InputSource(new StringReader(dataConfigText));
                } else if (dataconfigFile != null) {
                    is = new InputSource(this.core.getResourceLoader().openResource(dataconfigFile));
                    is.setSystemId(SystemIdResolver.createSystemIdFromResourceName((String)dataconfigFile));
                    LOG.info("Loading DIH Configuration: " + dataconfigFile);
                }
                if (is != null) {
                    this.config = this.loadDataConfig(is);
                    success = true;
                }
                HashMap dsProps = new HashMap();
                if (defaultParams != null) {
                    for (int position = 0; position < defaultParams.size() && defaultParams.getName(position) != null; ++position) {
                        String name = defaultParams.getName(position);
                        if (!name.equals("datasource")) continue;
                        success = true;
                        NamedList dsConfig = (NamedList)defaultParams.getVal(position);
                        LOG.info("Getting configuration for Global Datasource...");
                        HashMap<String, String> props = new HashMap<String, String>();
                        for (int i = 0; i < dsConfig.size(); ++i) {
                            props.put(dsConfig.getName(i), dsConfig.getVal(i).toString());
                        }
                        LOG.info("Adding properties to datasource: " + props);
                        dsProps.put((String)dsConfig.get(NAME), props);
                    }
                }
                this.requestLevelDataSourceProps = Collections.unmodifiableMap(dsProps);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                this.importLock.unlock();
            }
            return success;
        }
        return false;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public IndexSchema getSchema() {
        return this.schema;
    }

    void loadAndInit(String configStr) {
        this.config = this.loadDataConfig(new InputSource(new StringReader(configStr)));
    }

    void loadAndInit(InputSource configFile) {
        this.config = this.loadDataConfig(configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DIHConfiguration loadDataConfig(InputSource configFile) {
        DIHConfiguration dihcfg = null;
        try {
            Document document;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            if (this.core != null && configFile.getSystemId() != null) {
                try {
                    dbf.setXIncludeAware(true);
                    dbf.setNamespaceAware(true);
                }
                catch (UnsupportedOperationException e) {
                    LOG.warn("XML parser doesn't support XInclude option");
                }
            }
            DocumentBuilder builder = dbf.newDocumentBuilder();
            if (this.core != null && configFile.getSystemId() != null) {
                builder.setEntityResolver((EntityResolver)new SystemIdResolver((ResourceLoader)this.core.getResourceLoader()));
            } else {
                builder.setEntityResolver(EmptyEntityResolver.SAX_INSTANCE);
            }
            builder.setErrorHandler((ErrorHandler)XMLLOG);
            try {
                document = builder.parse(configFile);
            }
            finally {
                IOUtils.closeQuietly((InputStream)configFile.getByteStream());
            }
            dihcfg = this.readFromXml(document);
            LOG.info("Data Configuration loaded successfully");
        }
        catch (Exception e) {
            throw new DataImportHandlerException(500, "Data Config problem: " + e.getMessage(), e);
        }
        for (Entity e : dihcfg.getEntities()) {
            if (!e.getAllAttributes().containsKey("deltaQuery")) continue;
            this.isDeltaImportSupported = true;
            break;
        }
        return dihcfg;
    }

    /*
     * WARNING - void declaration
     */
    public DIHConfiguration readFromXml(Document xmlDocument) {
        void var12_19;
        Iterator iterator;
        List<Element> dataSourceTags;
        List<Element> functionTags;
        ArrayList<Map<String, String>> functions = new ArrayList<Map<String, String>>();
        Script script = null;
        HashMap<String, Map<String, String>> dataSources = new HashMap<String, Map<String, String>>();
        NodeList dataConfigTags = xmlDocument.getElementsByTagName("dataConfig");
        if (dataConfigTags == null || dataConfigTags.getLength() == 0) {
            throw new DataImportHandlerException(500, "the root node '<dataConfig>' is missing");
        }
        Element e = (Element)dataConfigTags.item(0);
        List<Element> documentTags = ConfigParseUtil.getChildNodes(e, "document");
        if (documentTags.isEmpty()) {
            throw new DataImportHandlerException(500, "DataImportHandler configuration file must have one <document> node.");
        }
        List<Element> scriptTags = ConfigParseUtil.getChildNodes(e, "script");
        if (!scriptTags.isEmpty()) {
            script = new Script(scriptTags.get(0));
        }
        if (!(functionTags = ConfigParseUtil.getChildNodes(e, "function")).isEmpty()) {
            for (Element element : functionTags) {
                String func = ConfigParseUtil.getStringAttribute(element, NAME, null);
                String clz = ConfigParseUtil.getStringAttribute(element, "class", null);
                if (func == null || clz == null) {
                    throw new DataImportHandlerException(500, "<function> must have a 'name' and 'class' attributes");
                }
                functions.add(ConfigParseUtil.getAllAttributes(element));
            }
        }
        if (!(dataSourceTags = ConfigParseUtil.getChildNodes(e, DATA_SRC)).isEmpty()) {
            for (Element element3 : dataSourceTags) {
                HashMap<String, String> p = new HashMap<String, String>();
                HashMap<String, String> attrs = ConfigParseUtil.getAllAttributes(element3);
                for (Map.Entry<String, String> entry : attrs.entrySet()) {
                    p.put(entry.getKey(), entry.getValue());
                }
                dataSources.put((String)p.get(NAME), p);
            }
        }
        if (dataSources.get(null) == null && (iterator = dataSources.values().iterator()).hasNext()) {
            Map properties = (Map)iterator.next();
            dataSources.put(null, properties);
        }
        Object var12_16 = null;
        List<Element> propertyWriterTags = ConfigParseUtil.getChildNodes(e, "propertyWriter");
        if (propertyWriterTags.isEmpty()) {
            boolean zookeeper = false;
            if (this.core != null && this.core.getCoreContainer().isZooKeeperAware()) {
                zookeeper = true;
            }
            PropertyWriter propertyWriter = new PropertyWriter(zookeeper ? "ZKPropertiesWriter" : "SimplePropertiesWriter", Collections.emptyMap());
        } else {
            if (propertyWriterTags.size() > 1) {
                throw new DataImportHandlerException(500, "Only one propertyWriter can be configured.");
            }
            Element pwElement = propertyWriterTags.get(0);
            String type = null;
            HashMap<String, String> params = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : ConfigParseUtil.getAllAttributes(pwElement).entrySet()) {
                if (TYPE.equals(entry.getKey())) {
                    type = entry.getValue();
                    continue;
                }
                params.put(entry.getKey(), entry.getValue());
            }
            if (type == null) {
                throw new DataImportHandlerException(500, "The propertyWriter element must specify type");
            }
            PropertyWriter propertyWriter = new PropertyWriter(type, params);
        }
        return new DIHConfiguration(documentTags.get(0), this, functions, script, dataSources, (PropertyWriter)var12_19);
    }

    private DIHProperties createPropertyWriter() {
        DIHProperties propWriter = null;
        PropertyWriter configPw = this.config.getPropertyWriter();
        try {
            Class writerClass = DocBuilder.loadClass(configPw.getType(), this.core);
            propWriter = (DIHProperties)writerClass.newInstance();
            propWriter.init(this, configPw.getParameters());
        }
        catch (Exception e) {
            throw new DataImportHandlerException(500, "Unable to PropertyWriter implementation:" + configPw.getType(), e);
        }
        return propWriter;
    }

    public DIHConfiguration getConfig() {
        return this.config;
    }

    Date getIndexStartTime() {
        return this.indexStartTime;
    }

    void setIndexStartTime(Date indextStartTime) {
        this.indexStartTime = indextStartTime;
    }

    void store(Object key, Object value) {
        this.store.put(key, value);
    }

    Object retrieve(Object key) {
        return this.store.get(key);
    }

    public DataSource getDataSourceInstance(Entity key, String name, Context ctx) {
        Map<String, String> p = this.requestLevelDataSourceProps.get(name);
        if (p == null) {
            p = this.config.getDataSources().get(name);
        }
        if (p == null) {
            p = this.requestLevelDataSourceProps.get(null);
        }
        if (p == null) {
            p = this.config.getDataSources().get(null);
        }
        if (p == null) {
            throw new DataImportHandlerException(500, "No dataSource :" + name + " available for entity :" + key.getName());
        }
        String type = p.get(TYPE);
        DataSource dataSrc = null;
        if (type == null) {
            dataSrc = new JdbcDataSource();
        } else {
            try {
                dataSrc = (DataSource)DocBuilder.loadClass(type, this.getCore()).newInstance();
            }
            catch (Exception e) {
                DataImportHandlerException.wrapAndThrow(500, e, "Invalid type for data source: " + type);
            }
        }
        try {
            Properties copyProps = new Properties();
            copyProps.putAll(p);
            Map<String, Object> map = ctx.getRequestParameters();
            if (map.containsKey("rows")) {
                int rows = Integer.parseInt((String)map.get("rows"));
                if (map.containsKey("start")) {
                    rows += Integer.parseInt((String)map.get("start"));
                }
                copyProps.setProperty("maxRows", String.valueOf(rows));
            }
            dataSrc.init(ctx, copyProps);
        }
        catch (Exception e) {
            DataImportHandlerException.wrapAndThrow(500, e, "Failed to initialize DataSource: " + key.getDataSourceName());
        }
        return dataSrc;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isBusy() {
        return this.importLock.isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFullImport(DIHWriter writer, RequestInfo requestParams) {
        LOG.info("Starting Full Import");
        this.setStatus(Status.RUNNING_FULL_DUMP);
        try {
            DIHProperties dihPropWriter = this.createPropertyWriter();
            this.setIndexStartTime(dihPropWriter.getCurrentTimestamp());
            this.docBuilder = new DocBuilder(this, writer, dihPropWriter, requestParams);
            this.checkWritablePersistFile(writer, dihPropWriter);
            this.docBuilder.execute();
            if (!requestParams.isDebug()) {
                this.cumulativeStatistics.add(this.docBuilder.importStatistics);
            }
        }
        catch (Exception e) {
            SolrException.log((Logger)LOG, (String)"Full Import failed", (Throwable)e);
            this.docBuilder.handleError("Full Import failed", e);
        }
        finally {
            this.setStatus(Status.IDLE);
            DocBuilder.INSTANCE.set(null);
        }
    }

    private void checkWritablePersistFile(DIHWriter writer, DIHProperties dihPropWriter) {
        if (this.isDeltaImportSupported && !dihPropWriter.isWritable()) {
            throw new DataImportHandlerException(500, "Properties is not writable. Delta imports are supported by data config but will not work.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeltaImport(DIHWriter writer, RequestInfo requestParams) {
        LOG.info("Starting Delta Import");
        this.setStatus(Status.RUNNING_DELTA_DUMP);
        try {
            DIHProperties dihPropWriter = this.createPropertyWriter();
            this.setIndexStartTime(dihPropWriter.getCurrentTimestamp());
            this.docBuilder = new DocBuilder(this, writer, dihPropWriter, requestParams);
            this.checkWritablePersistFile(writer, dihPropWriter);
            this.docBuilder.execute();
            if (!requestParams.isDebug()) {
                this.cumulativeStatistics.add(this.docBuilder.importStatistics);
            }
        }
        catch (Exception e) {
            LOG.error("Delta Import Failed", (Throwable)e);
            this.docBuilder.handleError("Delta Import Failed", e);
        }
        finally {
            this.setStatus(Status.IDLE);
            DocBuilder.INSTANCE.set(null);
        }
    }

    public void runAsync(RequestInfo reqParams, DIHWriter sw) {
        new Thread(() -> this.runCmd(reqParams, sw)).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runCmd(RequestInfo reqParams, DIHWriter sw) {
        String command = reqParams.getCommand();
        if (command.equals(ABORT_CMD)) {
            if (this.docBuilder != null) {
                this.docBuilder.abort();
            }
            return;
        }
        if (!this.importLock.tryLock()) {
            LOG.warn("Import command failed . another import is running");
            return;
        }
        try {
            if (FULL_IMPORT_CMD.equals(command) || IMPORT_CMD.equals(command)) {
                this.doFullImport(sw, reqParams);
            } else if (command.equals(DELTA_IMPORT_CMD)) {
                this.doDeltaImport(sw, reqParams);
            }
        }
        finally {
            this.importLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> getStatusMessages() {
        Map statusMessages = (Map)this.retrieve(STATUS_MSGS);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (statusMessages != null) {
            Map map = statusMessages;
            synchronized (map) {
                Iterator iterator = statusMessages.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry e = o = iterator.next();
                    result.put((String)e.getKey(), e.getValue().toString());
                }
            }
        }
        return result;
    }

    public DocBuilder getDocBuilder() {
        return this.docBuilder;
    }

    public DocBuilder getDocBuilder(DIHWriter writer, RequestInfo requestParams) {
        DIHProperties dihPropWriter = this.createPropertyWriter();
        return new DocBuilder(this, writer, dihPropWriter, requestParams);
    }

    Map<String, Evaluator> getEvaluators() {
        return this.getEvaluators(this.config.getFunctions());
    }

    Map<String, Evaluator> getEvaluators(List<Map<String, String>> fn) {
        HashMap<String, Evaluator> evaluators = new HashMap<String, Evaluator>();
        evaluators.put("formatDate", new DateFormatEvaluator());
        evaluators.put("escapeSql", new SqlEscapingEvaluator());
        evaluators.put("encodeUrl", new UrlEvaluator());
        evaluators.put("escapeQueryChars", new SolrQueryEscapingEvaluator());
        SolrCore core = this.docBuilder == null ? null : this.docBuilder.dataImporter.getCore();
        for (Map<String, String> map : fn) {
            try {
                evaluators.put(map.get(NAME), (Evaluator)DocBuilder.loadClass(map.get("class"), core).newInstance());
            }
            catch (Exception e) {
                DataImportHandlerException.wrapAndThrow(500, e, "Unable to instantiate evaluator: " + map.get("class"));
            }
        }
        return evaluators;
    }

    public SolrCore getCore() {
        return this.core;
    }

    void putToCoreScopeSession(String key, Object val) {
        this.coreScopeSession.put(key, val);
    }

    Object getFromCoreScopeSession(String key) {
        return this.coreScopeSession.get(key);
    }

    static final class MSG {
        public static final String NO_CONFIG_FOUND = "Configuration not found";
        public static final String NO_INIT = "DataImportHandler started. Not Initialized. No commands can be run";
        public static final String INVALID_CONFIG = "FATAL: Could not create importer. DataImporter config invalid";
        public static final String LOAD_EXP = "Exception while loading DataImporter";
        public static final String JMX_DESC = "Manage data import from databases to Solr";
        public static final String CMD_RUNNING = "A command is still running...";
        public static final String DEBUG_NOT_ENABLED = "Debug not enabled. Add a tag <str name=\"enableDebug\">true</str> in solrconfig.xml";
        public static final String CONFIG_RELOADED = "Configuration Re-loaded sucessfully";
        public static final String CONFIG_NOT_RELOADED = "Configuration NOT Re-loaded...Data Importer is busy.";
        public static final String TOTAL_DOC_PROCESSED = "Total Documents Processed";
        public static final String TOTAL_FAILED_DOCS = "Total Documents Failed";
        public static final String TOTAL_QUERIES_EXECUTED = "Total Requests made to DataSource";
        public static final String TOTAL_ROWS_EXECUTED = "Total Rows Fetched";
        public static final String TOTAL_DOCS_DELETED = "Total Documents Deleted";
        public static final String TOTAL_DOCS_SKIPPED = "Total Documents Skipped";

        MSG() {
        }
    }

    public static enum Status {
        IDLE,
        RUNNING_FULL_DUMP,
        RUNNING_DELTA_DUMP,
        JOB_FAILED;

    }
}

