/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport.config;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.config.ConfigParseUtil;
import org.apache.solr.handler.dataimport.config.Entity;
import org.apache.solr.handler.dataimport.config.EntityField;
import org.apache.solr.handler.dataimport.config.PropertyWriter;
import org.apache.solr.handler.dataimport.config.Script;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DIHConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String deleteQuery;
    private final List<Entity> entities;
    private final String onImportStart;
    private final String onImportEnd;
    private final String onError;
    private final List<Map<String, String>> functions;
    private final Script script;
    private final Map<String, Map<String, String>> dataSources;
    private final PropertyWriter propertyWriter;
    private final IndexSchema schema;
    private final Map<String, SchemaField> lowerNameVsSchemaField;

    public DIHConfiguration(Element element, DataImporter di, List<Map<String, String>> functions, Script script, Map<String, Map<String, String>> dataSources, PropertyWriter pw) {
        this.schema = di.getSchema();
        this.lowerNameVsSchemaField = null == this.schema ? Collections.emptyMap() : this.loadSchemaFieldMap();
        this.deleteQuery = ConfigParseUtil.getStringAttribute(element, "deleteQuery", null);
        this.onImportStart = ConfigParseUtil.getStringAttribute(element, "onImportStart", null);
        this.onImportEnd = ConfigParseUtil.getStringAttribute(element, "onImportEnd", null);
        this.onError = ConfigParseUtil.getStringAttribute(element, "onError", null);
        ArrayList<Entity> modEntities = new ArrayList<Entity>();
        List<Element> l = ConfigParseUtil.getChildNodes(element, "entity");
        boolean docRootFound = false;
        for (Element e : l) {
            Entity entity = new Entity(docRootFound, e, di, this, null);
            Map<String, EntityField> fields = this.gatherAllFields(di, entity);
            this.verifyWithSchema(fields);
            modEntities.add(entity);
        }
        this.entities = Collections.unmodifiableList(modEntities);
        if (functions == null) {
            functions = Collections.emptyList();
        }
        ArrayList<Map<String, String>> modFunc = new ArrayList<Map<String, String>>(functions.size());
        for (Map<String, String> f : functions) {
            modFunc.add(Collections.unmodifiableMap(f));
        }
        this.functions = Collections.unmodifiableList(modFunc);
        this.script = script;
        this.dataSources = Collections.unmodifiableMap(dataSources);
        this.propertyWriter = pw;
    }

    private void verifyWithSchema(Map<String, EntityField> fields) {
        Map schemaFields = null;
        schemaFields = this.schema == null ? Collections.emptyMap() : this.schema.getFields();
        for (Map.Entry entry : schemaFields.entrySet()) {
            SchemaField sf = (SchemaField)entry.getValue();
            if (fields.containsKey(sf.getName()) || !sf.isRequired()) continue;
            LOG.info(sf.getName() + " is a required field in SolrSchema . But not found in DataConfig");
        }
        for (Map.Entry<Object, Object> entry : fields.entrySet()) {
            EntityField fld = (EntityField)entry.getValue();
            SchemaField field = this.getSchemaField(fld.getName());
            if (field != null || DIHConfiguration.isSpecialCommand(fld.getName())) continue;
            LOG.info("The field :" + fld.getName() + " present in DataConfig does not have a counterpart in Solr Schema");
        }
    }

    private Map<String, EntityField> gatherAllFields(DataImporter di, Entity e) {
        HashMap<String, EntityField> fields = new HashMap<String, EntityField>();
        if (e.getFields() != null) {
            for (EntityField f : e.getFields()) {
                fields.put(f.getName(), f);
            }
        }
        for (Entity e1 : e.getChildren()) {
            fields.putAll(this.gatherAllFields(di, e1));
        }
        return fields;
    }

    private Map<String, SchemaField> loadSchemaFieldMap() {
        HashMap<String, SchemaField> modLnvsf = new HashMap<String, SchemaField>();
        for (Map.Entry entry : this.schema.getFields().entrySet()) {
            modLnvsf.put(((String)entry.getKey()).toLowerCase(Locale.ROOT), (SchemaField)entry.getValue());
        }
        return Collections.unmodifiableMap(modLnvsf);
    }

    public SchemaField getSchemaField(String caseInsensitiveName) {
        SchemaField schemaField = null;
        if (this.schema != null) {
            schemaField = this.schema.getFieldOrNull(caseInsensitiveName);
        }
        if (schemaField == null) {
            schemaField = this.lowerNameVsSchemaField.get(caseInsensitiveName.toLowerCase(Locale.ROOT));
        }
        return schemaField;
    }

    public String getDeleteQuery() {
        return this.deleteQuery;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public String getOnImportStart() {
        return this.onImportStart;
    }

    public String getOnImportEnd() {
        return this.onImportEnd;
    }

    public String getOnError() {
        return this.onError;
    }

    public List<Map<String, String>> getFunctions() {
        return this.functions;
    }

    public Map<String, Map<String, String>> getDataSources() {
        return this.dataSources;
    }

    public Script getScript() {
        return this.script;
    }

    public PropertyWriter getPropertyWriter() {
        return this.propertyWriter;
    }

    public IndexSchema getSchema() {
        return this.schema;
    }

    public static boolean isSpecialCommand(String fld) {
        return "$deleteDocById".equals(fld) || "$deleteDocByQuery".equals(fld) || "$docBoost".equals(fld) || "$skipDoc".equals(fld) || "$skipRow".equals(fld);
    }
}

